package com.rafian.random;

import java.io.Serializable;

/**
 * Random super interface.
 */
public interface IRandom extends Serializable {

  /**
   * Set seed for generator. Subsequent values will be based on the given seed.
   *
   * @param seed
   *          seed for the generator
   */
  public abstract void setSeed(long seed);

  /**
   * Gives a boolean.
   *
   * @return a boolean
   */
  public abstract boolean nextBoolean();

  /**
   * Gives an array of boolean.
   *
   * @param aNumber
   *          size of the array
   * @return an array of boolean
   */
  public abstract boolean[] nextBooleans(int aNumber);

  /**
   * Gives a short.
   *
   * @return a short
   */
  public abstract short nextShort();

  /**
   * Gives a double.
   *
   * @return a double
   */
  public abstract double nextDouble();

  /**
   * Gives a float.
   *
   * @return a float
   */
  public abstract float nextFloat();

  /**
   * Gives a double.
   *
   * @return a double
   */
  public abstract double nextGaussian();

  /**
   * Gives an int.
   *
   * @return an int
   */
  public abstract int nextInt();

  /**
   * Generates an int [min, max[
   *
   * @param aMin
   *          a min
   * @param aMax
   *          a max
   * @return a value between [min, max[
   */
  public abstract int nextInt(int aMin, int aMax);

  /**
   * Generates an int [min, max[
   *
   * @param aNumber
   *          the number of value you need
   * @param aMin
   *          a min
   * @param aMax
   *          a max
   * @return a value between [min, max[
   */
  public abstract int[] nextInts(int aNumber, int aMin, int aMax);

  /**
   * Gives a long.
   *
   * @return a long
   */
  public abstract long nextLong();

  /**
   * Gives a byte.
   *
   * @return a byte
   */
  public abstract byte nextByte();

}