package com.rafian.random;

import com.rafian.AbstractObject;

/**
 * A generic super class for random generator.
 */
public abstract class AbstractRandom extends AbstractObject implements IRandom {

  private static final long serialVersionUID = 1L;

  /**
   * Constructor.
   */
  public AbstractRandom() {
    super();
  }

  /**
   * Constructor.
   *
   * @param aSeed
   *          a seed
   */
  public AbstractRandom(long aSeed) {
    super();
    this.setSeed(aSeed);
  }

  @Override
  public abstract void setSeed(long seed);

  @Override
  public abstract boolean nextBoolean();

  @Override
  public abstract boolean[] nextBooleans(int aNumber);

  @Override
  public abstract double nextDouble();

  @Override
  public abstract float nextFloat();

  @Override
  public abstract double nextGaussian();

  @Override
  public abstract int nextInt();

  @Override
  public short nextShort() {
    return (short) this.nextInt(Short.MIN_VALUE, Short.MAX_VALUE + 1);
  }

  @Override
  public abstract int nextInt(int aMin, int aMax);

  @Override
  public abstract int[] nextInts(int aNumber, int aMin, int aMax);

  @Override
  public abstract long nextLong();

  @Override
  public abstract byte nextByte();

}
