package com.rafian;

import java.io.Serializable;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Priority;

/**
 * Mother object.
 */
public abstract class AbstractObject implements Serializable {

  private static final long serialVersionUID = 1L;

  /**
   * Constructor of the object.
   */
  protected AbstractObject() {
    super();
  }

  /**
   * Logs information. <br/>
   * With this method, you do not need to test is a level is active or not.
   *
   * @param aLevel
   *          a level (Log.XXX)
   * @param arg
   *          what to log, the message with NO '+'
   * @param anExp
   *          an exception if any
   */
  protected final void log(int aLevel, Object... arg) {

    final Log log = LogFactory.getLog(this.getClass());

    if ((aLevel == Priority.DEBUG_INT) && log.isDebugEnabled()) {
      StringBuilder msgBuild = new StringBuilder();
      Throwable error = AbstractObject.aggregateLogMessage(msgBuild, arg);
      String msg = msgBuild.toString();
      log.debug(msg, error);
    } else if ((aLevel == Priority.WARN_INT) && log.isWarnEnabled()) {
      StringBuilder msgBuild = new StringBuilder();
      Throwable error = AbstractObject.aggregateLogMessage(msgBuild, arg);
      String msg = msgBuild.toString();
      log.warn(msg, error);
    } else if ((aLevel == Level.TRACE_INT) && log.isTraceEnabled()) {
      StringBuilder msgBuild = new StringBuilder();
      Throwable error = AbstractObject.aggregateLogMessage(msgBuild, arg);
      String msg = msgBuild.toString();
      log.trace(msg, error);
    } else if ((aLevel == Priority.ERROR_INT) && log.isErrorEnabled()) {
      StringBuilder msgBuild = new StringBuilder();
      Throwable error = AbstractObject.aggregateLogMessage(msgBuild, arg);
      String msg = msgBuild.toString();
      log.error(msg, error);
    } else if ((aLevel == Priority.INFO_INT) && log.isInfoEnabled()) {
      StringBuilder msgBuild = new StringBuilder();
      Throwable error = AbstractObject.aggregateLogMessage(msgBuild, arg);
      String msg = msgBuild.toString();
      log.info(msg, error);
    } else if ((aLevel == Priority.FATAL_INT) && log.isFatalEnabled()) {
      StringBuilder msgBuild = new StringBuilder();
      Throwable error = AbstractObject.aggregateLogMessage(msgBuild, arg);
      String msg = msgBuild.toString();
      log.fatal(msg, error);
    }

  }

  /**
   * Log as debug.
   *
   * @param arg
   *          what to log, the message with NO '+'
   */
  protected final void logDebug(Object... arg) {
    this.log(Priority.DEBUG_INT, arg);
  }

  /**
   * Log as trace.
   *
   * @param arg
   *          what to log, the message with NO '+'
   */
  protected final void logTrace(Object... arg) {
    this.log(Level.TRACE_INT, arg);
  }

  /**
   * Log as error.
   *
   * @param arg
   *          what to log, the message with NO '+'
   */
  protected final void logError(Object... arg) {
    this.log(Priority.ERROR_INT, arg);
  }

  /**
   * Log as info.
   *
   * @param arg
   *          what to log, the message with NO '+'
   */
  protected final void logInfo(Object... arg) {
    this.log(Priority.INFO_INT, arg);
  }

  /**
   * Log as warn.
   *
   * @param arg
   *          what to log, the message with NO '+'
   */
  protected final void logWarn(Object... arg) {
    this.log(Priority.WARN_INT, arg);
  }

  /**
   * Log as fatal.
   *
   * @param arg
   *          what to log, the message with NO '+'
   */
  protected final void logFatal(Object... arg) {
    this.log(Priority.FATAL_INT, arg);
  }

  /**
   * Compose the log message.
   *
   * @param msg
   *          a message
   *
   * @param arg
   *          some messages with no '+'
   * @return all elements in one string
   */
  public static final Throwable aggregateLogMessage(StringBuilder msg, Object... arg) {
    Throwable result = null;
    if ((arg != null) && (arg.length > 0)) {
      for (Object lcElm : arg) {
        if (lcElm instanceof Throwable) {
          result = (Throwable) lcElm;
        } else {
          msg.append(lcElm);
        }
      }
    }
    return result;
  }

}
