#---------------------------------------------#
# <aw:description>Template for a Set with basic type (int, float, double, char, byte, long, boolean)</aw:description>
# <aw:version>1.1</aw:version>
# <aw:date>03/18/2004</aw:date>
# <aw:author>Ferret Renaud</aw:author>
#---------------------------------------------#


<aw:import>java.util.Collection</aw:import>
<aw:import>java.util.Collections</aw:import>
<aw:import>java.util.SortedSet</aw:import>
<aw:import>java.util.Set</aw:import>
<aw:import>java.util.ArrayList</aw:import>
<aw:import>java.util.List</aw:import>
<aw:import><aw:setType/></aw:import>
<aw:import>java.util.Comparator</aw:import>
<aw:import>java.util.Iterator</aw:import>

<aw:interface>java.lang.Cloneable</aw:interface>

<aw:field>
	/** The set. */
	protected Set itsSet;

</aw:field>

<aw:constructor name="c1">
	/**
	 * Constructor of the object.
	 */
	public <aw:className/>() {
		super();
		this.itsSet = new <aw:setType/>();
	}

</aw:constructor>

<aw:constructor name="c2">
	/**
	 * Constructor of the object.
	 * 
	 * @param aCollection what to put in the Set
	 */
	public <aw:className/>(Collection aCollection) {
		super();
		this.itsSet = new <aw:setType/>(aCollection);
	}
 
</aw:constructor>

<aw:method name="size">
	/**
	 * Returns the number of elements in this list. 
	 *
	 * @return the number of elements in this list.
	 */
	public int size() {
		return this.itsSet.size();
	}

</aw:method>

<aw:method name="isEmpty">
	/**
	 * Returns <tt>true</tt> if this list contains no elements.
	 *
	 * @return <tt>true</tt> if this list contains no elements.
	 */
	public boolean isEmpty() {
		return this.itsSet.isEmpty();
	}

</aw:method>

<aw:method name="iterator">
	/**
	 * Returns an iterator over the elements in this list in proper sequence.
	 *
	 * @return an iterator over the elements in this list in proper sequence.
	 */
	public Iterator iterator() {
		return this.itsSet.iterator();
	}

</aw:method>

<aw:method name="containsAll">
	/**
	 * Returns <tt>true</tt> if this list contains all of the elements of the 
	 * specified collection.
	 *
	 * @param aCollection collection to be checked for containment in this list.
	 * @return <tt>true</tt> if this list contains all of the elements of the 
	 * specified collection.
	 * 
	 */
	public boolean containsAll(Collection aCollection) {
		return this.itsSet.containsAll(aCollection);
	}

</aw:method>

<aw:method name="addAll1">
	/**
	 * Appends all of the elements in the specified collection to the end of
	 * this list, in the order that they are returned by the specified
	 * collection's iterator.  The behavior of this
	 * operation is unspecified if the specified collection is modified while
	 * the operation is in progress.  (Note that this will occur if the
	 * specified collection is this list, and it's nonempty.)
	 *
	 * @param aCollection collection whose elements are to be added to this list.
	 * @return <tt>true</tt> if this list changed as a result of the call.
	 * 
	 * @throws UnsupportedOperationException if the <tt>addAll</tt> method is not 
	 * supported by this list.
	 * @throws ClassCastException if the class of an element in the specified 
	 * collection prevents it from being added to this list.
	 * @throws IllegalArgumentException if some aspect of an element in the 
	 * specified collection prevents it from being added to this list.
	 */
	public boolean addAll(Collection aCollection) {
		return this.itsSet.addAll(aCollection);
	}

</aw:method>

<aw:method name="removeAll">
	/**
	 * Removes from this list all the elements that are contained in the
	 * specified collection.
	 *
	 * @param aCollection collection that defines which elements will be removed 
	 * from this list.
	 * @return <tt>true</tt> if this list changed as a result of the call.
	 * 
	 * @throws UnsupportedOperationException if the <tt>removeAll</tt> method is 
	 * not supported by this list.
	 */
	public boolean removeAll(Collection aCollection) {
		return this.itsSet.removeAll(aCollection);
	}

</aw:method>

<aw:method name="retainAll">
	/**
	 * Retains only the elements in this list that are contained in the
	 * specified collection.  In other words, removes
	 * from this list all the elements that are not contained in the specified
	 * collection.
	 *
	 * @param aCollection collection that defines which elements this set will 
	 * retain.
	 * 
	 * @return <tt>true</tt> if this list changed as a result of the call.
	 * 
	 * @throws UnsupportedOperationException if the <tt>retainAll</tt> method is 
	 * not supported by this list.
	 */
	public boolean retainAll(Collection aCollection) {
		return this.itsSet.retainAll(aCollection);
	}

</aw:method>

<aw:method name="clear">
	/**
	 * Removes all of the elements from this list. This
	 * list will be empty after this call returns (unless it throws an
	 * exception).
	 *
	 * @throws UnsupportedOperationException if the <tt>clear</tt> method is not 
	 * supported by this list.
	 */
	public void clear() {
		this.itsSet.clear();
	}

</aw:method>

<aw:method name="delete">
	/**
	 * Deletes the object
	 *
	 * The object will become unuseable.
	 */
	public void delete() {
		this.itsSet.clear();
		this.itsSet = null;
	}

</aw:method>

<aw:method name="toString">
	/**
	 * Returns a string representation of the object. In general, the 
	 * <code>toString</code> method returns a string that 
	 * " textually represents " this object.
	 *
	 * @return  a string representation of the object.
	 */
	public String toString() {
		return this.itsSet.toString();
	}

</aw:method>

<aw:method name="equals">
	/**
	 * Compares the specified object with this list for equality.  Returns
	 * <tt>true</tt> if and only if the specified object is also a list, both
	 * lists have the same size, and all corresponding pairs of elements in
	 * the two lists are <i>equal</i>.  (Two elements <tt>e1</tt> and
	 * <tt>e2</tt> are <i>equal</i> if <tt>(e1==null ? e2==null :
	 * e1.equals(e2))</tt>.)  In other words, two lists are defined to be
	 * equal if they contain the same elements in the same order.  This
	 * definition ensures that the equals method works properly across
	 * different implementations of the <tt>Set</tt> interface.
	 *
	 * @param anObject the object to be compared for equality with this list.
	 * @return <tt>true</tt> if the specified object is equal to this list.
	 */
	public boolean equals(Object anObject) {
		if (anObject == null) {
			return false;
    }
		if (anObject == this) {
			return true;
    }
    // Here we can use == since class object are invariant
    // This method is better than using instanceof since it avoids 
    // inheritance effect
		if (anObject.getClass() == <aw:className/>.class) {
			return this.itsSet.equals(anObject);
		}
		return false;
	}

</aw:method>

<aw:method name="clone">
	/**
	 * Creates and returns a copy of this object.  
	 * 
	 * @return a clone of this instance.
	 * @exception CloneNotSupportedException  if the object's class does not 
	 * support the <code>Cloneable</code> interface. Subclasses that override the 
	 * <code>clone</code> method can also throw this exception to indicate that 
	 * an instance cannot be cloned.
	 * @exception OutOfMemoryError if there is not enough memory.
	 */
	public Object clone() {
		<aw:className/> res = new <aw:className/>();
		res.addAll(this.itsSet);
		return res;
	}

</aw:method>

<aw:method name="contains">
	/**
	 * Returns <tt>true</tt> if this list contains the specified element.
	 * More formally, returns <tt>true</tt> if and only if this list contains
	 * at least one element <tt>e</tt> such that
	 * <tt>(o==null&nbsp;?&nbsp;e==null&nbsp;:&nbsp;o.equals(e))</tt>.
	 *
	 * @param anElement element whose presence in this list is to be tested.
	 * @return <tt>true</tt> if this list contains the specified element.
	 */
	public boolean contains(<aw:containedTypeEntered/> anElement) {
		return this.itsSet.contains(<aw:containedTypeAsObject>anElement</aw:containedTypeAsObject>);
	}

</aw:method>

<aw:method name="toArray1">
	/**
	 * Returns an array containing all of the elements in this list in proper
	 * sequence.  Obeys the general contract of the
	 * <tt>Collection.toArray</tt> method.
	 *
	 * @return an array containing all of the elements in this list in proper 
	 * sequence.
	 */
	public <aw:containedTypeEntered/>[] toArray() {
		<aw:containedTypeEntered/>[] res = new <aw:containedTypeEntered/>[this.itsSet.size()];
		Iterator it = this.itsSet.iterator();
		int i = 0;
		while (it.hasNext()) {
			<aw:containedTypeClassName/> element = (<aw:containedTypeClassName/>) it.next();
			res[i] = <aw:containedTypeAsValue>element</aw:containedTypeAsValue>;
			i++;
		}
		return res;
	}

</aw:method>

<aw:method name="toArray2">
	/**
	 * Returns an array containing all of the elements in this list in proper
	 * sequence; the runtime type of the returned array is that of the
	 * specified array.  Obeys the general contract of the
	 * <tt>Collection.toArray(Object[])</tt> method.
	 *
	 * @param someObjects the array into which the elements of this list are to 
	 * be stored, if it is big enough; otherwise, a new array of the same runtime 
	 * type is allocated for this purpose.
	 * @return  an array containing the elements of this list.
	 * 
	 * @throws ArrayStoreException if the runtime type of the specified array is 
	 * not a supertype of the runtime type of every element in this list.
	 */
	public <aw:containedTypeEntered/>[] toArray(<aw:containedTypeEntered/>[] someObjects) {
		<aw:containedTypeEntered/>[] res = new <aw:containedTypeEntered/>[this.itsSet.size()];
		System.arraycopy(someObjects, 0, res, 0, this.itsSet.size());
		Iterator it = this.itsSet.iterator();
		int i = 0;
		while (it.hasNext()) {
			<aw:containedTypeClassName/> element = (<aw:containedTypeClassName/>) it.next();
			res[i] = <aw:containedTypeAsValue>element</aw:containedTypeAsValue>;
			i++;
		}
		return res;
	}

</aw:method>

<aw:method name="add1">
	/**
	 * Appends the specified element to the end of this list (optional
	 * operation). <p>
	 *
	 * Lists that support this operation may place limitations on what
	 * elements may be added to this list.  In particular, some
	 * lists will refuse to add null elements, and others will impose
	 * restrictions on the type of elements that may be added.  List
	 * classes should clearly specify in their documentation any restrictions
	 * on what elements may be added.
	 *
	 * @param anElement element to be appended to this list.
	 * @return <tt>true</tt> (as per the general contract of the 
	 * <tt>Collection.add</tt> method).
	 * 
	 * @throws UnsupportedOperationException if the <tt>add</tt> method is not 
	 * supported by this list.
	 * @throws ClassCastException if the class of the specified element prevents 
	 * it from being added to this list.
	 * @throws IllegalArgumentException if some aspect of this element prevents 
	 * it from being added to this collection.
	 */
	public boolean add(<aw:containedTypeEntered/> anElement) {
		return this.itsSet.add(<aw:containedTypeAsObject>anElement</aw:containedTypeAsObject>);
	}

</aw:method>

<aw:method name="remove">
	/**
	 * Removes the first occurrence in this list of the specified element. If 
	 * this list does not contain the element, it is
	 * unchanged.  More formally, removes the element with the lowest index i
	 * such that <tt>(anElement==null ? get(i)==null : anElement.equals(get(i)))
	 * </tt> (if
	 * such an element exists).
	 *
	 * @param anElement element to be removed from this list, if present.
	 * @return <tt>true</tt> if this list contained the specified element.
	 * 
	 * @throws UnsupportedOperationException if the <tt>remove</tt> method is not 
	 * supported by this list.
	 */
	public boolean remove(<aw:containedTypeEntered/> anElement) {
		return this.itsSet.remove(<aw:containedTypeAsObject>anElement</aw:containedTypeAsObject>);
	}

</aw:method>

<aw:method name="main">
	/**
	 * For test.
	 *
	 * @param args array of arguments
	 */
	public static void main(String[] args) {	
		<aw:className/> myList = new <aw:className/>();
		// Add your value here
		System.out.println(myList);
	}

</aw:method>