#---------------------------------------------#
# <aw:description>Template for a List with basic type (int, float, double, char, byte, long, boolean)</aw:description>
# <aw:version>1.1</aw:version>
# <aw:date>03/18/2004</aw:date>
# <aw:author>Ferret Renaud</aw:author>
#---------------------------------------------#

<aw:import>java.util.Arrays</aw:import>

<aw:interface>java.lang.Cloneable</aw:interface>

<aw:field>
	/** This is the list of object. */
	protected <aw:containedTypeEntered/>[] itsList;

</aw:field>

<aw:field>
	/** The occuped size. */
	protected int occupedSize;

</aw:field>

<aw:constructor name="c1">
	/**
	 * Constructor of the object. <br>
	 */
	public <aw:className/>() {
		this(10);
	}

</aw:constructor>

<aw:constructor name="c2">
	/**
	 * Constructor of the object. <br>
	 * 
	 * @param aSize fixed length of the list
	 */
	public <aw:className/>(int aSize) {
		super();
		if (aSize < 0) {
			throw new IllegalArgumentException("Size must be >=0");
		}
		this.itsList = new <aw:containedTypeEntered/>[aSize];
		this.occupedSize = 0;
	}

</aw:constructor>

<aw:constructor name="c3">
	/**
	 * Constructor of the object. <br>
	 * 
	 * @param aList a list that will be used for the initialization of this array
	 * @param doCopy if true will make a copy of the array given in parameter
	 */
	public <aw:className/>(<aw:containedTypeEntered/>[] aList, boolean doCopy) {
		super();		
		if (doCopy) {
			this.itsList = new <aw:containedTypeEntered/>[aList.length];
			System.arraycopy(aList, 0, this.itsList, 0, aList.length);
		} else {
			this.itsList = aList;
		}
		this.occupedSize = aList.length;
	}

</aw:constructor>

<aw:method name="toString">
	/**
	 * Gives a string representation of this object. <br>
	 * 
	 * @return a String representation of this object
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer(128);
		sb.append('{');
		for (int i = 0; i < this.occupedSize; i++) {
			sb.append(this.itsList[i]);
			sb.append(", ");
		}
		if (this.occupedSize > 0) {
			sb.delete(sb.length() - 2, sb.length());
		}
		sb.append('}');
		return sb.toString();
	}

</aw:method>

<aw:method name="check">
	/**
	 * Validates the index value. <br>
	 * 
	 * @param anIndex index of the object to find
	 * @return true if the index is valid, false if not
	 */
	protected boolean check(int anIndex) {
		return ((anIndex >= 0) && (anIndex < occupedSize));
	}

</aw:method>

<aw:method name="sort">
	/**
	 * Sorts the list.
	 */
	public void sort() {
		Arrays.sort(this.itsList);
	}

</aw:method>

<aw:method name="get">
	/**
	 * Gives an element in the list. <br>
	 * 
	 * @param anIndex index of the element to find
	 * @return the object available at the given index
	 */
	public <aw:containedTypeEntered/> get(int anIndex) {
		if (this.check(anIndex)) {
			return this.itsList[anIndex];
		}
		throw new IndexOutOfBoundsException("Invalid index");
	}

</aw:method>

<aw:method name="set">
	/**
	 * Sets the element in the list at the given index. <br>
	 * 
	 * Warning: No copy or clone of the element is made.
	 * 
	 * @param anIndex where to add the element
	 * @param anElm the object to add
	 */
	public void set(<aw:containedTypeEntered/> anElm, int anIndex) {
		if (this.check(anIndex)) {
			this.itsList[anIndex] = anElm;
		}
		throw new IndexOutOfBoundsException("Invalid index");
	}

</aw:method>

<aw:method name="indexOf1">
	/**
	 * Gives the first place of the given element. <br>
	 * 
	 * @param anElm the element to find
	 * @return the index value of this element, or -1 if it is not present
	 */
	public int indexOf(<aw:containedTypeEntered/> anElm) {
		return this.indexOf(anElm, 0);
	}

</aw:method>

<aw:method name="lastIndexOf">
	/**
	 * Gives the last place of the given element. <br>
	 * 
	 * @param anElm the element to find
	 * @return the last index value of this element, or -1 if it is not present
	 */
	public int lastIndexOf(<aw:containedTypeEntered/> anElm) {
		int res = -1;
		for (int i = 0; i < this.occupedSize; i++) {
			if (anElm == this.itsList[i]) {
				res = i;
			}
		}
		return res;
	}

</aw:method>

<aw:method name="indexOf2">
	/**
	 * Gives the first place of the given element starting from a given position. 
	 * 
	 * @param anElm the element to find
	 * @param aStartIndex where to start searching
	 * @return the index value of this element, or -1 if it is not present
	 */
	public int indexOf(<aw:containedTypeEntered/> anElm, int aStartIndex) {
		int res = -1;
		for (int i = aStartIndex; i < this.occupedSize && res == -1; i++) {
			if (anElm == this.itsList[i]) {
				res = i;
			}
		}
		return res;
	}

</aw:method>


<aw:method name="isEmpty">
	/**
	 * Indicates if the list is empty or not.
	 * 
	 * @return true if the list is empty, false if not
	 */
	public boolean isEmpty() {
		return this.occupedSize == 0;
	}

</aw:method>

<aw:method name="delete">
	/**
	 * Deletes the array.
	 * 
	 * Use this method for memory leak, the list will not be useable anymore
	 */
	public void delete() {
		this.itsList = null;
	}

</aw:method>

<aw:method name="size">
	/**
	 * Returns the number of element in the list.
	 * 
	 * @return the number of element in the list
	 */
	public int size() {
		return this.occupedSize;
	}

</aw:method>

<aw:method name="equals">
	/**
	 * Tests equality between two list.
	 * 
	 * @param anObject the object compared to this
	 * @return true if this is equals to the other object, false if not
	 */
	public boolean equals(Object anObject) {
		if (this == anObject) {
			return true;
    }
		if (null == anObject) {
			return false;
    }
    // Here we can use == since class object are invariant
    // This method is better than using instanceof since it avoids 
    // inheritance effect
		if (anObject.getClass() == <aw:className/>.class) {
			<aw:className/> o = (<aw:className/>) anObject;
			if (o.size() != this.size())
				return false;
			if (o.itsList == this.itsList)
				return true;
			for (int i = 0; i < this.occupedSize; i++) {
				if (this.itsList[i] == o.itsList[i]) {
					continue;
				} else {
					return false;
				}
			}
			return true;
		}
		return false;
	}

</aw:method>

<aw:method name="contains">
	/**
	 * Tests if an element is present or not. <br>
	 * 
	 * @param anElm the element to find
	 * @return true if the element is present, false if not present
	 */
	public boolean contains(<aw:containedTypeEntered/> anElm) {
		return this.indexOf(anElm, 0) != -1;
	}

</aw:method>


<aw:method name="clone">
	/**
	 * Makes a clone of this object. <br>
	 * 
	 * @return a clone of the object
	 */
	public Object clone() {
		return new <aw:className/>(this.itsList, true);
	}

</aw:method>

<aw:method name="ensureCapacity">
	/**
	 * Ensures the capacity of the dynamic list. <br>
	 *
	 * Use this for peformance. <br>
	 *
	 * @param aCapacity the minimum capacity that should have the list
	 */
	public void ensureCapacity(int aCapacity) {
		int oldCapacity = this.itsList.length;
		if (aCapacity > oldCapacity) {
			if (aCapacity - this.itsList.length > 0) {
				<aw:containedTypeEntered/>[] newData = 
                              new <aw:containedTypeEntered/>[aCapacity + aCapacity / 10];
				System.arraycopy(this.itsList, 0, newData, 0, this.occupedSize);
				this.itsList = newData;
			}
		}
	}

</aw:method>

<aw:method name="add1">
	/**
	 * Adds an element to the list. <br>
	 *
	 * The element is put at the end of the list. <br>
	 *
	 * @param anElm the new element to add
	 */
	public void add(<aw:containedTypeEntered/> anElm) {
		this.ensureCapacity(this.occupedSize + 1);
		this.itsList[this.occupedSize] = anElm;
		this.occupedSize++;
	}

</aw:method>

<aw:method name="add2">
	/**
	 * Inserts the specified element at the specified position in this
	 * list. Shifts the element currently at that position (if any) and
	 * any subsequent elements to the right (adds one to their indices).
	 *
	 * @param anIndex index at which the specified element is to be inserted.
	 * @param aString element to be inserted.
	 * @throws    IndexOutOfBoundsException if index is out of range
	 *      <tt>(index &lt; 0 || index &gt; size())</tt>.
	 */
	public void add(int anIndex, <aw:containedTypeEntered/> anElm) {
		if (this.check(anIndex)) {
			this.ensureCapacity(this.occupedSize + 1);
			System.arraycopy(this.itsList, anIndex,
				this.itsList, anIndex + 1,
				this.occupedSize - anIndex);
			this.itsList[anIndex] = anElm;
			this.occupedSize++;
		} else {
			throw new IndexOutOfBoundsException("Invalid index");
		}
	}

</aw:method>

<aw:method name="removeAt">
	/**
	 * Removes the element at the specified position in this list.
	 * Shifts any subsequent elements to the left (subtracts one from their
	 * indices).
	 *
	 * @param anIndex the index of the element to removed.
	 * @return the element that was removed from the list.
	 * @throws    IndexOutOfBoundsException if index out of range <tt>(index
	 *      &lt; 0 || index &gt;= size())</tt>.
	 */
	public <aw:containedTypeEntered/> removeAt(int anIndex) {
		if (this.check(anIndex)) {
			<aw:containedTypeEntered/> oldValue = this.itsList[anIndex];
			int numMoved = this.occupedSize - anIndex - 1;
			if (numMoved > 0) {
				System.arraycopy(this.itsList, anIndex + 1, this.itsList, 
                         anIndex, numMoved);
			}
			this.occupedSize -= 1;
			return oldValue;
		} else {
			throw new IndexOutOfBoundsException("Invalid index");
		}
	}

</aw:method>

<aw:method name="remove">
	/**
	 * Removes the first occurrence in this list of the specified element. If 
	 * this list does not contain the element, it is
	 * unchanged.  More formally, removes the element with the lowest index i
	 * such that <tt>(anElement==null ? get(i)==null : anElement.equals(get(i)))
	 * </tt> (if
	 * such an element exists).
	 *
	 * @param anElement element to be removed from this list, if present.
	 * @return <tt>true</tt> if this list contained the specified element.
	 * 
	 * @throws UnsupportedOperationException if the <tt>remove</tt> method is not 
	 * supported by this list.
	 */
	public boolean remove(<aw:containedTypeEntered/> anElement) {
		int id = this.indexOf(anElement, 0);
		if ( id != -1 ) {
			this.removeAt(id);
			return true;
		}
		return false;
	}

</aw:method>


<aw:method name="toArray1">
	/**
	 * Builds an array with the list. <br>
	 *
	 * @return an array representation of the list. <br>
	 */
	public <aw:containedTypeEntered/>[] toArray() {
		<aw:containedTypeEntered/>[] resu = new <aw:containedTypeEntered/>[this.occupedSize];
		System.arraycopy(this.itsList, 0, resu, 0, this.occupedSize);
		return resu;
	}

</aw:method>

<aw:method name="toArray2">
	/**
	 * Builds an array with the list. <br>
	 *
	 * @param anArray where to put the array representation of the list
	 *
	 * @return an array representation of the list. <br>
	 */
	public <aw:containedTypeEntered/>[] toArray(<aw:containedTypeEntered/>[] anArray) {
		if (anArray.length < this.occupedSize) {
			anArray = new <aw:containedTypeEntered/>[this.occupedSize];
		}
		System.arraycopy(this.itsList, 0, anArray, 0, this.occupedSize);
		return anArray;
	}

</aw:method>

<aw:method name="main">
	/**
	 * For test.
	 *
	 * @param args array of arguments
	 */
	public static void main(String[] args) {	
		<aw:className/> myList = new <aw:className/>();
		// Add your value here
		System.out.println(myList);
	}

</aw:method>