#---------------------------------------------#
# <aw:description>Template for an Exception</aw:description>
# <aw:version>1.3</aw:version>
# <aw:date>03/18/2003</aw:date>
# <aw:author>Ferret Renaud</aw:author>
#---------------------------------------------#

<aw:parentClass>java.lang.Exception</aw:parentClass>

<aw:field>
	/** The source of the exception. */
	protected transient Object itsSource;
</aw:field>

<aw:constructor name="c1">
	/**
	 * Constructor of the object.
	 */
	public <aw:className/>() {
		super();
	}

</aw:constructor>

<aw:constructor name="c2">
	/**
	 * Constructor of the object.
	 * 
	 * @param aMessage the readable message of the exception
	 */
	public <aw:className/>(String aMessage) {
		super(aMessage);
	}

</aw:constructor>

<aw:constructor name="c3">
	/**
	 * Constructor of the object.
	 * 
	 * @param aMessage the readable message of the exception
	 * @param aSource the creator of the exception
	 */
	public <aw:className/>(String aMessage, Object aSource) {
		super(aMessage);
		this.itsSource = aSource;
	}

</aw:constructor>

<aw:constructor name="c4">
	/**
	 * Constructor of the object.
   *
	 * @param aMessage the readable message of the exception
	 * @param aCause the cause
	 */
  public <aw:className/>(String aMessage, Throwable aCause) {
    super(aMessage, aCause);
  }
</aw:constructor>

<aw:constructor name="c5">
	/**
	 * Constructor of the object.
   *
	 * @param aCause the cause
	 */
  public <aw:className/>(Throwable aCause) {
    super(aCause);
  }
</aw:constructor>


<aw:method name="toString">
	/**
	 * Returns a string representation of the object. In general, the 
	 * <code>toString</code> method returns a string that 
	 * " textually represents " this object.
	 *
	 * @return  a string representation of the object.
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append('[');
		sb.append(getClass());
		sb.append(" Message='");
		sb.append(super.getMessage());
		sb.append("', Source=");
		sb.append(this.itsSource);
		sb.append(']');
		return sb.toString();
	}

</aw:method>

<aw:method name="getSource">
	/**
	 * Returns the creator of this exception.
	 *
	 * @return the creator of this exception. (can be null)
	 */
	public Object getSource() {
		return this.itsSource;
	}

</aw:method>

<aw:method name="main">
	/**
	 * For test.
	 *
	 * @param args array of arguments
	 */
	public static void main(String[] args) {	
		<aw:className/> myException = new <aw:className/>("This is bad");
		System.out.println(myException);
	}

</aw:method>