#---------------------------------------------#
# <aw:description>Template for a message driven EJB</aw:description>
# <aw:version>1.0</aw:version>
# <aw:date>07/12/2003</aw:date>
# <aw:author>Genuitec, LLC</aw:author>
#---------------------------------------------#

<aw:import>javax.ejb.EJBException</aw:import>
<aw:import>javax.ejb.MessageDrivenBean</aw:import>
<aw:import>javax.ejb.MessageDrivenContext</aw:import>
<aw:import>javax.jms.Message</aw:import>
<aw:import>javax.jms.MessageListener</aw:import>

<aw:class-comment name="XDoclet">
/**
 * XDoclet-based message driven bean.  The class must be declared
 * <code>public</code>, according to the EJB specification.<br>
 * 
 * To generate code:
 * <br>
 * <ul>
 * <li> Add Standard EJB module to XDoclet project properties
 * <li> Customize XDoclet configuration
 * <li> Run XDoclet
 * </ul>
 * <br>
 * Please see the included XDoclet Overview 
 * and the XDoclet Reference in the help system for details
 * 
 * @ejb.bean name = "<aw:className/>"
 *           display-name = "<aw:className/>"
 *           description = "<aw:className/> EJB"
 *           jndi-name = "jms/<aw:className/>"
 */
</aw:class-comment>

<aw:interface>javax.ejb.MessageDrivenBean</aw:interface>
<aw:interface>javax.jms.MessageListener</aw:interface>

<aw:field>
    /** The MessageDrivenContext */
    private MessageDrivenContext context;
      
</aw:field>


 
<aw:method name="0required">
	/**
	 * An <code>ejbCreate</code> method as required by the EJB specification. <br>
     * 
     * The container calls the instances <code>ejbCreate</code> method 
     * immediately after instantiation.
     * 
     * @ejb.create-method
     */
    public void ejbCreate () {
    }
    
    
</aw:method>


<aw:method name="1required">
    /**
     * The <code>ejbRemove()</code> method as required by the EJB specification.<br>
     *
     * A container invokes this method before it ends the life of the 
     * object. This happens as a result of a client's invoking 
     * a remove operation, or when a container decides to terminate the 
     * object after a timeout.   <br>
     * 
     * This method is called with no transaction context. 
     *
     * @throws EJBException Thrown if the instance could not perform 
     * the function requested by the container because of an system-level error.
     */
    public void ejbRemove() throws EJBException {
    }
    
    
</aw:method>


<aw:method name="2required">
	/**
	 * Set the associated context. The container calls this method 
     * after the instance creation.  <br>
	 * 
     * The enterprise bean instance should store the reference to the context 
     * object in an instance variable. <br>
     * 
     * This method is called with no transaction context.
     * 
     * @param newContext A MessageDrivenContext interface for the instance. 
     * 
     * @throws EJBException Thrown by the method to indicate a failure caused by a system-level error.
	 */
    public void setMessageDrivenContext(MessageDrivenContext newContext) throws EJBException {
		context = newContext;
	}
    
    
</aw:method>


<aw:method name="3required">
    /**
     * Process a message. <br>
     * 
     * @param message The message to process. 
     */
    public void onMessage(Message message) {
    }
</aw:method>

