#---------------------------------------------#
# <aw:description>Template for a Bean </aw:description>
# <aw:version>1.3</aw:version>
# <aw:date>03/18/2004</aw:date>
# <aw:author>Ferret Renaud</aw:author>
#---------------------------------------------#

<aw:import>java.io.Serializable</aw:import>

<aw:interface>java.io.Serializable</aw:interface>
<aw:interface>java.lang.Cloneable</aw:interface>


<aw:constructor name="c1">
	/**
	 * Constructor of the object.
	 */
	public <aw:className/>() {
		super();
	}

</aw:constructor>

<aw:method name="equals">
	/**
	 * Indicates whether some other object is "equal to" this one. <p>
	 *
	 * @param   anObject   the reference object with which to compare.
	 * @return  <code>true</code> if this object is the same as the obj
	 *          argument; <code>false</code> otherwise.
	 */
	public boolean equals(Object anObject) {
		if (anObject == null) {		
			return false;
		}
		if (anObject == this) {		
			return true;
		}
    // Here we can use == since class object are invariant
    // This method is better than using instanceof since it avoids 
    // inheritance effect
		if (anObject.getClass() == <aw:className/>.class) {
			<aw:className/> castedObject = (<aw:className/>)anObject;
			// Do something here and return a value
		}
		return false;
	}

</aw:method>

<aw:method name="clone">
	/**
	 * Creates and returns a copy of this object.  
	 * 
	 * @return a clone of this instance.
	 * @exception CloneNotSupportedException  if the object's class does not 
	 * support the <code>Cloneable</code> interface. Subclasses that override the 
	 * <code>clone</code> method can also throw this exception to indicate that 
	 * an instance cannot be cloned.
	 * @exception OutOfMemoryError if there is not enough memory.
	 */
	protected Object clone() throws CloneNotSupportedException {
		return super.clone();
	}

</aw:method>

<aw:method name="toString">
	/**
	 * Returns a string representation of the object. In general, the 
	 * <code>toString</code> method returns a string that 
	 * " textually represents " this object.
	 *
	 * @return  a string representation of the object.
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append('[');
		sb.append(getClass());
		sb.append(']');
		return sb.toString();
	}

</aw:method>

<aw:method name="main">
	/**
	 * For test.
	 *
	 * @param args array of arguments
	 */
	public static void main(String[] args) {	
	    <aw:className/> myBean = new <aw:className/>();
	    System.out.println(myBean);
	}

</aw:method>