#---------------------------------------------#
# <aw:description>Template for an Array with object type</aw:description>
# <aw:version>1.1</aw:version>
# <aw:date>03/18/2004</aw:date>
# <aw:author>Ferret Renaud</aw:author>
#---------------------------------------------#

<aw:import>java.util.Arrays</aw:import>
<aw:import>java.util.Comparator</aw:import>

<aw:interface>java.lang.Cloneable</aw:interface>

<aw:field>
	/** This is the array of object. */
	protected <aw:containedTypeEntered/>[] itsArray;
	
</aw:field>

<aw:constructor name="c1">
	/**
	 * Constructor of the object. <br>
	 * 
	 * This constructor should remain private
	 */
	private <aw:className/>() {
		super();
	}

</aw:constructor>

<aw:constructor name="c2">
	/**
	 * Constructor of the object. <br>
	 * 
	 * @param aSize fixed length of the array
	 */
	public <aw:className/>(int aSize) {
		super();
		if (aSize < 0) {
			throw new IllegalArgumentException("Size must be >=0");
		}
		this.itsArray = new <aw:containedTypeEntered/>[aSize];
	}

</aw:constructor>

<aw:constructor name="c3">
	/**
	 * Constructor of the object. <br>
	 * 
	 * @param anArray an array that will be use for the initialization of this array
	 * @param doCopy if true will make a copy of the array given in parameter
	 */
	public <aw:className/>(<aw:containedTypeEntered/>[] anArray, boolean doCopy) {
		super();		
		if (doCopy) {
			this.itsArray = new <aw:containedTypeEntered/>[anArray.length];
			System.arraycopy(anArray, 0, this.itsArray, 0, anArray.length);
		} else {
			this.itsArray = anArray;
		}
	}

</aw:constructor>

<aw:method name="toString">
	/**
	 * Gives a string representation of this object. <br>
	 * 
	 * @return a String representation of this object
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer(128);
		sb.append('{');
		for (int i = 0; i < this.itsArray.length; i++) {
			sb.append(this.itsArray[i]);
			sb.append(", ");
		}
		sb.delete(sb.length() - 2, sb.length());
		sb.append('}');
		return sb.toString();
	}

</aw:method>

<aw:method name="get">
	/**
	 * Gives an element in the array. <br>
	 * 
	 * @param anIndex index of the element to find
	 * @return the object available at the given index
	 */
	public <aw:containedTypeEntered/> get(int anIndex) {
		return this.itsArray[anIndex];
	}

</aw:method>

<aw:method name="set">
	/**
	 * Sets the element in the array at the given index. <br>
	 * 
	 * Warning: No copy or clone of the element is made.
	 * 
	 * @param anIndex where to add the element
	 * @param anElm the object to add
	 */
	public void set(<aw:containedTypeEntered/> anElm, int anIndex) {
		this.itsArray[anIndex] = anElm;
	}

</aw:method>

<aw:method name="indexOf1">
	/**
	 * Gives the first place of the given element. <br>
	 * 
	 * @param anElm the element to find
	 * @return the index value of this element, or -1 if it is not present
	 */
	public int indexOf(<aw:containedTypeEntered/> anElm) {
		return this.indexOf(anElm, 0);
	}

</aw:method>

<aw:method name="lastIndexOf">
	/**
	 * Gives the last place of the given element. <br>
	 * 
	 * @param anElm the element to find
	 * @return the last index value of this element, or -1 if it is not present
	 */
	public int lastIndexOf(<aw:containedTypeEntered/> anElm) {
		int res = -1;
		for (int i = 0; i < this.itsArray.length; i++) {
			if (anElm == this.itsArray[i]
				|| (anElm != null && anElm.equals(this.itsArray[i]))) {
				res = i;
			}
		}
		return res;
	}

</aw:method>

<aw:method name="indexOf2">
	/**
	 * Gives the first place of the given element starting from a given position. <br>
	 * 
	 * @param anElm the element to find
	 * @param aStartIndex where to start searching
	 * @return the index value of this element, or -1 if it is not present
	 */
	public int indexOf(<aw:containedTypeEntered/> anElm, int aStartIndex) {
		int res = -1;
		for (int i = aStartIndex; i < this.itsArray.length && res == -1; i++) {
			if (anElm == this.itsArray[i]
				|| (anElm != null && anElm.equals(this.itsArray[i]))) {
				res = i;
			}
		}
		return res;
	}

</aw:method>

<aw:method name="clear">
	/**
	 * Clear the array.
	 * 
	 * Puts null in each place of the array
	 */
	public void clear() {
		for (int i = 0; i < this.itsArray.length; i++) {
			this.itsArray[i] = null;
		}
	}

</aw:method>

<aw:method name="delete">
	/**
	 * Deletes the array.
	 * 
	 * Use this method for memory leak, the Array instance will be unuseable
	 */
	public void delete() {
		this.clear();
		this.itsArray = null;
	}

</aw:method>

<aw:method name="size">
	/**
	 * Returns the size of the array.
	 * 
	 * @return the size of the array
	 */
	public int size() {
		return this.itsArray.length;
	}

</aw:method>

<aw:method name="equals">
	/**
	 * Tests equality between two arrays.
	 * 
	 * @param anObject the object compared to this
	 * @return true if this is equals to the other object, false if not
	 */
	public boolean equals(Object anObject) {
		if (this == anObject) {
			return true;
    }
		if (null == anObject) {
			return false;
    }
    // Here we can use == since class object are invariant
    // This method is better than using instanceof since it avoids 
    // inheritance effect
		if (anObject.getClass() == <aw:className/>.class) {
			<aw:className/> o = (<aw:className/>) anObject;
			if (o.size() != this.size())
				return false;
			if (o.itsArray == this.itsArray)
				return true;
			for (int i = 0; i < this.itsArray.length; i++) {
				if (this.itsArray[i] == o.itsArray[i]
					|| (this.itsArray[i] != null
						&& this.itsArray[i].equals(o.itsArray[i]))) {
					continue;
				} else {
					return false;
				}
			}
			return true;
		}
		return false;
	}

</aw:method>

<aw:method name="sort1">
	/**
	 * Sorts the list.
	 */
	public void sort() {
		Arrays.sort(this.itsArray);
	}

</aw:method>

<aw:method name="sort2">
	/**
	 * Sorts the lis with the help of a comparator.
	 * 
	 * @param aComparator object that tells how to compare objets
	 */
	public void sort(Comparator aComparator) {
		Arrays.sort(this.itsArray, aComparator);
	}

</aw:method>

<aw:method name="contains">
	/**
	 * Test if an element is present or not. <br>
	 * 
	 * @param anElm the element to find
	 * @return true if the element is present, false if not present
	 */
	public boolean contains(<aw:containedTypeEntered/> anElm) {
		return indexOf(anElm) != -1;
	}

</aw:method>

<aw:method name="clone">
	/**
	 * Makes a clone of this object. <br>
	 * 
	 * @return a clone of the object
	 */
	public Object clone() {
		return new <aw:className/>(this.itsArray, true);
	}

</aw:method>

<aw:method name="main">
	/**
	 * The main method. 
	 * 
	 * @param args arguments
	 */
	public static void main(<aw:containedTypeEntered/>[] args) {
		<aw:className/> anArray = new <aw:className/>(5);
		for(int i=0; i<anArray.size(); i++) {
			// anArray.set(i, new <aw:containedTypeEntered/>());
		}
		System.out.println(anArray);
	}

</aw:method>

