/*
 * Decompiled with CFR 0.152.
 */
package com.aston.wizards.xml;

import com.aston.AstonWizardsPlugin;
import com.aston.BasicMethodActionICompilationUnit;
import com.aston.BasicMethodActionIFile;
import com.aston.Marks;
import com.aston.utils.Utils;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.dialogs.StatusInfo;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;

public class WebXmlUnMappingDialog
extends StatusDialog
implements Marks {
    protected static final String SETTINGS_FILE_PATH = "filePath";
    protected BasicMethodActionIFile bma;
    protected BasicMethodActionICompilationUnit bmc;
    protected Text nameText;
    protected Text filePathText;
    protected boolean isPageComplete;
    protected Button browseButton;
    protected PreferenceStore preferenceStore = new PreferenceStore(this.getClass().getName());
    protected Map values = new HashMap(6);

    public WebXmlUnMappingDialog(Shell parent) {
        super(parent);
    }

    protected void createControl() {
        Composite container = (Composite)this.getDialogArea();
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = null;
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebXmlUnMappingDialog.this.dialogChanged();
            }
        };
        GridData gd = new GridData(768);
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.jspname"));
        this.nameText = new Text(container, 2052);
        gd = new GridData(768);
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(ml);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.xmlfilepath"));
        this.filePathText = new Text(container, 2052);
        gd = new GridData(768);
        this.filePathText.setLayoutData((Object)gd);
        this.filePathText.addModifyListener(ml);
        this.browseButton = new Button(container, 8);
        this.browseButton.setText(AstonWizardsPlugin.getString("lg.label.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebXmlUnMappingDialog.this.handleBrowse();
            }
        });
        this.dialogChanged();
    }

    public int open() {
        Shell shell = this.getShell();
        this.createControl();
        shell.pack();
        this.loadSectionValues();
        shell.open();
        Display display = this.getShell().getDisplay();
        while (!shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        int resu = this.getReturnCode();
        if (resu == 0) {
            try {
                this.preferenceStore.save();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                this.doFinish();
            }
            catch (CoreException e1) {
                Utils.showError((Exception)((Object)e1));
            }
        }
        return this.getReturnCode();
    }

    protected void dialogChanged() {
        this.setErrorMessage(null);
        if (this.nameText.getText().trim().length() == 0) {
            this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.namemustbe"));
            return;
        }
        if (this.nameText.getText().trim().indexOf(" ") != -1) {
            this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.nospacejsp"));
            return;
        }
        this.preferenceStore.setValue(SETTINGS_FILE_PATH, this.filePathText.getText());
        this.memorizeValues();
    }

    protected void handleBrowse() {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(super.getShell(), (IContainer)ResourcesPlugin.getWorkspace().getRoot(), false, AstonWizardsPlugin.getString("lg.label.selectfilepath"));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            this.filePathText.setText(String.valueOf(result[0]));
        }
    }

    protected void setErrorMessage(String newMessage) {
        if (newMessage != null) {
            super.updateStatus((IStatus)new StatusInfo(4, newMessage));
        } else {
            super.updateStatus((IStatus)new StatusInfo(0, null));
        }
    }

    protected void loadSectionValues() {
        int id;
        try {
            this.preferenceStore.load();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        String path = this.preferenceStore.getString(SETTINGS_FILE_PATH);
        String ppBmx = null;
        if (this.bma != null) {
            ppBmx = this.bma.getProjectPath();
        }
        if (this.bmc != null) {
            ppBmx = this.bmc.getProjectPath();
        }
        if (path == null) {
            path = ppBmx;
        }
        if (!ppBmx.equals(Utils.getProjectPath(path)) && (id = path.indexOf("/", 1)) != -1) {
            path = ppBmx.concat(path.substring(id));
        }
        if (this.bma == null || !"jsp".equals(this.bma.getFileExtension())) {
            this.nameText.setText(this.bmc.getShortClassName());
            if (path == null || "".equals(path)) {
                path = String.valueOf(Utils.getProjectPath(this.bmc.getFilePath())) + "/WEB-INF";
            }
        } else {
            this.nameText.setText(Utils.getJspName(this.bma.getFileName()));
            if (path == null || "".equals(path)) {
                path = String.valueOf(Utils.getProjectPath(this.bma.getFilePath())) + "/WEB-INF";
            }
        }
        this.filePathText.setText(path);
    }

    public void setBasicMethodActionJsp(BasicMethodActionIFile bma) {
        this.bma = bma;
    }

    public void setBasicMethodActionServlet(BasicMethodActionICompilationUnit bmc) {
        this.bmc = bmc;
    }

    protected void memorizeValues() {
        this.values.put("${FILE_PATH}", this.filePathText.getText());
        this.values.put("${JSP_KEY_NAME}", this.nameText.getText());
    }

    protected void doFinish() throws CoreException {
        Path path;
        String fileName = "web.xml";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)(path = new Path((String)this.values.get("${FILE_PATH}"))));
        if (resource == null) {
            CoreUtility.createFolder((IFolder)root.getFolder((IPath)path), (boolean)true, (boolean)true, null);
            resource = root.findMember((IPath)path);
        }
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path("web.xml"));
        try {
            if (file.exists()) {
                InputStream stream = file.getContents();
                stream = this.removeMapping(stream, this.values);
                file.setContents(stream, true, true, null);
                stream.close();
            } else {
                Utils.showError(AstonWizardsPlugin.getString("lg.error.webxmlnotfound"));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private InputStream removeMapping(InputStream in, Map values) {
        StringBuffer sb = new StringBuffer(128);
        int c = 0;
        try {
            while ((c = in.read()) != -1) {
                sb.append((char)c);
            }
        }
        catch (IOException io) {
            throw new RuntimeException(AstonWizardsPlugin.getString("lg.error.reading"));
        }
        String toSearch = "<servlet-name>" + values.get("${JSP_KEY_NAME}") + "</servlet-name>";
        String fileC = sb.toString();
        int isHere = fileC.indexOf(toSearch);
        if (isHere == -1) {
            Utils.showError(AstonWizardsPlugin.getString("lg.error.jspnamepresent3", (String)values.get("${JSP_KEY_NAME}")));
        } else {
            int servletOpen = fileC.substring(0, isHere).lastIndexOf("<servlet>");
            if (servletOpen != -1) {
                int servletClose = fileC.indexOf("</servlet>", servletOpen);
                int isHereForMapping = fileC.lastIndexOf(toSearch);
                if (isHereForMapping != -1) {
                    int servletMappingClose;
                    int servletMappingOpen = fileC.substring(0, isHereForMapping).lastIndexOf("<servlet-mapping>");
                    if (servletMappingOpen != -1 && (servletMappingClose = fileC.indexOf("</servlet-mapping>", servletMappingOpen)) != -1) {
                        sb.delete(servletMappingOpen, servletMappingClose + "</servlet-mapping>".length());
                    }
                    if (servletClose != -1) {
                        sb.delete(servletOpen, servletClose + "</servlet>".length());
                    }
                }
            }
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }
}

