/*
 * Decompiled with CFR 0.152.
 */
package com.aston.wizards.xml;

import com.aston.AstonWizardsPlugin;
import com.aston.utils.Utils;
import com.aston.wizards.servlet.NewWebXmlLinkCreationWizardPage;
import com.aston.wizards.xml.WebXmlUnMappingDialog;
import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class WebXmlMappingDialog
extends WebXmlUnMappingDialog {
    protected static final String SETTINGS_DESCRIPTION = "description";
    protected static final String SETTINGS_DISPLAY_NAME = "display_name";
    protected Text classNameText;
    protected Text mappingNameText;
    protected Text displayNameText;
    protected Text descriptionText;

    public WebXmlMappingDialog(Shell parent) {
        super(parent);
    }

    protected void createControl() {
        Composite container = (Composite)this.getDialogArea();
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.makeColumnsEqualWidth = true;
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        Label label = null;
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                WebXmlMappingDialog.this.dialogChanged();
            }
        };
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.classename"));
        this.classNameText = new Text(container, 2052);
        this.classNameText.setEditable(false);
        this.classNameText.setEnabled(false);
        GridData gd = new GridData(768);
        this.classNameText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.jspname"));
        this.nameText = new Text(container, 2052);
        gd = new GridData(768);
        this.nameText.setLayoutData((Object)gd);
        this.nameText.addModifyListener(ml);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.urlname"));
        this.mappingNameText = new Text(container, 2052);
        gd = new GridData(768);
        this.mappingNameText.setLayoutData((Object)gd);
        this.mappingNameText.addModifyListener(ml);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.xmlfilepath"));
        this.filePathText = new Text(container, 2052);
        gd = new GridData(768);
        this.filePathText.setLayoutData((Object)gd);
        this.filePathText.addModifyListener(ml);
        this.browseButton = new Button(container, 8);
        this.browseButton.setText(AstonWizardsPlugin.getString("lg.label.browse"));
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WebXmlMappingDialog.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.displayname"));
        this.displayNameText = new Text(container, 2052);
        gd = new GridData(768);
        this.displayNameText.setLayoutData((Object)gd);
        this.displayNameText.addModifyListener(ml);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.description"));
        this.descriptionText = new Text(container, 2052);
        gd = new GridData(768);
        this.descriptionText.setLayoutData((Object)gd);
        this.descriptionText.addModifyListener(ml);
        label = new Label(container, 0);
        this.dialogChanged();
    }

    protected void dialogChanged() {
        super.dialogChanged();
        if (this.mappingNameText.getText().trim().length() == 0) {
            this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.mapmustbespec"));
            return;
        }
        if (this.mappingNameText.getText().trim().indexOf(" ") != -1) {
            this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.nospace"));
            return;
        }
        this.preferenceStore.setValue(SETTINGS_DESCRIPTION, this.descriptionText.getText());
        this.preferenceStore.setValue(SETTINGS_DISPLAY_NAME, this.displayNameText.getText());
        this.memorizeValues();
    }

    protected void loadSectionValues() {
        int id;
        String description = null;
        String display = null;
        try {
            this.preferenceStore.load();
        }
        catch (IOException e) {
            description = "This is the description of my J2EE component";
            display = "This is the display name of my J2EE component";
        }
        if (description == null) {
            description = this.preferenceStore.getString(SETTINGS_DESCRIPTION);
        }
        if (display == null) {
            display = this.preferenceStore.getString(SETTINGS_DISPLAY_NAME);
        }
        String path = this.preferenceStore.getString("filePath");
        String ppBmx = null;
        if (this.bma != null) {
            ppBmx = this.bma.getProjectPath();
        }
        if (this.bmc != null) {
            ppBmx = this.bmc.getProjectPath();
        }
        if (path == null) {
            path = ppBmx;
        }
        if (!ppBmx.equals(Utils.getProjectPath(path)) && (id = path.indexOf("/", 1)) != -1) {
            path = ppBmx.concat(path.substring(id));
        }
        if (this.bma == null || !"jsp".equals(this.bma.getFileExtension())) {
            this.classNameText.setText(this.bmc.getClassName());
            this.nameText.setText(this.bmc.getShortClassName());
            this.mappingNameText.setText("/servlet/" + this.bmc.getClassName());
            if (path == null || "".equals(path)) {
                path = String.valueOf(Utils.getProjectPath(this.bmc.getFilePath())) + "/WEB-INF";
            }
        } else {
            String jspPath = Utils.getJspPath(this.bma.getGlobalPath());
            String fileName = this.bma.getFileName();
            this.classNameText.setText(String.valueOf(jspPath) + "/" + fileName);
            this.nameText.setText(Utils.getJspName(fileName));
            this.mappingNameText.setText(this.classNameText.getText());
            if (path == null || "".equals(path)) {
                path = String.valueOf(Utils.getProjectPath(this.bma.getFilePath())) + "/WEB-INF";
            }
        }
        this.descriptionText.setText(description);
        this.displayNameText.setText(display);
        this.filePathText.setText(path);
    }

    protected void memorizeValues() {
        super.memorizeValues();
        this.values.put("<aw:className", this.classNameText.getText());
        this.values.put("${JSP_MAPPING_URL}", this.mappingNameText.getText());
        this.values.put("${JSP_DISPLAY_NAME}", this.displayNameText.getText());
        this.values.put("${JSP_DESCRIPTION}", this.descriptionText.getText());
    }

    protected void doFinish() throws CoreException {
        Path path;
        String fileName = "web.xml";
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IResource resource = root.findMember((IPath)(path = new Path((String)this.values.get("${FILE_PATH}"))));
        if (resource == null) {
            CoreUtility.createFolder((IFolder)root.getFolder((IPath)path), (boolean)true, (boolean)true, null);
            resource = root.findMember((IPath)path);
        }
        IContainer container = (IContainer)resource;
        IFile file = container.getFile((IPath)new Path("web.xml"));
        try {
            if (file.exists()) {
                InputStream stream = file.getContents();
                stream = NewWebXmlLinkCreationWizardPage.fillContentStream(stream, this.values, AstonWizardsPlugin.getString("lg.error.jspnamepresent2", (String)this.values.get("${JSP_KEY_NAME}")));
                file.setContents(stream, true, true, null);
                stream.close();
            } else {
                NewWebXmlLinkCreationWizardPage.createContentFile(this.values, file, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

