/*
 * Decompiled with CFR 0.152.
 */
package com.aston.wizards.designpattern;

import com.aston.AstonWizardsPlugin;
import com.aston.utils.Utils;
import com.aston.wizards.designpattern.NewArrayCreationWizardPage;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class NewListCreationWizardPage
extends NewArrayCreationWizardPage {
    protected static final String SETTINGS_LIST = "list";
    protected ComboDialogField listType;

    protected NewListCreationWizardPage(boolean isClass, String pageName, String templateKey) {
        super(isClass, pageName, templateKey);
    }

    public NewListCreationWizardPage() {
        super(true, "NewListCreationWizardPage", SETTINGS_LIST);
    }

    protected void initThePage() {
        super.initThePage();
        this.setTitle(AstonWizardsPlugin.getString("lg.label.listwizard"));
        this.setDescription(AstonWizardsPlugin.getString("lg.label.listwillgenerate"));
        this.fContainedClassDialogField.setLabelText(AstonWizardsPlugin.getString("lg.label.listcontainsonly"));
    }

    protected void createControlForTemplate(Composite composite, int nColumns) {
        super.createControlForTemplate(composite, nColumns);
        this.listType = new ComboDialogField(2052);
        this.listType.setLabelText(AstonWizardsPlugin.getString("lg.label.listtouse"));
        this.listType.setItems(Utils.asStringArray(Utils.LIST_CLASS));
        this.listType.selectItem(0);
        this.listType.doFillIntoGrid(composite, nColumns);
        this.listType.setDialogFieldListener((IDialogFieldListener)this);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setControl((Control)composite);
    }

    public String getListClassName() {
        return this.listType.getText();
    }

    protected void doStatusUpdate() {
        super.doStatusUpdate();
        if (this.listType != null && "".equals(this.listType.getText().trim())) {
            this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.listtousembs"));
            this.setPageComplete(false);
            return;
        }
    }

    protected void setSpecificValues(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, Map values) {
        super.setSpecificValues(type, imports, monitor, values);
        values.put("<aw:listType", this.getListClassName());
    }

    protected void updateSectionValues() {
        super.updateSectionValues();
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        section.put(SETTINGS_LIST, this.listType.getText());
    }

    protected void loadSelectionValues() {
        super.loadSelectionValues();
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        if (section != null) {
            String temp = section.get(SETTINGS_LIST);
            if (this.listType != null && temp != null && !"".equals(temp)) {
                this.listType.setText(temp);
            }
        }
    }
}

