/*
 * Decompiled with CFR 0.152.
 */
package com.aston.wizards.applet;

import com.aston.AstonWizardsPlugin;
import com.aston.WizardPage;
import com.aston.utils.Utils;
import com.aston.wizards.applet.NewAppletCreationWizardPage;
import java.util.HashMap;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewAppletHtmlCreationWizardPage
extends WizardPage {
    private static final String GENERATE_HTML = "generateHtml";
    private Text classNameText;
    private Text codeBaseText;
    private Text appletNameText;
    private Text appletWidthText;
    private Text appletHeightText;
    private Button button;

    public NewAppletHtmlCreationWizardPage() {
        super("NewAppletHtmlCreationWizardPage", "applethtml");
        this.setTitle(AstonWizardsPlugin.getString("lg.label.applethtml"));
        this.setDescription(AstonWizardsPlugin.getString("lg.label.willcreateapplethtml"));
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 10;
        Composite c = new Composite(container, 0);
        this.generateBool = new BooleanFieldEditor(GENERATE_HTML, AstonWizardsPlugin.getString("lg.label.generatehtml"), c);
        PreferenceStore ps = new PreferenceStore();
        ps.setValue(GENERATE_HTML, true);
        this.generateBool.setPreferenceStore((IPreferenceStore)ps);
        this.generateBool.load();
        this.generateBool.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent e) {
                NewAppletHtmlCreationWizardPage.this.generateBoolUpdate();
            }
        });
        Label label = new Label(container, 0);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.appletclassname"));
        this.classNameText = new Text(container, 2052);
        this.classNameText.setEditable(false);
        this.classNameText.setEnabled(false);
        GridData gd = new GridData(768);
        this.classNameText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewAppletHtmlCreationWizardPage.this.dialogChanged();
            }
        };
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.codebase"));
        this.codeBaseText = new Text(container, 2052);
        this.codeBaseText.setText(".");
        gd = new GridData(768);
        this.codeBaseText.setLayoutData((Object)gd);
        this.codeBaseText.addModifyListener(ml);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.filepath"));
        this.filePathText = new Text(container, 2052);
        gd = new GridData(768);
        this.filePathText.setLayoutData((Object)gd);
        this.filePathText.addModifyListener(ml);
        this.button = new Button(container, 8);
        this.button.setText(AstonWizardsPlugin.getString("lg.label.browse"));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewAppletHtmlCreationWizardPage.this.handleBrowse();
            }
        });
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.filename"));
        this.fileNameText = new Text(container, 2052);
        gd = new GridData(768);
        this.fileNameText.setLayoutData((Object)gd);
        this.fileNameText.addModifyListener(ml);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.appletname"));
        this.appletNameText = new Text(container, 2052);
        gd = new GridData(768);
        this.appletNameText.setLayoutData((Object)gd);
        this.appletNameText.addModifyListener(ml);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.appletwidth"));
        this.appletWidthText = new Text(container, 2052);
        gd = new GridData(768);
        this.appletWidthText.setLayoutData((Object)gd);
        this.appletWidthText.addModifyListener(ml);
        label = new Label(container, 0);
        label = new Label(container, 0);
        label.setText(AstonWizardsPlugin.getString("lg.label.appletheight"));
        this.appletHeightText = new Text(container, 2052);
        gd = new GridData(768);
        this.appletHeightText.setLayoutData((Object)gd);
        this.appletHeightText.addModifyListener(ml);
        label = new Label(container, 0);
        this.createControlForTemplate(container, layout.numColumns);
        this.dialogChanged();
        this.setControl((Control)container);
    }

    public void generateBoolUpdate() {
        boolean value = this.generateBool.getBooleanValue();
        this.fileNameText.setEditable(value);
        this.filePathText.setEditable(value);
        this.codeBaseText.setEditable(value);
        this.appletNameText.setEditable(value);
        this.appletWidthText.setEditable(value);
        this.appletHeightText.setEditable(value);
        this.fileNameText.setEnabled(value);
        this.filePathText.setEnabled(value);
        this.codeBaseText.setEnabled(value);
        this.appletNameText.setEnabled(value);
        this.appletWidthText.setEnabled(value);
        this.appletHeightText.setEnabled(value);
        this.templateList.setEnabled(value);
        this.button.setEnabled(value);
        this.dialogChanged();
    }

    public void setVisible(boolean b) {
        NewAppletCreationWizardPage p = (NewAppletCreationWizardPage)this.getPreviousPage();
        if (p != null) {
            String pck = p.getPackageText();
            if (!"".equals(pck)) {
                pck = String.valueOf(pck) + ".";
            }
            this.classNameText.setText(String.valueOf(pck) + p.getTypeName() + ".class");
            this.filePathText.setText("/" + Utils.getProjectPath(p.getPackageFragmentRootText()));
            this.fileNameText.setText("StartPageFor" + p.getTypeName() + ".html");
            this.appletNameText.setText(p.getTypeName());
            this.appletWidthText.setText("320");
            this.appletHeightText.setText("240");
        }
        super.setVisible(b);
    }

    protected void dialogChanged() {
        if (this.generateBool.getBooleanValue()) {
            super.dialogChanged();
            if (this.isPageComplete()) {
                String fileName = this.getFileName();
                if (!fileName.toLowerCase().endsWith(".html") && !fileName.toLowerCase().endsWith(".htm")) {
                    this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.htmlfilemustbe"));
                    this.setPageComplete(false);
                    return;
                }
                if (this.codeBaseText.getText().trim().length() == 0) {
                    this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.codebase"));
                    this.setPageComplete(false);
                    return;
                }
                if (this.appletNameText.getText().trim().length() == 0) {
                    this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.appletname"));
                    this.setPageComplete(false);
                    return;
                }
                if (this.appletWidthText.getText().trim().length() == 0) {
                    this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.widthmustbe"));
                    this.setPageComplete(false);
                    return;
                }
                try {
                    Integer.parseInt(this.appletWidthText.getText());
                }
                catch (NumberFormatException nfe) {
                    this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.widthinteger"));
                    this.setPageComplete(false);
                    return;
                }
                if (this.appletHeightText.getText().trim().length() == 0) {
                    this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.heightmustbe"));
                    this.setPageComplete(false);
                    return;
                }
                try {
                    Integer.parseInt(this.appletHeightText.getText());
                }
                catch (NumberFormatException nfe) {
                    this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.heightinteger"));
                    this.setPageComplete(false);
                    return;
                }
            }
        } else {
            this.setPageComplete(true);
            this.setErrorMessage(null);
        }
    }

    public IRunnableWithProgress getRunnable() {
        HashMap<String, String> values = new HashMap<String, String>(8);
        values.put("<aw:appletCodeBase", this.codeBaseText.getText());
        values.put("<aw:appletClass", this.classNameText.getText());
        values.put("<aw:appletName", this.appletNameText.getText());
        values.put("<aw:appletWidth", this.appletWidthText.getText());
        values.put("<aw:appletHeight", this.appletHeightText.getText());
        values.put("${TEMPLATE_NAME}", this.getTemplateFileName());
        values.put("${FILE_NAME}", this.getFileName());
        values.put("${FILE_PATH}", this.getFilePath());
        return new WizardPage.AstonRunnableWithProgress(values, this);
    }
}

