/*
 * Decompiled with CFR 0.152.
 */
package com.aston;

import com.aston.AstonWizardsPlugin;
import com.aston.NewTypeWizardPage;
import com.aston.utils.Utils;
import java.awt.Point;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.internal.ui.dialogs.TypeSelectionDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IStringButtonAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringDialogField;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class NewTypeContainerWizardPage
extends NewTypeWizardPage {
    protected StringButtonDialogField fContainedClassDialogField;
    protected IType containedType;

    public NewTypeContainerWizardPage(boolean isClass, String pageName, String templateKey) {
        super(isClass, pageName, templateKey);
    }

    protected void doStatusUpdate() {
        super.doStatusUpdate();
        if (this.isPageComplete() && "".equals(this.fContainedClassDialogField.getText())) {
            this.setErrorMessage(AstonWizardsPlugin.getString("lg.warning.objmustbespecified"));
            this.setPageComplete(false);
            return;
        }
    }

    protected void setSpecificValues(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, Map values) {
        String inType = Utils.getClassName(this.getContainedClassName());
        values.put("<aw:containedTypeEntered", inType);
        values.put("<aw:containedTypeAsNull", Utils.getNull(inType));
        values.put("<aw:containedTypeClassName", Utils.getObject(inType));
    }

    protected void createContainedClassControls(Composite composite, int nColumns) {
        if (this.fContainedClassDialogField != null) {
            this.fContainedClassDialogField.doFillIntoGrid(composite, nColumns);
            LayoutUtil.setWidthHint((Control)this.fContainedClassDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
        }
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createContainedClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createControlForTemplate(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setControl((Control)composite);
    }

    protected void createInternal(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, Map values) throws CoreException {
        StringBuffer fileSb = null;
        try {
            fileSb = AstonWizardsPlugin.getDefault().openContentStream(values);
        }
        catch (IOException e) {
            Utils.showError(e, this.getShell());
            return;
        }
        this.createInheritedMethods(type, false, this.isCreateInherited(), imports, monitor);
        if (this.getContainedClassName().indexOf(".") != -1) {
            imports.addImport(this.getContainedClassName());
        }
        this.transformBasicToObject(fileSb, (String)values.get("<aw:containedTypeEntered"), "aw:containedTypeAsObject");
        this.transformObjectToBasic(fileSb, (String)values.get("<aw:containedTypeEntered"), "aw:containedTypeAsValue");
        String file = fileSb.toString();
        this.createImports(file, type, imports, monitor);
        this.createFields(file, type, imports, monitor);
        if (this.isCreateConstructors()) {
            this.createConstructor(file, type, imports, monitor);
        }
        this.createMethods(file, type, imports, monitor);
        this.createInerType(file, type, imports, monitor);
        this.updateSectionValues();
        if (monitor != null) {
            monitor.done();
        }
    }

    public String getContainedClassName() {
        if (this.fContainedClassDialogField != null) {
            return this.fContainedClassDialogField.getText();
        }
        return null;
    }

    protected void transformBasicToObject(StringBuffer file, String basic, String aAsObjectMark) {
        if (basic == null) {
            return;
        }
        String typeStart = "<".concat(aAsObjectMark);
        String typeEnd = "</".concat(aAsObjectMark);
        String sFile = file.toString();
        ArrayList<Point> where = new ArrayList<Point>();
        int start = sFile.indexOf(typeStart, 0);
        int end = -1;
        while (start != -1) {
            end = sFile.indexOf(typeEnd, start + typeStart.length());
            if (end == -1) {
                Utils.showError(AstonWizardsPlugin.getString("lg.error.missingendtag", aAsObjectMark), this.getShell());
                return;
            }
            Point last = new Point(start, end);
            where.add(last);
            start = sFile.indexOf(typeStart, end + typeEnd.length());
        }
        int i = where.size() - 1;
        while (i >= 0) {
            Point p = (Point)where.get(i);
            int startR = sFile.indexOf(">", p.x + typeStart.length()) + 1;
            int endR = sFile.indexOf(">", p.y + typeEnd.length()) + 1;
            String paramName = sFile.substring(startR, p.y);
            Utils.asNewObject(basic, paramName, file, p.x, endR);
            p = null;
            --i;
        }
        where.clear();
        where = null;
    }

    protected void transformObjectToBasic(StringBuffer file, String basic, String aAsValueMark) {
        if (basic == null) {
            return;
        }
        boolean isBasic = Utils.isBasicType(basic);
        String typeStart = "<".concat(aAsValueMark);
        String typeEnd = "</".concat(aAsValueMark);
        String sFile = file.toString();
        ArrayList<Point> where = new ArrayList<Point>();
        int start = sFile.indexOf(typeStart, 0);
        int end = -1;
        while (start != -1) {
            end = sFile.indexOf(typeEnd, start);
            if (end == -1) {
                Utils.showError(AstonWizardsPlugin.getString("lg.error.missingendtag", aAsValueMark), this.getShell());
                return;
            }
            Point last = new Point(start, end);
            where.add(last);
            start = sFile.indexOf(typeStart, end);
        }
        int i = where.size() - 1;
        while (i >= 0) {
            Point p = (Point)where.get(i);
            int startR = sFile.indexOf(">", p.x + typeStart.length()) + 1;
            int endR = sFile.indexOf(">", p.y + typeEnd.length()) + 1;
            String paramName = sFile.substring(startR, p.y);
            if (isBasic) {
                file.replace(p.x, endR, String.valueOf(paramName) + "." + basic + "Value()");
            } else {
                file.replace(p.x, endR, paramName);
            }
            p = null;
            --i;
        }
        where.clear();
        where = null;
    }

    protected class TypeFieldsAdapter
    implements IStringButtonAdapter,
    IDialogFieldListener,
    IListAdapter {
        protected String dialogTitle = AstonWizardsPlugin.getString("lg.label.selectobject");
        protected String dialogMessage = AstonWizardsPlugin.getString("lg.label.selectobject");
        protected int javaSearchConstants = 0;

        public void changeControlPressed(DialogField field) {
            IPackageFragmentRoot root = NewTypeContainerWizardPage.this.getPackageFragmentRoot();
            if (root == null) {
                return;
            }
            IJavaElement[] elements = new IJavaElement[]{root.getJavaProject()};
            IJavaSearchScope scope = SearchEngine.createJavaSearchScope((IJavaElement[])elements);
            TypeSelectionDialog dialog = new TypeSelectionDialog(NewTypeContainerWizardPage.this.getShell(), (IRunnableContext)NewTypeContainerWizardPage.this.getWizard().getContainer(), this.javaSearchConstants, scope);
            dialog.setTitle(this.dialogTitle);
            dialog.setMessage(this.dialogMessage);
            if (dialog.open() == 0) {
                NewTypeContainerWizardPage.this.containedType = (IType)dialog.getFirstResult();
                if (field != null) {
                    ((StringDialogField)field).setText(NewTypeContainerWizardPage.this.containedType.getFullyQualifiedName());
                }
            }
        }

        public void customButtonPressed(DialogField field, int index) {
            if (field != null) {
                // empty if block
            }
        }

        public void selectionChanged(DialogField field) {
        }

        public void dialogFieldChanged(DialogField field) {
            NewTypeContainerWizardPage.this.doStatusUpdate();
        }

        public void setDialogMessage(String dialogMessage) {
            this.dialogMessage = dialogMessage;
        }

        public void setDialogTitle(String dialogTitle) {
            this.dialogTitle = dialogTitle;
        }

        public void setJavaSearchConstants(int javaSearchConstants) {
            this.javaSearchConstants = javaSearchConstants;
        }

        public void customButtonPressed(ListDialogField field, int index) {
        }

        public void doubleClicked(ListDialogField field) {
        }

        public void selectionChanged(ListDialogField field) {
        }
    }
}

