/*
 * Decompiled with CFR 0.152.
 */
package com.aston;

import com.aston.utils.MessageFormat;
import com.aston.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public final class AstonWizardsPlugin
extends AbstractUIPlugin {
    private static AstonWizardsPlugin plugin;
    private static final String TEMPLATE_PROPERTIES = "templates.properties";
    private static final String LANGUAGE_PROPERTIES = "language";
    private static ResourceBundle LANGUAGE_BUNDLE;

    public AstonWizardsPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        plugin = this;
        try {
            LANGUAGE_BUNDLE = ResourceBundle.getBundle(LANGUAGE_PROPERTIES);
        }
        catch (MissingResourceException e) {
            Utils.showError("File that contains language (language properties) was not found !", JavaPlugin.getActiveWorkbenchShell());
        }
        try {
            super.getPluginPreferences().load(this.openStream((IPath)new Path(this.getLocaleLanguage(TEMPLATE_PROPERTIES))));
        }
        catch (IOException e) {
            Utils.showError(LANGUAGE_BUNDLE.getString("lg.error.templatenotfound"), JavaPlugin.getActiveWorkbenchShell());
        }
    }

    public static final synchronized AstonWizardsPlugin getDefault() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        return ResourcesPlugin.getWorkspace();
    }

    public final StringBuffer buildFromTemplate(String aTemplateName) throws IOException {
        StringBuffer sb = new StringBuffer(128);
        String newLine = System.getProperty("line.separator");
        InputStream in = AstonWizardsPlugin.getDefault().openStream((IPath)new Path(aTemplateName));
        InputStreamReader isr = new InputStreamReader(in);
        BufferedReader br = new BufferedReader(isr);
        String aLine = br.readLine();
        while (aLine != null) {
            if (aLine.length() <= 0 || aLine.charAt(0) != '#') {
                sb.append(aLine);
                sb.append(newLine);
            }
            aLine = br.readLine();
        }
        br.close();
        isr.close();
        in.close();
        return sb;
    }

    public final Map loadTemplateFor(String nameBeginsWith) {
        String key;
        String fileName;
        int i = 1;
        TreeMap<String, String> m = new TreeMap<String, String>();
        if (nameBeginsWith == null) {
            return m;
        }
        Preferences ap = AstonWizardsPlugin.getDefault().getPluginPreferences();
        while (!"".equals(fileName = ap.getString(key = String.valueOf(nameBeginsWith) + ".template." + i))) {
            String description = ap.getString(String.valueOf(key) + ".label");
            if ("".equals(description)) {
                description = fileName;
            }
            m.put(String.valueOf(i) + "] " + description, fileName);
            ++i;
        }
        return m;
    }

    public final StringBuffer openContentStream(Map values) throws IOException, CoreException {
        String tName = (String)values.get("${TEMPLATE_NAME}");
        StringBuffer res = this.buildFromTemplate(tName);
        Iterator it = values.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key != "${TEMPLATE_NAME}" && key != "${JSP_DESCRIPTION}" && key != "${JSP_DISPLAY_NAME}" && key != "${JSP_KEY_NAME}" && key != "${JSP_MAPPING_URL}" && key != "${FILE_NAME}" && key != "${FILE_PATH}") {
                String value = (String)values.get(key);
                Utils.replaceWithForEmptyXmlTokenType(res, key, value);
                value = null;
            }
            key = null;
        }
        it = null;
        return res;
    }

    public static final String getString(String aKey) {
        return LANGUAGE_BUNDLE.getString(aKey);
    }

    public static final String getString(String aKey, String arg0) {
        return MessageFormat.format(LANGUAGE_BUNDLE.getString(aKey), new String[]{arg0});
    }

    public static final String getString(String aKey, String arg0, String arg1) {
        return MessageFormat.format(LANGUAGE_BUNDLE.getString(aKey), new String[]{arg0, arg1});
    }

    private String getLocaleLanguage(String defaultName) {
        String language = Locale.getDefault().getLanguage();
        StringBuffer sb = new StringBuffer(defaultName);
        int ptId = defaultName.indexOf(".");
        if (ptId != -1) {
            sb.insert(ptId, "_" + language);
        }
        try {
            new InputStreamReader(this.openStream((IPath)new Path(sb.toString())));
        }
        catch (IOException e) {
            return defaultName;
        }
        return sb.toString();
    }

    public Shell getShell() {
        return super.getWorkbench().getWorkbenchWindows()[0].getShell();
    }
}

