#---------------------------------------------#
# <aw:description>Template for a Singleton</aw:description>
# <aw:version>1.2</aw:version>
# <aw:date>06/21/2003</aw:date>
# <aw:author>Ferret Renaud</aw:author>
#---------------------------------------------#

<aw:field>
	/** This is the default instance used for this singleton. */
	private static <aw:className/> defaultInstance;

</aw:field>

<aw:constructor name="c1">
	/**
	 * Constructor of the object. <br>
	 *
	 * This constructor should remain private
	 */
	private <aw:className/>() {
		super();
		// Put your code here
	}

</aw:constructor>

<aw:method name="getInstance">
	/**
	 * Gets the unique instance of this class. <br>
	 *
	 * @return the unique instance of this class
	 */
	public final synchronized static <aw:className/> getInstance() {
		if (<aw:className/>.defaultInstance == null) {
			<aw:className/>.defaultInstance = new <aw:className/>();
		}
		return <aw:className/>.defaultInstance;
	}

</aw:method>

<aw:method name="main">
	/**
	 * For test.
	 *
	 * @param args
	 */
	public static void main(String[] args) {   
		// The first and only instance of the Singleton
		<aw:className/> mySingleton = <aw:className/>.getInstance();
	}

</aw:method> 