/*
 * Decompiled with CFR 0.152.
 */
package com.aston.wizards.html;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.WizardPage;
import com.aston.utils.Utils;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ComboDialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class NewHtmlCreationWizardPage
extends WizardPage {
    protected static final String SETTINGS_DOCTYPE = "doctype";
    private ComboDialogField fileDoctype;
    private Button button;

    public NewHtmlCreationWizardPage() {
        super("NewHtmlCreationWizardPage", "html");
        LogMessage.getInstance().log("-> NewHtmlCreationWizardPage.NewHtmlCreationWizardPage()");
        this.setTitle(AstonWizardsPlugin.getResourceString("lg.label.htmlwiz"));
        this.setDescription(AstonWizardsPlugin.getResourceString("lg.label.htmlwillgen"));
    }

    protected void loadSectionValues() {
        LogMessage.getInstance().log("-> NewHtmlCreationWizardPage.loadSectionValues()");
        super.loadSectionValues();
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        if (section != null) {
            String doc = section.get(SETTINGS_DOCTYPE);
            if (this.fileDoctype != null && doc != null && !"".equals(doc)) {
                this.fileDoctype.setText(doc);
            }
        }
    }

    protected void updateSectionValues() {
        LogMessage.getInstance().log("-> NewHtmlCreationWizardPage.updateSectionValues()");
        super.updateSectionValues();
        IDialogSettings section = this.getDialogSettings().getSection(this.getName());
        section.put(SETTINGS_DOCTYPE, this.fileDoctype.getText());
    }

    public void createControl(Composite parent) {
        LogMessage.getInstance().log("-> NewHtmlCreationWizardPage.createControl(parent)");
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        layout.numColumns = 3;
        layout.verticalSpacing = 2;
        ModifyListener ml = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                NewHtmlCreationWizardPage.this.dialogChanged();
            }
        };
        Label label = new Label(composite, 0);
        label.setText(AstonWizardsPlugin.getResourceString("lg.label.filepath"));
        this.filePathText = new Text(composite, 2052);
        this.filePathText.setText(this.getGlobalPath());
        GridData gd = new GridData(768);
        this.filePathText.setLayoutData((Object)gd);
        this.filePathText.addModifyListener(ml);
        this.button = new Button(composite, 8);
        this.button.setText(AstonWizardsPlugin.getResourceString("lg.label.browse"));
        this.button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                NewHtmlCreationWizardPage.this.handleBrowse();
            }
        });
        label = new Label(composite, 0);
        label.setText(AstonWizardsPlugin.getResourceString("lg.label.filename"));
        this.fileNameText = new Text(composite, 2052);
        this.fileNameText.setText("MyHtml.html");
        gd = new GridData(768);
        this.fileNameText.setLayoutData((Object)gd);
        this.fileNameText.addModifyListener(ml);
        label = new Label(composite, 0);
        this.fileDoctype = new ComboDialogField(2060);
        List l = Utils.DOCTYPE_VALUES;
        String[] tab = new String[l.size()];
        int i = 0;
        Iterator it = l.iterator();
        while (it.hasNext()) {
            tab[i] = (String)it.next();
            ++i;
        }
        this.fileDoctype.setItems(tab);
        this.fileDoctype.selectItem(0);
        this.fileDoctype.setLabelText(AstonWizardsPlugin.getResourceString("lg.label.doctype"));
        this.fileDoctype.doFillIntoGrid(composite, layout.numColumns);
        this.fileDoctype.setDialogFieldListener((IDialogFieldListener)this);
        this.createControlForTemplate(composite, layout.numColumns);
        this.dialogChanged();
        this.setControl((Control)composite);
    }

    public String getDoctype() {
        LogMessage.getInstance().log("-> NewHtmlCreationWizardPage.getDoctype()");
        return this.fileDoctype.getText();
    }

    public IRunnableWithProgress getRunnable() {
        LogMessage.getInstance().log("-> NewHtmlCreationWizardPage.getRunnable()");
        HashMap<String, String> values = new HashMap<String, String>(4);
        values.put("${FILE_NAME}", this.getFileName());
        values.put("${FILE_PATH}", this.getFilePath());
        values.put("<aw:doctype", this.getDoctype());
        values.put("<aw:title", this.getFileName());
        values.put("${TEMPLATE_NAME}", this.getTemplateFileName());
        return new WizardPage.AstonRunnableWithProgress(values, this);
    }

    protected void dialogChanged() {
        String fileName;
        LogMessage.getInstance().log("-> NewHtmlCreationWizardPage.dialogChanged()");
        super.dialogChanged();
        if (this.isPageComplete() && !(fileName = this.getFileName()).toLowerCase().endsWith(".html") && !fileName.toLowerCase().endsWith(".htm")) {
            this.setErrorMessage(AstonWizardsPlugin.getResourceString("lg.warning.htmlfilemustbe"));
            this.setPageComplete(false);
            return;
        }
    }
}

