/*
 * Decompiled with CFR 0.152.
 */
package com.aston.utils;

import com.aston.AstonWizardsPlugin;
import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public final class Utils {
    public static final List DOCTYPE_VALUES = Utils.loadImplementationFor("doctype.html");
    public static final List MAP_CLASS = Utils.loadImplementationFor("struct.map");
    public static final List LIST_CLASS = Utils.loadImplementationFor("struct.list");
    public static final List SET_CLASS = Utils.loadImplementationFor("struct.set");
    public static final String[] BASIC_TYPES = new String[]{"int", "long", "short", "byte", "float", "double", "char", "boolean"};
    public static final Map WRAPPERS = new HashMap();
    public static final Map WRAPPERS_AS_NULL;

    static {
        WRAPPERS.put("int", "Integer");
        WRAPPERS.put("long", "Long");
        WRAPPERS.put("short", "Short");
        WRAPPERS.put("byte", "Byte");
        WRAPPERS.put("float", "Float");
        WRAPPERS.put("double", "Double");
        WRAPPERS.put("char", "Character");
        WRAPPERS.put("boolean", "Boolean");
        WRAPPERS_AS_NULL = new HashMap();
        WRAPPERS_AS_NULL.put("int", "Integer.MIN_VALUE");
        WRAPPERS_AS_NULL.put("long", "Long.MIN_VALUE");
        WRAPPERS_AS_NULL.put("short", "Short.MIN_VALUE");
        WRAPPERS_AS_NULL.put("byte", "Byte.MIN_VALUE");
        WRAPPERS_AS_NULL.put("float", "Float.NaN");
        WRAPPERS_AS_NULL.put("double", "Double.NaN");
        WRAPPERS_AS_NULL.put("char", "(char)Character.MIN_VALUE");
        WRAPPERS_AS_NULL.put("boolean", "false");
    }

    private Utils() {
        throw new RuntimeException("Can not be instanciate !");
    }

    public static String getProjectPath(String aString) {
        int id;
        if (aString != null && aString.length() > 1 && (id = aString.indexOf(47, 1)) != -1) {
            return aString.substring(0, id);
        }
        return aString;
    }

    public static String getJspPath(String aString) {
        int id;
        if (aString != null && aString.length() > 1 && (id = aString.indexOf(47, 1)) != -1) {
            return aString.substring(id);
        }
        return "";
    }

    public static String getJspName(String aString) {
        int id;
        if (aString != null && (id = aString.lastIndexOf(46)) != -1) {
            return aString.substring(0, id);
        }
        return aString;
    }

    public static String getPackageRealName(IPackageFragment ipf) {
        String path;
        int id;
        if (ipf != null && (id = (path = ipf.getPath().toString()).indexOf(47, 1)) != -1) {
            return path.replace('/', '.').substring(id + 1);
        }
        return "";
    }

    public static String getClassName(String longClassName) {
        if (longClassName == null) {
            return null;
        }
        int id = longClassName.lastIndexOf(46);
        if (id != -1) {
            return longClassName.substring(id + 1);
        }
        return longClassName;
    }

    public static boolean isBasicType(String aString) {
        return WRAPPERS.containsKey(aString);
    }

    public static String getObject(String aString) {
        String type = (String)WRAPPERS.get(aString);
        if (type == null) {
            type = aString;
        }
        return type;
    }

    public static void asObject(String aString, StringBuffer sb, int start, int end) {
        if (start < end) {
            sb.replace(start, end, Utils.getObject(aString));
        } else {
            sb.append(Utils.getObject(aString));
        }
    }

    public static void asObject(String aString, StringBuffer sb) {
        Utils.asObject(aString, sb, sb.length(), sb.length());
    }

    public static void asNewObject(String aString, String anAttr, StringBuffer sb, int start, int end) {
        if ("int".equals(aString)) {
            anAttr = "new Integer(" + anAttr + ")";
        } else if ("long".equals(aString)) {
            anAttr = "new Long(" + anAttr + ")";
        } else if ("short".equals(aString)) {
            anAttr = "new Short(" + anAttr + ")";
        } else if ("byte".equals(aString)) {
            anAttr = "new Byte(" + anAttr + ")";
        } else if ("float".equals(aString)) {
            anAttr = "new Float(" + anAttr + ")";
        } else if ("double".equals(aString)) {
            anAttr = "new Double(" + anAttr + ")";
        } else if ("char".equals(aString)) {
            anAttr = "new Character(" + anAttr + ")";
        } else if ("boolean".equals(aString)) {
            anAttr = "new Boolean(" + anAttr + ")";
        }
        if (start < end) {
            sb.replace(start, end, anAttr);
        } else {
            sb.append(anAttr);
        }
    }

    public static void asNewObject(String aString, String anAttr, StringBuffer sb) {
        Utils.asNewObject(aString, anAttr, sb, sb.length(), sb.length());
    }

    public static String getNull(String aString) {
        String resu = (String)WRAPPERS_AS_NULL.get(aString);
        if (resu == null) {
            resu = "null";
        }
        return resu;
    }

    public static void replaceWithNull(String aString, StringBuffer sb, int start, int end) {
        if (start < end) {
            sb.replace(start, end, Utils.getNull(aString));
        } else {
            sb.append(Utils.getNull(aString));
        }
    }

    public static void replaceWithNull(String aString, StringBuffer sb) {
        Utils.replaceWithNull(aString, sb, sb.length(), sb.length());
    }

    public void replaceWith(StringBuffer from, String oldValue, String newValue) {
        int oldLength = oldValue.length();
        int newLength = newValue.length();
        int start = from.toString().indexOf(oldValue, 0);
        while (start != -1) {
            int end = start + oldLength;
            from.replace(start, end, newValue);
            start = from.toString().indexOf(oldValue, start + newLength);
        }
    }

    public static void replaceWithForEmptyXmlTokenType(StringBuffer from, String oldValue, String newValue) throws CoreException {
        String file = from.toString();
        int start = file.indexOf(oldValue, 0);
        ArrayList<Point> where = new ArrayList<Point>();
        while (start != -1) {
            int end = file.indexOf("/>", start + oldValue.length());
            if (end < 0) {
                Utils.throwCoreException(AstonWizardsPlugin.getResourceString("lg.error.tokennotclosed", oldValue), "");
                break;
            }
            where.add(new Point(start, end += 2));
            start = file.indexOf(oldValue, end);
        }
        int i = where.size() - 1;
        while (i >= 0) {
            Point p = (Point)where.get(i);
            from.replace(p.x, p.y, newValue);
            --i;
        }
        where.clear();
        where = null;
    }

    public static String[] asStringArray(Map aMap, boolean onKeys) {
        Iterator<Object> it = onKeys ? aMap.keySet().iterator() : aMap.values().iterator();
        String[] resu = onKeys ? new String[aMap.keySet().size()] : new String[aMap.values().size()];
        int i = 0;
        while (it.hasNext()) {
            resu[i] = (String)it.next();
            ++i;
        }
        return resu;
    }

    public static String[] asStringArray(List aList) {
        Iterator it = aList.iterator();
        String[] resu = new String[aList.size()];
        int i = 0;
        while (it.hasNext()) {
            resu[i] = (String)it.next();
            ++i;
        }
        return resu;
    }

    public static void showError(Exception e, Shell shell) {
        if (e != null && shell != null) {
            Utils.showError(e.getMessage(), shell);
            JavaPlugin.log((Throwable)e);
        }
    }

    public static void showError(String msg, Shell shell) {
        if (msg != null && shell != null) {
            MessageBox mb = new MessageBox(shell, 65569);
            mb.setMessage(msg);
            mb.open();
        }
    }

    public static void showError(String msg) {
        Utils.showError(msg, AstonWizardsPlugin.getDefault().getShell());
    }

    public static void showError(Exception e) {
        Utils.showError(e, AstonWizardsPlugin.getDefault().getShell());
    }

    public static void throwCoreException(String message, String pageName) throws CoreException {
        Status status = new Status(4, pageName, 0, message, null);
        throw new CoreException((IStatus)status);
    }

    public static List loadImplementationFor(String nameBeginsWith) {
        int i = 1;
        ArrayList<String> resu = new ArrayList<String>();
        while (true) {
            String key = String.valueOf(nameBeginsWith) + "." + i;
            String value = AstonWizardsPlugin.getTemplatePreferences().getString(key);
            if (value == null || "".equals(value)) break;
            resu.add(value);
            ++i;
        }
        return resu;
    }

    public static int searchTo(String file, boolean toLeft, int from, String token) {
        if (!toLeft) {
            return file.indexOf(token, from);
        }
        String subFile = file.substring(0, from);
        return subFile.lastIndexOf(token, 0);
    }
}

