/*
 * Decompiled with CFR 0.152.
 */
package com.aston;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewTypeContainerWizardPage;
import com.aston.utils.Utils;
import java.io.IOException;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.jdt.ui.wizards.NewTypeWizardPage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;

public abstract class NewTypeDoubleContainerWizardPage
extends NewTypeContainerWizardPage {
    protected StringButtonDialogField fSecondContainedClassDialogField;
    protected IType secondContainedType;
    protected NewTypeContainerWizardPage.TypeFieldsAdapter adapter;

    public NewTypeDoubleContainerWizardPage(boolean isClass, String pageName, String templateKey) {
        super(isClass, pageName, templateKey);
        LogMessage.getInstance().log("-> NewTypeDoubleContainerWizardPage.NewTypeDoubleContainerWizardPage(isClass, pageName, templateKey)");
    }

    protected void doStatusUpdate() {
        LogMessage.getInstance().log("-> NewTypeDoubleContainerWizardPage.doStatusUpdate()");
        super.doStatusUpdate();
        if (this.isPageComplete() && "".equals(this.fSecondContainedClassDialogField.getText())) {
            this.setErrorMessage(AstonWizardsPlugin.getResourceString("lg.warning.objaskeymustbespecified"));
            this.setPageComplete(false);
            return;
        }
    }

    protected void setSpecificValues(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, Map values) {
        LogMessage.getInstance().log("-> NewTypeDoubleContainerWizardPage.setSpecificValues(type, imports, monitor, values)");
        super.setSpecificValues(type, imports, monitor, values);
        String secondInType = Utils.getClassName(this.getSecondContainedClassName());
        values.put("<aw:containedKeyEntered", secondInType);
        values.put("<aw:containedKeyAsNull", Utils.getNull(secondInType));
        values.put("<aw:containedKeyClassName", Utils.getObject(secondInType));
    }

    protected void createContainedSecondClassControls(Composite composite, int nColumns) {
        LogMessage.getInstance().log("-> NewTypeDoubleContainerWizardPage.createContainedSecondClassControls(composite, nColumns)");
        if (this.fSecondContainedClassDialogField != null) {
            this.fSecondContainedClassDialogField.doFillIntoGrid(composite, nColumns);
            LayoutUtil.setWidthHint((Control)this.fSecondContainedClassDialogField.getTextControl(null), (int)this.getMaxFieldWidth());
        }
    }

    public void createControl(Composite parent) {
        LogMessage.getInstance().log("-> NewTypeDoubleContainerWizardPage.createControl(parent)");
        this.initializeDialogUnits((Control)parent);
        Composite composite = new Composite(parent, 0);
        int nColumns = 4;
        GridLayout layout = new GridLayout();
        layout.numColumns = nColumns;
        composite.setLayout((Layout)layout);
        this.createContainerControls(composite, nColumns);
        this.createPackageControls(composite, nColumns);
        this.createEnclosingTypeControls(composite, nColumns);
        this.createSeparator(composite, nColumns);
        this.createTypeNameControls(composite, nColumns);
        this.createModifierControls(composite, nColumns);
        this.createSuperClassControls(composite, nColumns);
        this.createContainedClassControls(composite, nColumns);
        this.createContainedSecondClassControls(composite, nColumns);
        this.createSuperInterfacesControls(composite, nColumns);
        this.createControlForTemplate(composite, nColumns);
        this.createMethodStubSelectionControls(composite, nColumns);
        this.setControl((Control)composite);
    }

    protected void createInternal(IType type, NewTypeWizardPage.ImportsManager imports, IProgressMonitor monitor, Map values) throws CoreException {
        LogMessage.getInstance().log("-> NewTypeDoubleContainerWizardPage.createInternal(type, imports, monitor, values)");
        StringBuffer fileSb = null;
        try {
            fileSb = AstonWizardsPlugin.getDefault().openContentStream(values);
        }
        catch (IOException e) {
            Utils.showError(e, this.getShell());
            return;
        }
        this.createInheritedMethods(type, false, this.isCreateInherited(), imports, monitor);
        if (this.getContainedClassName().indexOf(".") != -1) {
            imports.addImport(this.getContainedClassName());
        }
        this.transformBasicToObject(fileSb, (String)values.get("<aw:containedTypeEntered"), "aw:containedTypeAsObject");
        this.transformObjectToBasic(fileSb, (String)values.get("<aw:containedTypeEntered"), "aw:containedTypeAsValue");
        this.transformBasicToObject(fileSb, (String)values.get("<aw:containedKeyEntered"), "aw:containedKeyAsObject");
        this.transformObjectToBasic(fileSb, (String)values.get("<aw:containedKeyEntered"), "aw:containedKeyAsValue");
        String file = fileSb.toString();
        this.createImports(file, type, imports, monitor);
        this.createFields(file, type, imports, monitor);
        if (this.isCreateConstructors()) {
            this.createConstructor(file, type, imports, monitor);
        }
        this.createMethods(file, type, imports, monitor);
        this.createInerType(file, type, imports, monitor);
        this.updateSectionValues();
        if (monitor != null) {
            monitor.done();
        }
    }

    public String getSecondContainedClassName() {
        LogMessage.getInstance().log("-> NewTypeDoubleContainerWizardPage.getSecondContainedClassName()");
        if (this.fSecondContainedClassDialogField != null) {
            return this.fSecondContainedClassDialogField.getText();
        }
        return null;
    }
}

