/*
 * Decompiled with CFR 0.152.
 */
package com.aston;

import com.aston.LogMessage;
import com.aston.utils.MessageFormat;
import com.aston.utils.Utils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.TreeMap;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public final class AstonWizardsPlugin
extends AbstractUIPlugin {
    private static AstonWizardsPlugin plugin;
    private static final String TEMPLATE_PROPERTIES = "templates";
    private static final String LANGUAGE_PROPERTIES = "language";
    private static ResourceBundle LANGUAGE_BUNDLE;
    private static Preferences TEMPLATE_BUNDLE;

    public AstonWizardsPlugin() {
        this.doInit();
    }

    private final void doInit() {
        LogMessage.getInstance().log("-> AstonWizardsPlugin.doInit()");
        plugin = this;
        try {
            LANGUAGE_BUNDLE = ResourceBundle.getBundle(LANGUAGE_PROPERTIES);
        }
        catch (MissingResourceException e) {
            Utils.showError("File that contains language (language properties) was not found !", JavaPlugin.getActiveWorkbenchShell());
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        try {
            TEMPLATE_BUNDLE = new Preferences();
            InputStream is = super.openStream((IPath)new Path(this.getLocaleLanguage(TEMPLATE_PROPERTIES)));
            TEMPLATE_BUNDLE.load(is);
        }
        catch (Exception e) {
            Utils.showError("File that contains language (language properties) was not found !", JavaPlugin.getActiveWorkbenchShell());
        }
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
    }

    public static AstonWizardsPlugin getDefault() {
        LogMessage.getInstance().log("-> AstonWizardsPlugin.getDefault()");
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        LogMessage.getInstance().log("-> AstonWizardsPlugin.getWorkspace()");
        return ResourcesPlugin.getWorkspace();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final StringBuffer buildFromTemplate(String aTemplateName) throws IOException {
        block23: {
            block22: {
                LogMessage.getInstance().log("-> AstonWizardsPlugin.buildFromTemplate(aTemplateName)");
                sb = new StringBuffer(128);
                newLine = System.getProperty("line.separator");
                br = null;
                isr = null;
                in = null;
                try {
                    in = AstonWizardsPlugin.getDefault().openStream((IPath)new Path(aTemplateName));
                    isr = new InputStreamReader(in);
                    br = new BufferedReader(isr);
                    aLine = br.readLine();
                    while (aLine != null) {
                        if (aLine.length() <= 0 || aLine.charAt(0) != '#') {
                            sb.append(aLine);
                            sb.append(newLine);
                        }
                        aLine = br.readLine();
                    }
                }
                catch (Throwable var9_9) {
                    var8_10 = null;
                    try {
                        if (br != null) {
                            br.close();
                        }
                    }
                    catch (IOException var10_12) {
                        // empty catch block
                    }
                    try {
                        if (isr != null) {
                            isr.close();
                        }
                    }
                    catch (IOException var10_12) {
                        // empty catch block
                    }
                    try {
                        if (in == null) throw var9_9;
                        in.close();
                        throw var9_9;
                    }
                    catch (IOException e3) {
                        // empty catch block
                    }
                    throw var9_9;
                }
                {
                    var8_11 = null;
                }
                ** try [egrp 2[TRYBLOCK] [3 : 144->157)] { 
lbl50:
                // 1 sources

                if (br != null) {
                    br.close();
                }
                break block22;
lbl53:
                // 1 sources

                catch (IOException var10_13) {
                    // empty catch block
                }
            }
            ** try [egrp 3[TRYBLOCK] [4 : 159->172)] { 
lbl57:
            // 1 sources

            if (isr != null) {
                isr.close();
            }
            break block23;
lbl60:
            // 1 sources

            catch (IOException var10_13) {
                // empty catch block
            }
        }
        try {}
        catch (IOException e3) {
            return sb;
        }
        if (in == null) return sb;
        in.close();
        return sb;
    }

    public final Map loadTemplateFor(String nameBeginsWith) {
        String key;
        String fileName;
        LogMessage.getInstance().log("-> AstonWizardsPlugin.loadTemplateFor(nameBeginsWith)");
        int i = 1;
        TreeMap<String, String> m = new TreeMap<String, String>();
        if (nameBeginsWith == null) {
            return m;
        }
        while (!"".equals(fileName = TEMPLATE_BUNDLE.getString(key = String.valueOf(nameBeginsWith) + ".template." + i))) {
            String description = TEMPLATE_BUNDLE.getString(String.valueOf(key) + ".label");
            if ("".equals(description)) {
                description = fileName;
            }
            StringBuffer mapKey = new StringBuffer(128);
            if (i < 10) {
                mapKey.append('0').append(i);
            } else {
                mapKey.append(i);
            }
            mapKey.append("] ").append(description);
            m.put(mapKey.toString(), fileName);
            mapKey = null;
            key = null;
            fileName = null;
            description = null;
            ++i;
        }
        return m;
    }

    public final StringBuffer openContentStream(Map values) throws IOException, CoreException {
        LogMessage.getInstance().log("-> AstonWizardsPlugin.openContentStream(values)");
        String tName = (String)values.get("${TEMPLATE_NAME}");
        StringBuffer res = this.buildFromTemplate(tName);
        Iterator it = values.keySet().iterator();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (key != "${TEMPLATE_NAME}" && key != "${JSP_DESCRIPTION}" && key != "${JSP_DISPLAY_NAME}" && key != "${JSP_KEY_NAME}" && key != "${JSP_MAPPING_URL}" && key != "${FILE_NAME}" && key != "${FILE_PATH}") {
                String value = (String)values.get(key);
                Utils.replaceWithForEmptyXmlTokenType(res, key, value);
                value = null;
            }
            key = null;
        }
        it = null;
        return res;
    }

    public static final String getResourceString(String aKey) {
        LogMessage.getInstance().log("-> AstonWizardsPlugin.getString(aKey)");
        return LANGUAGE_BUNDLE.getString(aKey);
    }

    public static final String getResourceString(String aKey, String arg0) {
        LogMessage.getInstance().log("-> AstonWizardsPlugin.getString(aKey, arg0)");
        return MessageFormat.format(LANGUAGE_BUNDLE.getString(aKey), new String[]{arg0});
    }

    public static final String getResourceString(String aKey, String arg0, String arg1) {
        LogMessage.getInstance().log("-> AstonWizardsPlugin.getString(aKey, arg0, arg1)");
        return MessageFormat.format(LANGUAGE_BUNDLE.getString(aKey), new String[]{arg0, arg1});
    }

    private String getLocaleLanguage(String defaultName) {
        LogMessage.getInstance().log("-> AstonWizardsPlugin.getLocaleLanguage(defaultName)");
        String language = Locale.getDefault().getLanguage();
        StringBuffer sb = new StringBuffer(defaultName);
        sb.append("_").append(language);
        sb.append(".properties");
        try {
            new InputStreamReader(this.openStream((IPath)new Path(sb.toString())));
        }
        catch (IOException e) {
            return defaultName.concat(".properties");
        }
        catch (NullPointerException npe) {
            Utils.showError(LANGUAGE_BUNDLE.getString("lg.error.tpfileNotFound"), JavaPlugin.getActiveWorkbenchShell());
        }
        return sb.toString();
    }

    public Shell getShell() {
        LogMessage.getInstance().log("-> AstonWizardsPlugin.getShell()");
        return super.getWorkbench().getWorkbenchWindows()[0].getShell();
    }

    public ResourceBundle getLanguageBundle() {
        return LANGUAGE_BUNDLE;
    }

    public static Preferences getTemplatePreferences() {
        return TEMPLATE_BUNDLE;
    }
}

