package com.aston.wizards.xml;

import java.io.IOException;
import java.io.InputStream;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.utils.Utils;
import com.aston.wizards.servlet.NewWebXmlLinkCreationWizardPage;

/**
 * This is a JSP creation Wizard.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>

 * @version 1.0
 */
public class WebXmlMappingDialog extends WebXmlUnMappingDialog {
	protected final static String SETTINGS_DESCRIPTION = "description";
	protected final static String SETTINGS_DISPLAY_NAME = "display_name";

	protected Text classNameText;
	protected Text mappingNameText;

	protected Text displayNameText;
	protected Text descriptionText;
 
	/**
	 * Constructor of the object.
	 * 
	 * @param parent
	 */
	public WebXmlMappingDialog(Shell parent) {
		super(parent);
		LogMessage.getInstance().log(
			"-> WebXmlMappingDialog.WebXmlMappingDialog(parent)");
	}

	/**
	 * Create a control for this page.
	 */
	protected void createControl() {
		LogMessage.getInstance().log("-> WebXmlMappingDialog.createControl()");
		Composite container = (Composite) getDialogArea();
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.makeColumnsEqualWidth = true;
		layout.numColumns = 3;
		layout.verticalSpacing = 9;

		Label label = null;

		ModifyListener ml = new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				WebXmlMappingDialog.this.dialogChanged();
			}
		};

		label = new Label(container, SWT.NONE);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.classename"));
		this.classNameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		this.classNameText.setEditable(false);
		this.classNameText.setEnabled(false);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		this.classNameText.setLayoutData(gd);
		label = new Label(container, SWT.NULL);

		label = new Label(container, SWT.NONE);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.jspname"));
		this.nameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.nameText.setLayoutData(gd);
		this.nameText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		label = new Label(container, SWT.NONE);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.urlname"));
		this.mappingNameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.mappingNameText.setLayoutData(gd);

		this.mappingNameText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		label = new Label(container, SWT.NONE);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.xmlfilepath"));
		this.filePathText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.filePathText.setLayoutData(gd);
		this.filePathText.addModifyListener(ml);
		this.browseButton = new Button(container, SWT.PUSH);
		this.browseButton.setText(
			AstonWizardsPlugin.getResourceString("lg.label.browse"));
		this.browseButton.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				WebXmlMappingDialog.this.handleBrowse();
			}
		});

		// File Name
		label = new Label(container, SWT.NONE);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.displayname"));
		this.displayNameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.displayNameText.setLayoutData(gd);
		this.displayNameText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		// Applet height
		label = new Label(container, SWT.NONE);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.description"));
		this.descriptionText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.descriptionText.setLayoutData(gd);
		this.descriptionText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		dialogChanged();
	}

	/**
	 * Ensures that all is set correctly
	 */
	protected void dialogChanged() {
		LogMessage.getInstance().log("-> WebXmlMappingDialog.dialogChanged()");
		super.dialogChanged();

		if (this.mappingNameText.getText().trim().length() == 0) {
			setErrorMessage(
				AstonWizardsPlugin.getResourceString("lg.warning.mapmustbespec"));
			return;
		}
		if (this.mappingNameText.getText().trim().indexOf(" ") != -1) {
			setErrorMessage(AstonWizardsPlugin.getResourceString("lg.warning.nospace"));
			return;
		}
		AstonWizardsPlugin.getDefault().getPluginPreferences().setValue(
			SETTINGS_DESCRIPTION,
			this.descriptionText.getText());
		AstonWizardsPlugin.getDefault().getPluginPreferences().setValue(
			SETTINGS_DISPLAY_NAME,
			this.displayNameText.getText());
		memorizeValues();
	}
	/**
	 * Sets the "old" value in the window.
	 */
	protected void loadSectionValues() {
		LogMessage.getInstance().log(
			"-> WebXmlMappingDialog.loadSectionValues()");

		String description = AstonWizardsPlugin.getDefault().getPluginPreferences().getString(SETTINGS_DESCRIPTION);
		String display = AstonWizardsPlugin.getDefault().getPluginPreferences().getString(SETTINGS_DISPLAY_NAME);
		String path = AstonWizardsPlugin.getDefault().getPluginPreferences().getString(SETTINGS_FILE_PATH);

		if (path == null) {
			if (super.basicMethodActionICompilationUnit != null) {
				path =
					super.basicMethodActionICompilationUnit.getProjectPath()
						+ "/WEB-INF";
			} else if (super.basicMethodActionIFile != null) {
				path = super.basicMethodActionIFile.getProjectPath() + "/WEB-INF";
			}
		}

		if (path != null) {
			// If project name is different then use the new ProjectName
			if (super.basicMethodActionICompilationUnit != null
				&& !Utils.getProjectPath(path).equals(
					super
						.basicMethodActionICompilationUnit
						.getProjectPath())) {
				int id = path.indexOf("/", 1);
				if (id != -1) {
					path =
						super
							.basicMethodActionICompilationUnit
							.getProjectPath()
							.concat(
							path.substring(id));
				}
			} else if (
				super.basicMethodActionIFile != null
					&& !Utils.getProjectPath(path).equals(
						super.basicMethodActionIFile.getProjectPath())) {
				int id = path.indexOf("/", 1);
				if (id != -1) {
					path =
						super.basicMethodActionIFile.getProjectPath().concat(
							path.substring(id));
				}
			}
		}

		if (this.basicMethodActionICompilationUnit != null) {
			this.classNameText.setText(
				this.basicMethodActionICompilationUnit.getClassName());
			this.nameText.setText(
				this.basicMethodActionICompilationUnit.getShortClassName());
			this.mappingNameText.setText(
				"/servlet/"
					+ this.basicMethodActionICompilationUnit.getClassName());
		} else if (this.basicMethodActionIFile != null) {
			String jspPath =
				Utils.getJspPath(this.basicMethodActionIFile.getGlobalPath());
			String fileName = this.basicMethodActionIFile.getFileName();
			this.classNameText.setText(jspPath + "/" + fileName);
			this.nameText.setText(Utils.getJspName(fileName));
			this.mappingNameText.setText(this.classNameText.getText());
		}
		this.descriptionText.setText(description);
		this.displayNameText.setText(display);
		this.filePathText.setText(path);

	}

	/**
	 * Returns the runnable that creates the type using the current settings.
	 * The returned runnable must be executed in the UI thread.
	 */
	protected void memorizeValues() {
		LogMessage.getInstance().log("-> WebXmlMappingDialog.memorizeValues()");
		super.memorizeValues();
		this.values.put(MARK_CLASS_NAME, this.classNameText.getText());
		this.values.put(MARK_JSP_MAPPING_URL, this.mappingNameText.getText());
		this.values.put(MARK_JSP_DISPLAY_NAME, this.displayNameText.getText());
		this.values.put(MARK_JSP_DESCRIPTION, this.descriptionText.getText());
	}

	/**
	 * The worker method. It will find the container, create the
	 * file if missing or just replace its contents, and open
	 * the editor on the newly created file.
	 * 
	
	 * @throws CoreException if a problem occured
	 */
	protected void doFinish() throws CoreException {
		LogMessage.getInstance().log("-> WebXmlMappingDialog.doFinish()");
		final String fileName = "web.xml";

		IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
		IPath path = new Path((String) this.values.get(MARK_FILE_PATH));
		IResource resource = root.findMember(path);

		// Create the folder if it does not exist
		if (resource == null) {
			CoreUtility.createFolder(root.getFolder(path), true, true, null);
			resource = root.findMember(path);
		}

		IContainer container = (IContainer) resource;
		final IFile file = container.getFile(new Path(fileName));
		InputStream stream = null;
		try {
			if (file.exists()) {
				stream = file.getContents();
				stream =
					NewWebXmlLinkCreationWizardPage.fillContentStream(
						stream,
						this.values,
						AstonWizardsPlugin.getResourceString(
							"lg.error.jspnamepresent2",
							(String) this.values.get(MARK_JSP_KEY_NAME)));
				file.setContents(stream, true, true, null);
			} else {
				NewWebXmlLinkCreationWizardPage.createContentFile(
					this.values,
					file,
					null);
			}
		} catch (Exception e) {
			// TODO Change
			LogMessage.getInstance().log(e.getMessage());			
		} finally {
			//System.out.println("Closing Stream");
			if (stream!=null) {
				try {
					stream.close();				
				} catch (IOException e1) {
					// TODO Change
					LogMessage.getInstance().log(e1.getMessage());
				}
			}
		}
		
	}

}
