package com.aston.wizards.xml;

import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewCreationWizard;
import com.aston.utils.Utils;

/**
 * This is a Xml creation Wizard.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>

 * @version 1.0
 */
public class NewXmlCreationWizard extends NewCreationWizard {
	/** The only wizard page. */
	private NewXmlCreationWizardPage fPage;
  
	/**
	 * Constructor of the object. 
	 */
	public NewXmlCreationWizard() {
		super();
		LogMessage.getInstance().log(
				"-> NewXmlCreationWizard.NewXmlCreationWizard()");
		setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
		setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
		setWindowTitle(AstonWizardsPlugin.getResourceString("lg.label.createxml"));
	}

	/**
	 * Adds pages to the wizard. 
	 */
	public void addPages() {
		LogMessage.getInstance().log("-> NewXmlCreationWizard.addPages()");
		this.fPage = new NewXmlCreationWizardPage();
		addPage(this.fPage);
		this.fPage.init(getSelection());
	}

	/**
	* Is calls when wizard is about to finish. 
	* 
	* @return true when it has finished
	*/
	public boolean performFinish() {
		LogMessage.getInstance().log("-> NewXmlCreationWizard.performFinish()");
		try {
			return finishPage(this.fPage.getRunnable());
		} catch (Exception e) {
			Utils.showError(e, getShell());
		}
		return false;
	}
}
