package com.aston.wizards.servlet;

import java.util.Iterator;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;

/**
 * Wizard page to create a new Servlet class. <p>
 * 
 * This class is inspired of the org.eclipse.jdt.ui.wizards.NewClassWizardPage.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.0
 * @since Eclipse 2.0
 */
public class NewServletCreationWizardPage extends com.aston.NewTypeWizardPage {
 
	private final static String SETTINGS_CREATE_DOGET = "create_doget";
	private final static String SETTINGS_CREATE_DOPOST = "create_dopost";
	private final static String SETTINGS_CREATE_INITDESTROY =
		"create_doinitdestroy";
	private final static String SETTINGS_CREATE_DOPUT = "create_doput";
	private final static String SETTINGS_CREATE_DODELETE = "create_dodelete";
	private final static String SETTINGS_CREATE_SERVLETINFO =
		"create_servletinfo";

	/**
	 * Constructor of the object. 
	 */
	public NewServletCreationWizardPage() {
		super(true, "NewServletCreationWizardPage", "servlet");
		LogMessage
				.getInstance()
				.log(
						"-> NewServletCreationWizardPage.NewServletCreationWizardPage()");
	}

	/**
	 * The wizard owning this page is responsible for calling this method 
	 * with the current selection. The selection is used to 
	 * initialize the fields of the wizard page.
	 * 
	 * @param selection used to initialize the fields
	 */
	public void init(IStructuredSelection selection) {
		LogMessage.getInstance().log(
				"-> NewServletCreationWizardPage.init(selection)");
		IJavaElement jelem = getInitialJavaElement(selection);
		initContainerPage(jelem);
		initTypePage(jelem);
		doStatusUpdate();

		boolean[] values = new boolean[8];
		for (int i = 0; i < values.length - 3; i++) {
			values[i] = true;
		}

		IDialogSettings section =
			getDialogSettings().getSection(this.getName());
		if (section != null) {

			values[0] = section.getBoolean(SETTINGS_CREATE_INHERITED);
			values[1] = section.getBoolean(SETTINGS_CREATE_DOGET);
			values[2] = section.getBoolean(SETTINGS_CREATE_CONSTR);
			values[3] = section.getBoolean(SETTINGS_CREATE_DOPOST);
			values[4] = section.getBoolean(SETTINGS_CREATE_INITDESTROY);
			values[5] = section.getBoolean(SETTINGS_CREATE_DOPUT);
			values[6] = section.getBoolean(SETTINGS_CREATE_DODELETE);
			values[7] = section.getBoolean(SETTINGS_CREATE_SERVLETINFO);
		}
		setMethodStubSelection(values, true);
	}

	/**
	 * Returns the current selection state of the 'Create DoGet' checkbox.
	 * 
	 * @return the selection state of the 'Create DoGet' checkbox
	 */
	public boolean isCreateDoGet() {
		LogMessage.getInstance().log(
				"-> NewServletCreationWizardPage.isCreateDoGet()");
		return this.fMethodStubsButtons.isSelected(1);
	}

	/**
	 * Returns the current selection state of the 'Create DoPost' checkbox.
	 * 
	 * @return the selection state of the 'Create DoPost' checkbox
	 */
	public boolean isCreateDoPost() {
		LogMessage.getInstance().log(
				"-> NewServletCreationWizardPage.isCreateDoPost()");
		return this.fMethodStubsButtons.isSelected(3);
	}

	/**
	 * Returns the current selection state of the 'Create InitDestroy' checkbox.
	 * 
	 * @return the selection state of the 'Create InitDestroy' checkbox
	 */
	public boolean isCreateInitDestroy() {
		LogMessage.getInstance().log(
				"-> NewServletCreationWizardPage.isCreateInitDestroy()");
		return this.fMethodStubsButtons.isSelected(4);
	}

	/**
	 * Returns the current selection state of the 'Create DoPut' checkbox.
	 * 
	 * @return the selection state of the 'Create DoPut' checkbox
	 */
	public boolean isCreateDoPut() {
		LogMessage.getInstance().log(
				"-> NewServletCreationWizardPage.isCreateDoPut()");
		return this.fMethodStubsButtons.isSelected(5);
	}

	/**
	 * Returns the current selection state of the 'Create DoDelete' checkbox.
	 * 
	 * @return the selection state of the 'Create DoDelete' checkbox
	 */
	public boolean isCreateDoDelete() {
		LogMessage.getInstance().log(
				"-> NewServletCreationWizardPage.isCreateDoDelete()");
		return this.fMethodStubsButtons.isSelected(6);
	}

	/**
	 * Returns the current selection state of the 'Create getServletInfo'
	 * checkbox.
	 * 
	 * @return the selection state of the 'Create getServletInfo' checkbox
	 */
	public boolean isCreateGetServletInfo() {
		LogMessage.getInstance().log(
				"-> NewServletCreationWizardPage.isCreateGetServletInfo()");
		return this.fMethodStubsButtons.isSelected(7);
	}

	protected void updateSectionValues() {
		LogMessage.getInstance().log(
				"-> NewServletCreationWizardPage.updateSectionValues()");
		super.updateSectionValues();		
		IDialogSettings section =
			getDialogSettings().getSection(this.getName());

		section.put(SETTINGS_CREATE_DOPOST, isCreateDoPost());
		section.put(SETTINGS_CREATE_DOGET, isCreateDoGet());
		section.put(SETTINGS_CREATE_DODELETE, isCreateDoDelete());
		section.put(SETTINGS_CREATE_DOPUT, isCreateDoPut());
		section.put(SETTINGS_CREATE_INITDESTROY, isCreateInitDestroy());
		section.put(SETTINGS_CREATE_SERVLETINFO, isCreateGetServletInfo());
	}

	/**
	 * Builds the methods for the given type.
	 * 
	 * @param file the String loaded from the template file
	 * @param type the created type
	 * @param imports object used for importing classes
	 * @param monitor the monitor used during the process
	 * 
	 * @throws CoreException if a problem occured
	 */
	protected void createMethods(
		String file,
		IType type,
		ImportsManager imports,
		IProgressMonitor monitor)
		throws CoreException {
		LogMessage
				.getInstance()
				.log(
						"-> NewServletCreationWizardPage.createMethods(file, type, imports, monitor)");
		Map m = loadXmlParts(file, MARK_METHOD, TOKEN_NAME);
		boolean doGet = isCreateDoGet();
		boolean doPost = isCreateDoPost();
		boolean doInitDestroy = isCreateInitDestroy();
		boolean doPut = isCreateDoPut();
		boolean doDelete = isCreateDoDelete();
		boolean doGetServletInfo = isCreateGetServletInfo();
		Iterator it = m.keySet().iterator();
		while (it.hasNext()) {
			String key = (String) it.next();
			String body = (String) m.get(key);
			if ((!doGet && "doGet".equals(key))
				|| (!doPost && "doPost".equals(key))
				|| (!doPut && "doPut".equals(key))
				|| (!doDelete && "doDelete".equals(key))
				|| (!doGetServletInfo && "getServletInfo".equals(key))
				|| (!doInitDestroy
					&& ("init".equals(key) || "destroy".equals(key)))) {
				continue;
			}
			type.createMethod(body, null, false, monitor);
			body = null;
			key = null;
		}
		it = null;
		m.clear();
		m = null;
	}

	/**
	 * @see com.aston.NewTypeWizardPage#initThePage()
	 */
	protected void initThePage() {
		LogMessage.getInstance().log(
				"-> NewServletCreationWizardPage.initThePage()");
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.wizservlet"));
		setDescription(AstonWizardsPlugin.getResourceString("lg.label.servletwillgen"));
		//			values[0] = section.getBoolean(SETTINGS_CREATE_INHERITED);
		//			values[1] = section.getBoolean(SETTINGS_CREATE_DOGET);
		//			values[2] = section.getBoolean(SETTINGS_CREATE_CONSTR);
		//			values[3] = section.getBoolean(SETTINGS_CREATE_DOPOST);
		//			values[4] = section.getBoolean(SETTINGS_CREATE_INITDESTROY);
		//			values[5] = section.getBoolean(SETTINGS_CREATE_DOPUT);
		//			values[6] = section.getBoolean(SETTINGS_CREATE_DODELETE);
		//			values[7] = section.getBoolean(SETTINGS_CREATE_SERVLETINFO);

		String[] buttonNames3 =
			new String[] {
				AstonWizardsPlugin.getResourceString("lg.label.createim"),
				AstonWizardsPlugin.getResourceString("lg.label.createdoget"),
				AstonWizardsPlugin.getResourceString("lg.label.createc"),
				AstonWizardsPlugin.getResourceString("lg.label.createdopost"),
				AstonWizardsPlugin.getResourceString("lg.label.createinitdestroy"),
				AstonWizardsPlugin.getResourceString("lg.label.createdoput"),
				AstonWizardsPlugin.getResourceString("lg.label.createdodelete"),
				AstonWizardsPlugin.getResourceString("lg.label.creategetservletinfo")};
		this.fMethodStubsButtons =
			new SelectionButtonDialogFieldGroup(SWT.CHECK, buttonNames3, 2);
		this.fMethodStubsButtons.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.options"));
	}

	/**
	 * Adds specfic values to the Map of keys.
	 * 
	 * @param type type of the object
	 * @param imports the imports of the file
	 * @param monitor the progress bar
	 * @param values the current Map that contains values for the template
	 */
	protected void setSpecificValues(
		IType type,
		ImportsManager imports,
		IProgressMonitor monitor,
		Map values) {
		LogMessage
				.getInstance()
				.log(
						"-> NewServletCreationWizardPage.setSpecificValues(type, imports, monitor, values)");
		// Does nothing
	}

}