package com.aston.wizards.servlet;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewCreationWizard;
import com.aston.utils.Utils;

/**
 * This is a servlet creation Wizard.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>

 * @version 1.0
 */
public class NewServletCreationWizard extends NewCreationWizard {
	/** The only wizard page. */
	private NewServletCreationWizardPage fPage;
	private NewWebXmlLinkCreationWizardPage fPageWebXml;
 
	/**
	 * Constructor of the object. 
	 */
	public NewServletCreationWizard() {
		super();
		LogMessage.getInstance().log(
				"-> NewServletCreationWizard.NewServletCreationWizard()");
		setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
		setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
		setWindowTitle(AstonWizardsPlugin.getResourceString("lg.label.createservlet"));
	}

	/**
	 * Adds pages to the wizard. 
	 */
	public void addPages() {
		LogMessage.getInstance().log("-> NewServletCreationWizard.addPages()");
		this.fPage = new NewServletCreationWizardPage();
		this.fPageWebXml = new NewWebXmlLinkCreationWizardPage();

		addPage(this.fPage);
		addPage(this.fPageWebXml);
		this.fPageWebXml.setPreviousPage(this.fPage);
		this.fPage.init(getSelection());
		this.fPageWebXml.init(getSelection());
	}

	/**
	 * Is calls when wizard is about to finish. 
	 * 
	 * @return true when it has finished
	 */
	public boolean performFinish() {
		LogMessage.getInstance().log(
				"-> NewServletCreationWizard.performFinish()");
		try {
			boolean taskValue =
				finishPage(this.fPageWebXml.getRunnable())
					&& finishPage(this.fPage.getRunnable());
			if (taskValue) {
				ICompilationUnit cu =
					this.fPage.getCreatedType().getCompilationUnit();
//				if (cu.isWorkingCopy()) {
//					cu = (ICompilationUnit) cu.getOriginalElement();
//				}
				IResource resource = cu.getUnderlyingResource();
				selectAndReveal(resource);
				openResource(resource);
				return true;
			}
		} catch (Exception e) {
			Utils.showError(e, getShell());
		}
		return false;
	}
}
