package com.aston.wizards.designpattern;
import java.util.Map;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.compiler.env.IConstants;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;

/**
 * Wizard page to create a new Singleton class. <p>
 * 
 * This class is inspired of the org.eclipse.jdt.ui.wizards.NewClassWizardPage.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.0
 * @since Eclipse 2.0
 */
public class NewSingletonCreationWizardPage
	extends com.aston.NewTypeWizardPage {
 
	/**
	 * Constructor of the object. 
	 */
	public NewSingletonCreationWizardPage() {
		super(true, "NewSingletonCreationWizardPage", "singleton");
		LogMessage
				.getInstance()
				.log(
						"-> NewSingletonCreationWizardPage.NewSingletonCreationWizardPage()");
	}

	protected void initThePage() {
		LogMessage.getInstance().log(
				"-> NewSingletonCreationWizardPage.initThePage()");
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.singwizard"));
		setDescription(AstonWizardsPlugin.getResourceString("lg.label.singwillgen"));
		String[] buttonNames3 =
			new String[] {
				AstonWizardsPlugin.getResourceString("lg.label.createim"),
				AstonWizardsPlugin.getResourceString("lg.label.createmain"),
				AstonWizardsPlugin.getResourceString("lg.label.createc")};
		this.fMethodStubsButtons =
			new SelectionButtonDialogFieldGroup(SWT.CHECK, buttonNames3, 2);
		this.fMethodStubsButtons.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.options"));
		// TODO Handle visibility and abstract/final value with a tag and not in hard
		setModifiers(IConstants.AccFinal | IConstants.AccPublic, true);
	}

	/**
	 * The wizard owning this page is responsible for calling this method 
	 * with the current selection. The selection is used to 
	 * initialize the fields of the wizard page.
	 * 
	 * @param selection used to initialize the fields
	 */
	public void init(IStructuredSelection selection) {
		LogMessage.getInstance().log(
				"-> NewSingletonCreationWizardPage.init(selection)");
		IJavaElement jelem = getInitialJavaElement(selection);
		initContainerPage(jelem);
		initTypePage(jelem);
		doStatusUpdate();

		boolean[] values = new boolean[3];
		values[2] = true;

		IDialogSettings section =
			getDialogSettings().getSection(this.getName());
		if (section != null) {
			values[0] = section.getBoolean(SETTINGS_CREATE_INHERITED);
			values[1] = section.getBoolean(SETTINGS_CREATE_MAIN);
			values[2] = section.getBoolean(SETTINGS_CREATE_CONSTR);
		}
		setMethodStubSelection(values, true);
	}

	/**
	 * Adds specfic values to the Map of keys.
	 * 
	 * @param type type of the object
	 * @param imports the imports of the file
	 * @param monitor the progress bar
	 * @param values the current Map that contains values for the template
	 */
	protected void setSpecificValues(
		IType type,
		ImportsManager imports,
		IProgressMonitor monitor,
		Map values) {
		LogMessage
				.getInstance()
				.log(
						"-> NewSingletonCreationWizardPage.setSpecificValues(type, imports, monitor, values)");
		// Does nothing
	}
}