package com.aston.wizards.designpattern;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewCreationWizard;
import com.aston.utils.Utils;

/**
 * This is an array creation Wizard.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>

 * @version 1.0
 */
public class NewListCreationWizard extends NewCreationWizard {
	/** The only wizard page. */
	private NewListCreationWizardPage fPage;
 
	/**
	 * Constructor of the object. 
	 */
	public NewListCreationWizard() {
		super();
		LogMessage.getInstance().log(
				"-> NewListCreationWizard.NewListCreationWizard()");
		setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
		setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
		setWindowTitle(AstonWizardsPlugin.getResourceString("lg.label.createlist"));
	}

	/**
	 * Adds pages to the wizard. 
	 */
	public void addPages() {
		LogMessage.getInstance().log("-> NewListCreationWizard.addPages()");
		super.addPages();
		this.fPage = new NewListCreationWizardPage();
		addPage(this.fPage);
		this.fPage.init(getSelection());
	}

	/**
	 * Is calls when wizard is about to finish. 
	 * 
	 * @return true when it has finished
	 */
	public boolean performFinish() {
		LogMessage.getInstance()
				.log("-> NewListCreationWizard.performFinish()");
		try {
			if (finishPage(this.fPage.getRunnable())) {
				ICompilationUnit cu =
					this.fPage.getCreatedType().getCompilationUnit();
//				if (cu.isWorkingCopy()) {
//					cu = (ICompilationUnit) cu.getOriginalElement();
//				}
				IResource resource = cu.getUnderlyingResource();
				selectAndReveal(resource);
				openResource(resource);
				return true;
			}
		} catch (Exception e) {
			Utils.showError(e, getShell());
		}
		return false;
	}
}
