package com.aston.wizards.designpattern;

import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewCreationWizard;
import com.aston.utils.Utils;

/**
 * This is an enumeration creation Wizard.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author
 * <ul>
 *     <li><a href="mailto:jean-noel.meunier@aonix.fr">Jean-Noel Meunier</a></li>
 * </ul> 
 */
public class NewEnumerationCreationWizard extends NewCreationWizard {
	/** The only wizard page. */
	private NewEnumerationCreationWizardPage fPage;
 
	/**
	 * Constructor of the object.
	 */
	public NewEnumerationCreationWizard() {
		super();
		LogMessage
				.getInstance()
				.log(
						"-> NewEnumerationCreationWizard.NewEnumerationCreationWizard()");
		setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
		setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
		setWindowTitle(AstonWizardsPlugin.getResourceString("lg.label.createenum"));
	}

	/**
	 * Adds pages to the wizard. 
	 */
	public void addPages() {
		LogMessage.getInstance().log(
				"-> NewEnumerationCreationWizard.addPages()");
		this.fPage = new NewEnumerationCreationWizardPage();
		addPage(this.fPage);
		this.fPage.init(getSelection());
	}

	/**
	 * Is calls when wizard is about to finish. 
	 * 
	 * @return true when it has finished
	 */
	public boolean performFinish() {
		LogMessage.getInstance().log(
				"-> NewEnumerationCreationWizard.performFinish()");
		try {
			if (finishPage(this.fPage.getRunnable())) {
				ICompilationUnit cu =
					this.fPage.getCreatedType().getCompilationUnit();
//				if (cu.isWorkingCopy()) {
//					cu = (ICompilationUnit) cu.getOriginalElement();
//				}
				org.eclipse.core.resources.IResource resource =
					cu.getUnderlyingResource();
				selectAndReveal(resource);
				openResource(resource);
				return true;
			}
		} catch (Exception e) {
			Utils.showError(e, getShell());
		}
		return false;
	}

}
