package com.aston.wizards.designpattern;

import org.eclipse.jdt.internal.ui.wizards.dialogfields.SelectionButtonDialogFieldGroup;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.swt.SWT;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewTypeContainerWizardPage;

/**
 * Wizard page to create a new Array class. <p>
 * 
 * This class is inspired of the org.eclipse.jdt.ui.wizards.NewClassWizardPage.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.0
 * @since Eclipse 2.0
 */
public class NewArrayCreationWizardPage extends NewTypeContainerWizardPage {
 
	/**
	 * Constructor of the object.
	 * 
	 * @param isClass <code>true</code> if a new class is to be created; otherwise
	 * an interface is to be created
	 * @param pageName the wizard page's name
	 * @param templateKey the template key 
	 */
	protected NewArrayCreationWizardPage(boolean isClass, String pageName, String templateKey) {
		super(isClass, pageName, templateKey);
		LogMessage
				.getInstance()
				.log(
						"-> NewArrayCreationWizardPage.NewArrayCreationWizardPage(isClass, pageName, templateKey)");
	}

	/**
	 * Constructor of the object. 
	 */
	public NewArrayCreationWizardPage() {
		this(true, "NewArrayCreationWizardPage", "array");
		LogMessage.getInstance().log(
				"-> NewArrayCreationWizardPage.NewArrayCreationWizardPage()");
	}

	/**
	 * Initialize the all page.
	 */
	protected void initThePage() {
		LogMessage.getInstance().log(
				"-> NewArrayCreationWizardPage.initThePage()");
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.arraywiz"));
		setDescription(AstonWizardsPlugin.getResourceString("lg.label.willgenarray"));

		String[] buttonNames3 =
			new String[] {
				AstonWizardsPlugin.getResourceString("lg.label.createim"),
				AstonWizardsPlugin.getResourceString("lg.label.createmain"),
				AstonWizardsPlugin.getResourceString("lg.label.createc")};
		this.fMethodStubsButtons =
			new SelectionButtonDialogFieldGroup(SWT.CHECK, buttonNames3, 2);
		this.fMethodStubsButtons.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.options"));

		TypeFieldsAdapter adapter = new TypeFieldsAdapter();
		adapter.setDialogTitle(
			AstonWizardsPlugin.getResourceString("lg.label.choosecontained"));
		adapter.setDialogMessage(
			AstonWizardsPlugin.getResourceString("lg.label.selectcontained"));

		this.fContainedClassDialogField = new StringButtonDialogField(adapter);
		this.fContainedClassDialogField.setDialogFieldListener(adapter);
		this.fContainedClassDialogField.setLabelText(
			AstonWizardsPlugin.getResourceString("lg.label.arraycontonly"));
		this.fContainedClassDialogField.setButtonLabel(
			AstonWizardsPlugin.getResourceString("lg.label.select"));

	}
}