package com.aston.wizards.applet;

import java.util.HashMap;
import java.util.Map;

import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.PreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.utils.Utils;

/**
 * Wizard page to create a new HTML page for your applet class. <p>
 * 
 * This class is inspired of the org.eclipse.jdt.ui.wizards.NewClassWizardPage.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 1.1
 * @since Eclipse 2.0
 */
public class NewAppletHtmlCreationWizardPage extends com.aston.WizardPage {
 
	private final static String GENERATE_HTML = "generateHtml";

	private Text classNameText;
	private Text codeBaseText;

	private Text appletNameText;
	private Text appletWidthText;
	private Text appletHeightText;

	private Button button;

	/**
	 * Constructor for NewAppletHtmlCreationWizardPage.
	 */
	public NewAppletHtmlCreationWizardPage() {
		super("NewAppletHtmlCreationWizardPage", "applethtml");
		LogMessage
				.getInstance()
				.log(
						"-> NewAppletHtmlCreationWizardPage.NewAppletHtmlCreationWizardPage()");
		setTitle(AstonWizardsPlugin.getResourceString("lg.label.applethtml"));
		setDescription(
			AstonWizardsPlugin.getResourceString("lg.label.willcreateapplethtml"));
	}

	/**
	 * Create a control for this page.
	 * 
	 * @param parent the parent of this control
	 * @see IDialogPage#createControl(Composite)
	 */
	public void createControl(Composite parent) {
		LogMessage.getInstance().log(
				"-> NewAppletHtmlCreationWizardPage.createControl(parent)");
		Composite container = new Composite(parent, SWT.NULL);
		GridLayout layout = new GridLayout();
		container.setLayout(layout);
		layout.numColumns = 3;
		layout.verticalSpacing = 10;

		Composite c = new Composite(container, SWT.NULL);

		this.generateBool =
			new BooleanFieldEditor(
				GENERATE_HTML,
				AstonWizardsPlugin.getResourceString("lg.label.generatehtml"),
				c);
		PreferenceStore ps = new PreferenceStore();
		ps.setValue(GENERATE_HTML, true);
		this.generateBool.setPreferenceStore(ps);
		this.generateBool.load();
		this.generateBool.setPropertyChangeListener(new IPropertyChangeListener() {
			public void propertyChange(PropertyChangeEvent e) {
				NewAppletHtmlCreationWizardPage.this.generateBoolUpdate();
			}
		});
		Label label = new Label(container, SWT.NULL);
		label = new Label(container, SWT.NULL);

		label = new Label(container, SWT.NULL);
		label = new Label(container, SWT.NULL);
		label = new Label(container, SWT.NULL);

		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.appletclassname"));
		this.classNameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		this.classNameText.setEditable(false);
		this.classNameText.setEnabled(false);
		GridData gd = new GridData(GridData.FILL_HORIZONTAL);
		this.classNameText.setLayoutData(gd);
		label = new Label(container, SWT.NULL);

		ModifyListener ml = new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				NewAppletHtmlCreationWizardPage.this.dialogChanged();
			}
		};

		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.codebase"));
		this.codeBaseText = new Text(container, SWT.BORDER | SWT.SINGLE);
		this.codeBaseText.setText(".");
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.codeBaseText.setLayoutData(gd);
		this.codeBaseText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.filepath"));
		this.filePathText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.filePathText.setLayoutData(gd);
		this.filePathText.addModifyListener(ml);
		this.button = new Button(container, SWT.PUSH);
		this.button.setText(AstonWizardsPlugin.getResourceString("lg.label.browse"));
		this.button.addSelectionListener(new SelectionAdapter() {
			public void widgetSelected(SelectionEvent e) {
				NewAppletHtmlCreationWizardPage.this.handleBrowse();
			}
		});

		// File Name
		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.filename"));
		this.fileNameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.fileNameText.setLayoutData(gd);
		this.fileNameText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		// Applet Name
		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.appletname"));
		this.appletNameText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.appletNameText.setLayoutData(gd);
		this.appletNameText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		// Applet width
		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.appletwidth"));
		this.appletWidthText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.appletWidthText.setLayoutData(gd);
		this.appletWidthText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		// Applet height
		label = new Label(container, SWT.NULL);
		label.setText(AstonWizardsPlugin.getResourceString("lg.label.appletheight"));
		this.appletHeightText = new Text(container, SWT.BORDER | SWT.SINGLE);
		gd = new GridData(GridData.FILL_HORIZONTAL);
		this.appletHeightText.setLayoutData(gd);
		this.appletHeightText.addModifyListener(ml);
		label = new Label(container, SWT.NULL);

		createControlForTemplate(container, layout.numColumns);

		dialogChanged();
		setControl(container);
	}

	/**
	 * Called when user check (or uncheck) the generate HTML page.
	 */
	public void generateBoolUpdate() {
		LogMessage.getInstance().log(
				"-> NewAppletHtmlCreationWizardPage.generateBoolUpdate()");
		boolean value = this.generateBool.getBooleanValue();

		this.fileNameText.setEditable(value);
		this.filePathText.setEditable(value);
		this.codeBaseText.setEditable(value);
		this.appletNameText.setEditable(value);
		this.appletWidthText.setEditable(value);
		this.appletHeightText.setEditable(value);

		this.fileNameText.setEnabled(value);
		this.filePathText.setEnabled(value);
		this.codeBaseText.setEnabled(value);
		this.appletNameText.setEnabled(value);
		this.appletWidthText.setEnabled(value);
		this.appletHeightText.setEnabled(value);
		this.templateList.setEnabled(value);
		this.button.setEnabled(value);
		dialogChanged();
	}

	/**
	 * Makes this wizard page visible or not.
	 * 
	 * @param b true will show the page, false will hide it
	 */
	public void setVisible(boolean b) {
		LogMessage.getInstance().log(
				"-> NewAppletHtmlCreationWizardPage.setVisible(b)");
		NewAppletCreationWizardPage p =
			(NewAppletCreationWizardPage) getPreviousPage();
		if (p != null) {
			String pck = p.getPackageText();
			if (!"".equals(pck)) {
				pck += ".";
			}
			this.classNameText.setText(pck + p.getTypeName() + ".class");
			this.filePathText.setText(
				"/" + Utils.getProjectPath(p.getPackageFragmentRootText()));
			this.fileNameText.setText(
				"StartPageFor" + p.getTypeName() + ".html");
			this.appletNameText.setText(p.getTypeName());
			this.appletWidthText.setText("320");
			this.appletHeightText.setText("240");
		}
		super.setVisible(b);
	}

	/**
	 * Ensures that all text fields are set.
	 */
	protected void dialogChanged() {
		LogMessage.getInstance().log(
				"-> NewAppletHtmlCreationWizardPage.dialogChanged()");
		if (this.generateBool.getBooleanValue()) {
			super.dialogChanged();
			if (isPageComplete()) {
				String fileName = getFileName();
				if (!fileName.toLowerCase().endsWith(".html")
					&& !fileName.toLowerCase().endsWith(".htm")) {
					setErrorMessage(
						AstonWizardsPlugin.getResourceString(
							"lg.warning.htmlfilemustbe"));
					setPageComplete(false);
					return;
				}

				if (this.codeBaseText.getText().trim().length() == 0) {
					setErrorMessage(
						AstonWizardsPlugin.getResourceString("lg.warning.codebase"));
					setPageComplete(false);
					return;
				}

				if (this.appletNameText.getText().trim().length() == 0) {
					setErrorMessage(
						AstonWizardsPlugin.getResourceString("lg.warning.appletname"));
					setPageComplete(false);
					return;
				}

				if (this.appletWidthText.getText().trim().length() == 0) {
					setErrorMessage(
						AstonWizardsPlugin.getResourceString("lg.warning.widthmustbe"));
					setPageComplete(false);
					return;
				}
				try {
					Integer.parseInt(this.appletWidthText.getText());
				} catch (NumberFormatException nfe) {
					setErrorMessage(
						AstonWizardsPlugin.getResourceString(
							"lg.warning.widthinteger"));
					setPageComplete(false);
					return;
				}

				if (this.appletHeightText.getText().trim().length() == 0) {
					setErrorMessage(
						AstonWizardsPlugin.getResourceString(
							"lg.warning.heightmustbe"));
					setPageComplete(false);
					return;
				}
				try {
					Integer.parseInt(this.appletHeightText.getText());
				} catch (NumberFormatException nfe) {
					setErrorMessage(
						AstonWizardsPlugin.getResourceString(
							"lg.warning.heightinteger"));
					setPageComplete(false);
					return;
				}
			}
		} else {
			setPageComplete(true);
			setErrorMessage(null);
		}
	}

	/**
	 * Returns the runnable that creates the type using the current settings.
	 * The returned runnable must be executed in the UI thread.
	 * 
	 * @return the runnable to create the new type
	 */
	public IRunnableWithProgress getRunnable() {
		LogMessage.getInstance().log(
				"-> NewAppletHtmlCreationWizardPage.getRunnable()");
		Map values = new HashMap(8);
		values.put(MARK_APPLET_CODE_BASE, this.codeBaseText.getText());
		values.put(MARK_APPLET_CLASS, this.classNameText.getText());
		values.put(MARK_APPLET_NAME, this.appletNameText.getText());
		values.put(MARK_APPLET_WIDTH, this.appletWidthText.getText());
		values.put(MARK_APPLET_HEIGHT, this.appletHeightText.getText());
		values.put(MARK_TEMPLATE_NAME, getTemplateFileName());
		values.put(MARK_FILE_NAME, getFileName());
		values.put(MARK_FILE_PATH, getFilePath());

		return new AstonRunnableWithProgress(values, this);
	}
}