package com.aston.wizards.applet;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;

import com.aston.AstonWizardsPlugin;
import com.aston.LogMessage;
import com.aston.NewCreationWizard;
import com.aston.utils.Utils;

/**
 * This is an applet creation Wizard.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 2.0
 */
public class NewAppletCreationWizard extends NewCreationWizard {
	/** The wizard pages. */
	private NewAppletCreationWizardPage fPage;
	private NewAppletHtmlCreationWizardPage fPageHtml;
	protected final static String WIZARD_NAME = "NewAppletCreationWizard";
	 

	/**
	 * Constructor of the object. 
	 */
	public NewAppletCreationWizard() {
		super();
		LogMessage.getInstance().log(
				"-> NewAppletCreationWizard.NewAppletCreationWizard()");
		setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWCLASS);
		setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
		setWindowTitle(AstonWizardsPlugin.getResourceString("lg.label.createapplet"));
	}

	/**
	 * Adds pages to the wizard. 
	 */
	public void addPages() {
		LogMessage.getInstance().log("-> NewAppletCreationWizard.addPages()");
		this.fPage = new NewAppletCreationWizardPage();
		this.fPageHtml = new NewAppletHtmlCreationWizardPage();
		addPage(this.fPage);
		addPage(this.fPageHtml);

		this.fPageHtml.setPreviousPage(this.fPage);

		this.fPage.init(getSelection());
	}

	/**
	 * Is calls when wizard is about to finish. 
	 * 
	 * @return true when it has finished
	 */
	public boolean performFinish() {
		LogMessage.getInstance().log(
				"-> NewAppletCreationWizard.performFinish()");
		try {
			boolean taskValue =
				finishPage(this.fPageHtml.getRunnable())
					&& finishPage(this.fPage.getRunnable());
			
			if (taskValue) {				
				ICompilationUnit cu =
					this.fPage.getCreatedType().getCompilationUnit();
//				if (cu.isWorkingCopy()) {					
//					cu = (ICompilationUnit) cu.getOriginalElement();
//				}
				IResource resource = cu.getUnderlyingResource();
				openResource(resource);
				return true;
			}
		} catch (Exception e) {
			Utils.showError(e, getShell());
		}
		return false;
	}
}
