package com.aston.utils;

import java.awt.Point;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

import com.aston.AstonWizardsPlugin;

/**
 * This is my utility class, it helps me for getting project name 
 * and things like that.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version 2.0
 * @since Eclipse 2.0
 */
public final class Utils extends Object {
 
	/** Available HTML Doctypes. */
	public final static List DOCTYPE_VALUES =
		Utils.loadImplementationFor("doctype.html");

	/** Available Map class. */
	public final static List MAP_CLASS =
		Utils.loadImplementationFor("struct.map");

	/** Available List class. */
	public final static List LIST_CLASS =
		Utils.loadImplementationFor("struct.list");

	/** Available Set class. */
	public final static List SET_CLASS =
		Utils.loadImplementationFor("struct.set");

	/** available basic types. */
	public final static String[] BASIC_TYPES = { "int", // 0 
		"long", // 1
		"short", // 2
		"byte", // 3
		"float", // 4
		"double", // 5
		"char", // 6
		"boolean" // 7
	};

	public final static Map WRAPPERS = new HashMap();
	// Shame on me :-)
	static {
		WRAPPERS.put("int", "Integer");
		WRAPPERS.put("long", "Long");
		WRAPPERS.put("short", "Short");
		WRAPPERS.put("byte", "Byte");
		WRAPPERS.put("float", "Float");
		WRAPPERS.put("double", "Double");
		WRAPPERS.put("char", "Character");
		WRAPPERS.put("boolean", "Boolean");
	}

	public final static Map WRAPPERS_AS_NULL = new HashMap();
	// Shame on me :-), bis :->
	static {
		WRAPPERS_AS_NULL.put("int", "Integer.MIN_VALUE");
		WRAPPERS_AS_NULL.put("long", "Long.MIN_VALUE");
		WRAPPERS_AS_NULL.put("short", "Short.MIN_VALUE");
		WRAPPERS_AS_NULL.put("byte", "Byte.MIN_VALUE");
		WRAPPERS_AS_NULL.put("float", "Float.NaN");
		WRAPPERS_AS_NULL.put("double", "Double.NaN");
		WRAPPERS_AS_NULL.put("char", "(char)Character.MIN_VALUE");
		WRAPPERS_AS_NULL.put("boolean", "false");
	}

	/**
	 * Constructor for Utils.
	 */
	private Utils() {
		throw new RuntimeException("Can not be instanciate !");
	}

	/**
	 * Returns the project path.
	 * 
	 * @param aString string like /toto/src/titi
	 * @return the package root, /toto here
	 */
	public static String getProjectPath(String aString) {
		if (aString != null && aString.length() > 1) {
			int id = aString.indexOf('/', 1);
			if (id != -1) {
				return aString.substring(0, id);
			}
		}
		return aString;
	}

	/**
	 * Returns the jsp path.
	 * 
	 * @param aString string like /MyProject/client/
	 * @return the package root, /client here
	 */
	public static String getJspPath(String aString) {
		if (aString != null && aString.length() > 1) {
			int id = aString.indexOf('/', 1);
			if (id != -1) {
				return aString.substring(id);
			}
		}
		return "";
	}

	/**
	 * Returns the jsp name without '.jsp'.
	 * 
	 * @param aString string like MyJsp.jsp
	 * @return the Jsp name without extension: MyJsp
	 */
	public static String getJspName(String aString) {
		if (aString != null) {
			int id = aString.lastIndexOf('.');
			if (id != -1) {
				return aString.substring(0, id);
			}
		}
		return aString;
	}


	/**
	 * The path will be transformed into package name.
	 * 
	 * @param ipf a package object 
	 * @return the package string value as Java package, means toto.titi instead of toto/titi
	 */
	public static String getPackageRealName(IPackageFragment ipf) {
		if (ipf != null) {
			String path = ipf.getPath().toString();
			int id = path.indexOf('/', 1);
			if (id != -1) {
				return path.replace('/', '.').substring(id + 1);
			}
		}
		return "";
	}

	/**
	 * Gets a short class name from a long one. 
	 * 
	 * @param longClassName the long class name
	 * @return the short class name
	 */
	public static String getClassName(String longClassName) {
		if (longClassName == null)
			return null;
		int id = longClassName.lastIndexOf('.');
		if (id != -1) {
			return longClassName.substring(id + 1);
		}
		return longClassName;
	}

	/**
	 * Returns true if the given string is a basic type.
	 * 
	 * @param aString the string that should be tested
	 * @return true if the string is a basic type (int, short ...)
	 */
	public static boolean isBasicType(String aString) {
		return Utils.WRAPPERS.containsKey(aString);
	}

	/**
	 * Return the class name of the object. 
	 * 
	 * Example : if aString = "int", then "Integer" is returned. If aString is not a 
	 * basic type then aString is returned
	 * 
	 * @param aString a basic type or a class type
	 * 
	 * @return the class name of the object. 
	 */
	public static String getObject(String aString) {
		String type = (String) Utils.WRAPPERS.get(aString);
		if (type == null) {
			type = aString;
		}
		return type;
	}

	/**
	 * Puts in the StringBuffer the object type of the given string.
	 * 
	 * Exemple : if aString=="int" then "Integer" is appended in the buffer
	 * 
	 * @param aString a basic type or a class type
	 * @param sb where to append the string
	 * @param start where to start writing
	 * @param end where to end writing
	 */
	public static void asObject(
		String aString,
		StringBuffer sb,
		int start,
		int end) {
		if (start < end) {
			sb.replace(start, end, Utils.getObject(aString));
		} else {
			sb.append(Utils.getObject(aString));
		}
	}

	/**
	 * Puts in the StringBuffer the object type of the given string.
	 * 
	 * Exemple : if aString=="int" then "Integer" is appended in the buffer
	 * 
	 * @param aString a basic type or a class type
	 * @param sb where to append the string
	 */
	public static void asObject(String aString, StringBuffer sb) {
		Utils.asObject(aString, sb, sb.length(), sb.length());
	}

	/**
	 * Puts in the StringBuffer the object type of the given string.
	 * 
	 * Exemple : if aString=="int" and anAttr="10" then "new Integer(10)" is appended in the buffer
	 * 
	 * @param aString a basic type or a class type
	 * @param anAttr an attribut for the contructor
	 * @param sb where to append the string
	 * @param start where to start writing
	 * @param end where to end writing
	 */
	public static void asNewObject(
		String aString,
		String anAttr,
		StringBuffer sb,
		int start,
		int end) {
		if ("int".equals(aString)) {
			anAttr = "new Integer(" + anAttr + ")";
		} else if ("long".equals(aString)) {
			anAttr = "new Long(" + anAttr + ")";
		} else if ("short".equals(aString)) {
			anAttr = "new Short(" + anAttr + ")";
		} else if ("byte".equals(aString)) {
			anAttr = "new Byte(" + anAttr + ")";
		} else if ("float".equals(aString)) {
			anAttr = "new Float(" + anAttr + ")";
		} else if ("double".equals(aString)) {
			anAttr = "new Double(" + anAttr + ")";
		} else if ("char".equals(aString)) {
			anAttr = "new Character(" + anAttr + ")";
		} else if ("boolean".equals(aString)) {
			anAttr = "new Boolean(" + anAttr + ")";
		}

		if (start < end) {
			sb.replace(start, end, anAttr);
		} else {
			sb.append(anAttr);
		}
	}

	/**
	 * Puts in the StringBuffer the object type of the given string.
	 * 
	 * Exemple : if aString=="int" and anAttr="10" then "new Integer(10)" is appended in the buffer
	 * 
	 * @param aString a basic type or a class type
	 * @param anAttr an attribut for the contructor
	 * @param sb where to append the string
	 */
	public static void asNewObject(
		String aString,
		String anAttr,
		StringBuffer sb) {
		Utils.asNewObject(aString, anAttr, sb, sb.length(), sb.length());
	}

	/**
	 * Returns the null value for the given basic type.
	 * 
	 * Exemple : if aString=="int" then "Integer.MIN_VALUE" is returned. If aString is not a
	 * basic type then "null" is returned.
	 * 
	 * @param aString a basic type or a class type
	 * 
	 * @return the null value for the given basic type.
	 */
	public static String getNull(String aString) {
		String resu = (String) Utils.WRAPPERS_AS_NULL.get(aString);
		if (resu == null) {
			resu = "null";
		}
		return resu;
	}

	/**
	 * Puts in the StringBuffer the object type of the given string.
	 * 
	 * Exemple : if aString=="int" then "Integer.MIN_VALUE" is appended in the buffer. If aString is not a
	 * basic type then "null" is appended.
	 * 
	 * @param aString a basic type or a class type
	 * @param sb where to append the string
	 * @param start where to start writing
	 * @param end where to end writing
	 */
	public static void replaceWithNull(
		String aString,
		StringBuffer sb,
		int start,
		int end) {
		if (start < end) {
			sb.replace(start, end, Utils.getNull(aString));
		} else {
			sb.append(Utils.getNull(aString));
		}
	}

	/**
	 * Puts in the StringBuffer the object type of the given string.
	 * 
	 * Exemple : if aString=="int" then "new Integer.MAX_VALUE" is appended in the buffer
	 * 
	 * @param aString a basic type or a class type
	 * @param sb where to append the string
	 */
	public static void replaceWithNull(String aString, StringBuffer sb) {
		Utils.replaceWithNull(aString, sb, sb.length(), sb.length());
	}

	/**
	 * Replace a String by an other one. <br>
	 * 
	 * @param from the String where to replace all things
	 * @param oldValue the old String that will be replaced
	 * @param newValue the new String that will replace the old one
	 */
	public void replaceWith(
		StringBuffer from,
		String oldValue,
		String newValue) {
		int oldLength = oldValue.length();
		int newLength = newValue.length();
		int start = from.toString().indexOf(oldValue, 0);
		while (start != -1) {
			int end = start + oldLength;
			from.replace(start, end, newValue);
			start = from.toString().indexOf(oldValue, start + newLength);
		}
	}

	/**
	 * Replace a String by an other one. <br>
	 * 
	 * @param from the String where to replace all things
	 * @param oldValue the old String that will be replaced
	 * @param newValue the new String that will replace the old one
	 */
	public static void replaceWithForEmptyXmlTokenType(
		StringBuffer from,
		String oldValue,
		String newValue)
		throws CoreException {
		String file = from.toString();

		int start = file.indexOf(oldValue, 0);
		List where = new ArrayList();
		while (start != -1) {
			int end = file.indexOf("/>", start + oldValue.length());
			if (end < 0) {
				Utils.throwCoreException(
					AstonWizardsPlugin.getResourceString(
						"lg.error.tokennotclosed",
						oldValue),
					"");
				break;
			}
			end += 2;
			where.add(new Point(start, end));
			start = file.indexOf(oldValue, end);
		}
		// Replace all
		for (int i = where.size() - 1; i >= 0; i--) {
			Point p = (Point) where.get(i);
			from.replace(p.x, p.y, newValue);
		}
		where.clear();
		where = null;
	}

	/**
	 * Takes a Map and build an arry of string from its values or keys.
	 * 
	 * @param aMap the map
	 * @param onKeys means that you want a String array with its keys
	 * 
	 * @return a String array of its values of its keys
	 */
	public static String[] asStringArray(Map aMap, boolean onKeys) {
		Iterator it =
			(onKeys) ? aMap.keySet().iterator() : aMap.values().iterator();
		String[] resu =
			(onKeys)
				? new String[aMap.keySet().size()]
				: new String[aMap.values().size()];
		int i = 0;
		while (it.hasNext()) {
			resu[i] = (String) it.next();
			i++;
		}
		return resu;
	}

	/**
	 * Takes a List and build an arry of string from its values.
	 * 
	 * @param aList the list
	 * 
	 * @return a String array of its values
	 */
	public static String[] asStringArray(List aList) {
		Iterator it = aList.iterator();
		String[] resu = new String[aList.size()];
		int i = 0;
		while (it.hasNext()) {
			resu[i] = (String) it.next();
			i++;
		}
		return resu;
	}

	/**
	 * Popups an erros window with the error message of the exception.
	 * 
	 * @param e an exception
	 * @param shell a shell
	 */
	public static void showError(Exception e, Shell shell) {
		if (e != null && shell != null) {
			Utils.showError(e.getMessage(), shell);
			JavaPlugin.log(e);
		}
	}

	/**
	 * Popups an erros window with the error message of the exception.
	 * 
	 * @param msg a message
	 * @param shell a shell
	 */
	public static void showError(String msg, Shell shell) {
		if (msg != null && shell != null) {
			MessageBox mb =
				new MessageBox(
					shell,
					SWT.OK | SWT.ICON_ERROR | SWT.APPLICATION_MODAL);
			mb.setMessage(msg);
			mb.open();
		}
	}

	/**
	 * Popups an erros window with the error message of the exception.
	 * 
	 * @param msg a message
	 */
	public static void showError(String msg) {
		Utils.showError(msg, AstonWizardsPlugin.getDefault().getShell());
	}

	/**
	 * Popups an erros window with the error message of the exception.
	 * 
	 * @param e an exception
	 */
	public static void showError(Exception e) {
		Utils.showError(e, AstonWizardsPlugin.getDefault().getShell());
	}

	/**
	 * Throws CoreException with the given message.
	 * 
	 * @param message the message to show as error
	 * @param pageName the name of the page
	 * @throws CoreException always
	 */
	public static void throwCoreException(String message, String pageName)
		throws CoreException {
		IStatus status =
			new Status(IStatus.ERROR, pageName, IStatus.OK, message, null);
		throw new CoreException(status);
	}

	/**
	 * Loads all templates that starts with the given string.
	 * 
	 * Description will be used as key, and file name will be the value.
	 * 
	 * @param nameBeginsWith a starting entry in the properties file
	 * 
	 * @return a map of all templates
	 */
	public static List loadImplementationFor(String nameBeginsWith) {
		int i = 1;
		List resu = new ArrayList();
		while (true) {
			String key = nameBeginsWith + "." + i;
			String value =
				AstonWizardsPlugin
					.getTemplatePreferences()
					.getString(
					key);
			// System.out.println("Key="+key+" Value="+value);
			if (value != null && !"".equals(value)) {
				resu.add(value);
			} else {
				// if not found I simply break
				break;
			}
			i++;
		}
		return resu;
	}

	/**
	 * Search for a position of a string in a string.
	 * 
	 * @param file the string where to search
	 * @param toLeft if true indicate that we want to search at the left of the <i>from</i> position
	 * @param from index where to start searching
	 * @param token what we are looking for
	 * 
	 * @return the start index of where to find the searched token
	 */
	public static int searchTo(
		String file,
		boolean toLeft,
		int from,
		String token) {
		if (!toLeft) {
			return file.indexOf(token, from);
		}
		String subFile = file.substring(0, from);
		return subFile.lastIndexOf(token, 0);
	}
}
