package com.aston;

import java.io.IOException;
import java.util.Map;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.StringButtonDialogField;
import org.eclipse.swt.SWT;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;

import com.aston.utils.Utils;

/**
 * This is a New NewTypeDoubleContainer Wizard.
 * 
 * This wizard will carry two kinds of object inside, like a dictionnary or a Map of object. <br>
 * 
 * This wizard will create a Java Class. <br>
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard</a><br>
 *
 * @author 
 * <ul>
 * 	<li><a href="mailto:renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * 
 * @version 1.0
 * @since Eclipse 2.0
 */ 
public abstract class NewTypeDoubleContainerWizardPage
	extends NewTypeContainerWizardPage {

	protected StringButtonDialogField fSecondContainedClassDialogField;
	protected IType secondContainedType;
	protected TypeFieldsAdapter adapter;

	/**
	 * Constructor of the object.
	 * 
	 * @param isClass <code>true</code> if a new class is to be created; otherwise
	 * an interface is to be created
	 * @param pageName the wizard page's name
	 * @param templateKey the template key 
	 */
	public NewTypeDoubleContainerWizardPage(boolean isClass, String pageName, String templateKey) {
		super(isClass, pageName, templateKey);
		LogMessage
				.getInstance()
				.log(
						"-> NewTypeDoubleContainerWizardPage.NewTypeDoubleContainerWizardPage(isClass, pageName, templateKey)");
	}

	/**
	 * Updates status. 
	 * 
	 * 
	 * This method is called each time a change in made in the fields of the wizard panel
	 */
	protected void doStatusUpdate() {
		LogMessage.getInstance().log(
				"-> NewTypeDoubleContainerWizardPage.doStatusUpdate()");
		super.doStatusUpdate();
		if (isPageComplete()) {
			if ("".equals(this.fSecondContainedClassDialogField.getText())) {
				setErrorMessage(
					AstonWizardsPlugin.getResourceString(
						"lg.warning.objaskeymustbespecified"));
				setPageComplete(false);
				return;
			}
		}
	}

	/**
	 * Adds specfic values to the Map of keys.
	 * 
	 * @param type type of the object
	 * @param imports the imports of the file
	 * @param monitor the progress bar
	 * @param values the current Map that contains values for the template
	 */
	protected void setSpecificValues(
		IType type,
		ImportsManager imports,
		IProgressMonitor monitor,
		Map values) {
		LogMessage
				.getInstance()
				.log(
						"-> NewTypeDoubleContainerWizardPage.setSpecificValues(type, imports, monitor, values)");
		super.setSpecificValues(type, imports, monitor, values);

		String secondInType = Utils.getClassName(getSecondContainedClassName());

		values.put(MARK_CONTAINED_KEY, secondInType);
		values.put(MARK_CONTAINED_KEY_AS_NULL, Utils.getNull(secondInType));
		values.put(
			MARK_CONTAINED_KEY_CLASS_NAME,
			Utils.getObject(secondInType));
	}

	/**
	 * Creates the controls for the superclass name field. Expects a <code>GridLayout</code> 
	 * with at least 3 columns. 
	 * 
	 * @param composite the parent composite
	 * @param nColumns number of columns to span
	 */
	protected void createContainedSecondClassControls(
		Composite composite,
		int nColumns) {
		LogMessage
				.getInstance()
				.log(
						"-> NewTypeDoubleContainerWizardPage.createContainedSecondClassControls(composite, nColumns)");
		if (this.fSecondContainedClassDialogField != null) {
			this.fSecondContainedClassDialogField.doFillIntoGrid(
				composite,
				nColumns);
			LayoutUtil.setWidthHint(
					this.fSecondContainedClassDialogField.getTextControl(null),
				getMaxFieldWidth());
		}
	}

	/**
	 * Creates the window that will represent the wizard page. 
	 * 
	 * @param parent the parent of this page
	 */
	public void createControl(Composite parent) {
		LogMessage.getInstance().log(
				"-> NewTypeDoubleContainerWizardPage.createControl(parent)");
		initializeDialogUnits(parent);

		Composite composite = new Composite(parent, SWT.NONE);

		int nColumns = 4;

		GridLayout layout = new GridLayout();
		layout.numColumns = nColumns;
		composite.setLayout(layout);

		// pick & choose the wanted UI components

		createContainerControls(composite, nColumns);
		createPackageControls(composite, nColumns);
		createEnclosingTypeControls(composite, nColumns);

		createSeparator(composite, nColumns);

		createTypeNameControls(composite, nColumns);
		createModifierControls(composite, nColumns);

		createSuperClassControls(composite, nColumns);

		createContainedClassControls(composite, nColumns);
		createContainedSecondClassControls(composite, nColumns);

		createSuperInterfacesControls(composite, nColumns);

		createControlForTemplate(composite, nColumns);

		createMethodStubSelectionControls(composite, nColumns);

		setControl(composite);
	}

	/**
	 * Generates the java file. 
	 * 
	 * @param type type of the object
	 * @param imports the imports of the file
	 * @param monitor the progress bar
	 * @param values a Map that contains every information needed for the creation of the class
	 * 
	 * @exception CoreException if an error occurred
	 */
	protected void createInternal(
		IType type,
		ImportsManager imports,
		IProgressMonitor monitor,
		Map values)
		throws CoreException {
		LogMessage
				.getInstance()
				.log(
						"-> NewTypeDoubleContainerWizardPage.createInternal(type, imports, monitor, values)");
		StringBuffer fileSb = null;

		try {
			fileSb = AstonWizardsPlugin.getDefault().openContentStream(values);
		} catch (IOException e) {
			Utils.showError(e, getShell());
			return;
		}

		createInheritedMethods(
			type,
			false,
			isCreateInherited(),
			imports,
			monitor);

		if (this.getContainedClassName().indexOf(".") != -1) {
			imports.addImport(this.getContainedClassName());
		}

		transformBasicToObject(
			fileSb,
			(String) values.get(MARK_CONTAINED_TYPE),
			MARK_CONTAINED_TYPE_AS_OBJECT);
		transformObjectToBasic(
			fileSb,
			(String) values.get(MARK_CONTAINED_TYPE),
			MARK_CONTAINED_TYPE_AS_VALUE);

		transformBasicToObject(
			fileSb,
			(String) values.get(MARK_CONTAINED_KEY),
			MARK_CONTAINED_KEY_AS_OBJECT);
		transformObjectToBasic(
			fileSb,
			(String) values.get(MARK_CONTAINED_KEY),
			MARK_CONTAINED_KEY_AS_VALUE);

		String file = fileSb.toString();
		createImports(file, type, imports, monitor);
		createFields(file, type, imports, monitor);
		if (isCreateConstructors()) {
			createConstructor(file, type, imports, monitor);
		}
		createMethods(file, type, imports, monitor);
		createInerType(file, type, imports, monitor);

		updateSectionValues();

		if (monitor != null) {
			monitor.done();
		}
	}

	/**
	 * Returns the second type that will be contained in the class
	 * 
	 * @return the element name, or null if the page is not yet created
	 */
	public String getSecondContainedClassName() {
		LogMessage
				.getInstance()
				.log(
						"-> NewTypeDoubleContainerWizardPage.getSecondContainedClassName()");
		if (this.fSecondContainedClassDialogField != null) {
			return this.fSecondContainedClassDialogField.getText();
		}
		return null;
	}
}