package com.aston;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyDelegatingOperation;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;
/**
 * This is a New creation Wizard.
 * 
 * This class is an Ugly cut/paste of the NewElementWizard. I made it because
 * on some computers for some reasons (completly unknown) reflection does not
 * work properly. Using <i>my own </i> NewElementWizard class it corrects the
 * bug.
 * 
 * Part of the <a href="http://renaud91.free.fr/Plugins>Aston Wizard </a> <br>
 * 
 * @author <ul>
 *         <li><a href="mailto:renaud91@free.fr">Ferret Renaud </a>
 *         </li>
 *         </ul>
 * 
 * @version 3.0
 * @since Eclipse 3.0
 */ 
public abstract class NewCreationWizard extends BasicNewResourceWizard
		implements
			Marks {
	private ISelection selection;
	/**
	 * Constructor of the object.
	 */
	public NewCreationWizard() {
		super();
		LogMessage.getInstance()
				.log("-> NewCreationWizard.NewCreationWizard()");
		setNeedsProgressMonitor(true);
	}
	
	protected final void openResource(final IResource file) {
		LogMessage.getInstance().log("-> NewCreationWizard.openResource(file)");
		if (file.getType() == IResource.FILE) {
			getShell().getDisplay().asyncExec(new Runnable() {
				public void run() {
					IWorkbenchPage page = PlatformUI.getWorkbench()
							.getActiveWorkbenchWindow().getActivePage();
					try {
						IDE.openEditor(page, (IFile)file, true);
						// For Eclipse 2.x : page.openEditor((IFile)file);
					} catch (PartInitException e) {
						JavaPlugin.log(e);
					}
				}
			});
		}
	}
	
	public synchronized final boolean finishPage(IRunnableWithProgress runnable) {
		LogMessage.getInstance().log(
				"-> NewCreationWizard.finishPage(runnable)");
		IRunnableWithProgress op = new WorkspaceModifyDelegatingOperation(
				runnable);
		try {
			getContainer().run(false, true, op);
		} catch (InvocationTargetException e) {
			Shell shell = getShell();
			String title = NewWizardMessages
					.getString("NewElementWizard.op_error.title"); //$NON-NLS-1$
			String message = NewWizardMessages
					.getString("NewElementWizard.op_error.message"); //$NON-NLS-1$
			ExceptionHandler.handle(e, shell, title, message);
			return false;
		} catch (InterruptedException e) {
			return false;
		}
		return true;
	}
}
