package com.aston;
import java.util.logging.Logger;

/**
 * Will centrelize log.
 * 
 * @author 
 * <ul>
 * 	<li><a href="renaud91@free.fr">Ferret Renaud</a></li>
 * </ul>
 * @version V1.0
 */
public final class LogMessage extends Object {
	private static LogMessage instance;
	private Logger logger;
	
	/**
	 * Say false in prod, true in dev
	 */ 
	private boolean doLog = false;
	
	/**
	 * Constructor of the object.
	 *
	 * Should remain private.
	 */
	private LogMessage() {
		super();
		// Use JDK1.4 log API
		// TODO May be not a good IDEA since this is 1.4 only
		this.logger = Logger.getAnonymousLogger();
	}
	
	/**
	 * Gest default instance of the object.
	 * 
	 * @return default instance of the object
	 */
	public static synchronized final LogMessage getInstance() {
		if (LogMessage.instance == null) {
			LogMessage.instance = new LogMessage();
		}
		return LogMessage.instance;
	}
	
	/**
	 * Log a msg if log is on
	 * 
	 * @param msg the message to log
	 */
	public void log(String msg) {
		if (isDoLog()) {
			this.logger.info(msg);
		}
	}
	
	/**
	 * Indicates if log is on or not
	 * 
	 * @return Returns the doLog value.
	 */
	public boolean isDoLog() {
		return this.doLog;
	}
	
	/**
	 * Sets the doLog value.
	 * 
	 * @param doLog if true log will be made.
	 */
	public void setDoLog(boolean doLog) {
		this.doLog = doLog;
	}
}
