#---------------------------------------------#
# <aw:description>Template for a Factory</aw:description>
# <aw:version>1.2</aw:version>
# <aw:date>06/10/2003</aw:date>
# <aw:author>Ferret Renaud</aw:author>
#---------------------------------------------#

<aw:import>java.lang.reflect.Constructor</aw:import>
<aw:import>java.lang.reflect.InvocationTargetException</aw:import>
<aw:import>java.util.HashMap</aw:import>
<aw:import>java.util.Iterator</aw:import>
<aw:import>java.util.Map</aw:import>

<aw:field>
	/** This is the default instance used for this singleton. */
	private static <aw:className/> defaultInstance;

</aw:field>

<aw:field>
	/** This is the list of object. */
	protected Map objectMap;

</aw:field>


<aw:constructor name="c1">
	/**
	 * Constructor of the object. <br>
	 *
	 * This constructor should remain private
	 */
	private <aw:className/>() {
		super();
		this.objectMap = new HashMap();
		// Put your code here
	}

</aw:constructor>

<aw:method name="getInstance">
	/**
	 * Gets the unique instance of this class. <br>
	 *
	 * @return the unique instance of this class
	 */
	public final synchronized static <aw:className/> getInstance() {
		if (<aw:className/>.defaultInstance == null) {
			<aw:className/>.defaultInstance = new <aw:className/>();
		}
		return <aw:className/>.defaultInstance;
	}

</aw:method>

<aw:method name="toString">
	/**
	 * Gives a string representation of this object. <br>
	 * 
	 * @return a String representation of this object
	 */
	public String toString() {
		StringBuffer sb = new StringBuffer(128);
		sb.append('{');
		Iterator it = this.objectMap.values().iterator();
		while (it.hasNext()) {
			sb.append(it.next());
			sb.append(", ");
		}
		it = null;
		if (this.objectMap.size() > 0) {
			int length = sb.length();
			sb.delete(length - 2, length);
		}
		sb.append('}');
		return sb.toString();
	}

</aw:method>

<aw:method name="get1">
	/**
	 * Gives an element in the factory. <br>
	 * 
	 * @param aKey key of the object to find
	 * @return the object available at the given key, null if absent
	 */
	public synchronized <aw:containedTypeEntered/> get(Object aKey) {
		return this.get(aKey, false);
	}

</aw:method>

<aw:method name="get2">
	/**
	 * Gives an element in the factory. <br>
	 * 
	 * @param aKey key of the object to find
	 * @param createIfAbstent if true and object is not present then the 
	 * create(aKey) method will be used. Warning : this will cause an error if no 
	 * plublic empty constructor is available in class <aw:containedTypeEntered/>
	 * @return the object available at the given key
	 */
	public synchronized <aw:containedTypeEntered/> get(Object aKey, boolean createIfAbstent) {
		<aw:containedTypeEntered/> resu = (<aw:containedTypeEntered/>) this.objectMap.get(aKey);
		if (resu == null && createIfAbstent) {
			resu = this.create(aKey);
		}
		return resu;
	}

</aw:method>

<aw:method name="clear">
	/**
	 * Clears the factory.
	 * 
	 * Removes all elements.
	 */
	public synchronized void clear() {
		this.objectMap.clear();
	}

</aw:method>

<aw:method name="isEmpty">
	/**
	 * Indicates if the factory is empty.
	 * 
	 * @return true if the factory is empty, false if not
	 */
	public synchronized boolean isEmpty() {
		return this.objectMap.size() == 0;
	}

</aw:method>

<aw:method name="delete">
	/**
	 * Deletes the factory.
	 * 
	 * Use this method for memory leak, the factory will not be useable anymore
	 */
	public synchronized void delete() {
		this.clear();
		this.objectMap = null;
	}

</aw:method>

<aw:method name="size">
	/**
	 * Returns the number of element in the factory.
	 * 
	 * @return the number of element in the factory
	 */
	public synchronized int size() {
		return this.objectMap.size();
	}

</aw:method>

<aw:method name="containsValue">
	/**
	 * Tests if an element is present or not. <br>
	 * 
	 * @param anElm the object to find
	 * @return true if the element is present, false if not present
	 */
	public synchronized boolean containsValue(<aw:containedTypeEntered/> anElm) {
		return this.objectMap.containsValue(anElm);
	}

</aw:method>

<aw:method name="create1">
	/**
	 * Creates an element and manage it. <br>
	 *
	 * The element is put in the map, and returned. <br>
	 *
	 * Caution : if a contructor needs a basic type (like int, double,
	 * char, ...), you will be forced to pass it by creating a wrapper 
	 * (Integer, Double, Character ...). Doing so, you will also have to 
	 * precise in the boolean array (<i>isBasicType</i>) that this argument is a 
	 * basic type and not an Object.
	 *
	 * @param aKey the key that will identify the object created
	 * @param params an array of parameters to use with the constructor of the 
	 * object
	 * @param isBasicType an array of boolean that indicates if the params[i] is 
	 * a basic type or not
	 */
	public synchronized <aw:containedTypeEntered/> create(Object aKey, Object[] params,	boolean[] isBasicType) {
		Class[] paramsType = null;
		if (params != null) {
			paramsType = new Class[params.length];
			for (int i = 0; i < params.length; i++) {
				if (isBasicType[i]) {
					if (params[i] instanceof Integer) {
						paramsType[i] = Integer.TYPE;
					} else if (params[i] instanceof Double) {
						paramsType[i] = Double.TYPE;
					} else if (params[i] instanceof Float) {
						paramsType[i] = Float.TYPE;
					} else if (params[i] instanceof Long) {
						paramsType[i] = Long.TYPE;
					} else if (params[i] instanceof Byte) {
						paramsType[i] = Byte.TYPE;
					} else if (params[i] instanceof Short) {
						paramsType[i] = Short.TYPE;
					} else if (params[i] instanceof Character) {
						paramsType[i] = Character.TYPE;
					}
				} else {
					paramsType[i] = params[i].getClass();
				}
			}
		}
		try {
			Constructor ct = <aw:containedTypeEntered/>.class.getConstructor(paramsType);
			<aw:containedTypeEntered/> resu = (<aw:containedTypeEntered/>) ct.newInstance(params);
			this.objectMap.put(aKey, resu);
			return resu;
		} catch (NoSuchMethodException nse) {
			nse.printStackTrace();
		} catch (InvocationTargetException ite) {
			ite.printStackTrace();
		} catch (IllegalAccessException iae) {
			iae.printStackTrace();
		} catch (InstantiationException ie) {
			ie.printStackTrace();
		}
		return null;
	}

</aw:method>

<aw:method name="create2">
	/**
	 * Creates an element and manage it. <br>
	 *
	 * The element is put in the map, and returned. <br>
	 * By default, all parameters will be concidered as Object, and not basic 
	 * type. <br>
	 *
	 * @param aKey the key that will identify the object created
	 * @param params an array of parameters to use with the constructor of the 
	 * object
	 */
	public synchronized <aw:containedTypeEntered/> create(Object aKey, Object[] params) {
		boolean[] isBasicType = new boolean[params.length];
		return this.create(aKey, params, isBasicType);
	}

</aw:method>

<aw:method name="create3">
	/**
	 * Creates an element and manage it. <br>
	 *
	 * The element is put in the map, and returned. <br>
	 * By default, this method will try to use the constructor of the object that 
	 * has no parameter. <br>
	 *
	 * @param aKey the key that will identify the object created
	 */
	public synchronized <aw:containedTypeEntered/> create(Object aKey) {
		return this.create(aKey, new Object[0], new boolean[0]);
	}

</aw:method>

<aw:method name="remove">
	/**
	 * Removes the element with the specified key in this factory.
	 *
	 * @param aKey the key of the object to remove.
	 */
	public synchronized void remove(Object aKey) {
		this.objectMap.remove(aKey);
	}

</aw:method>

<aw:method name="put">
  /**
   * Sets the element in the factory at the given index. <br>
   * 
   * Warning: No copy or clone of the element is made.
   * 
   * @param aKey the object's key
   * @param anElm the object to add
   */
  public synchronized void put(Object aKey, <aw:containedTypeEntered/> anElm) {
    this.objectMap.put(aKey, anElm);
  }

</aw:method>