#---------------------------------------------#
# <aw:description>Template for a Map with Object</aw:description>
# <aw:version>1.1</aw:version>
# <aw:date>03/18/2003</aw:date>
# <aw:author>Ferret Renaud</aw:author>
#---------------------------------------------#

<aw:import>java.util.Collection</aw:import>
<aw:import>java.util.Map</aw:import>
<aw:import>java.util.Set</aw:import>
<aw:import><aw:mapType/></aw:import>

<aw:field>
	/** This is the Map of object. */
	protected Map itsMap;

</aw:field>

<aw:constructor name="c1">
	/**
	 * Constructor of the object. <br>
	 */
	public <aw:className/>() {
		this(null);
	}

</aw:constructor>

<aw:constructor name="c3">
	/**
	 * Constructor ofthe object.
	 * 
	 * The map of this objet will not directly use the map given in 
	 * parameter, it will call the constructor <i>Map(aMap)</i>. <br>
	 * 
	 * @param aMap the map that will be set in the new object
	 */
	public <aw:className/>(Map aMap) {
		super();
		if (aMap != null) {
			this.itsMap = new <aw:mapType/>(aMap);
		} else {
			this.itsMap = new <aw:mapType/>();
		}
	}

</aw:constructor>

<aw:method name="size">
	/**
	 * Returns the number of key-value mappings in this map.  If the
	 * map contains more than <tt><aw:containedKeyEntered/>.MAX_VALUE</tt> elements, returns
	 * <tt><aw:containedKeyEntered/>.MAX_VALUE</tt>.
	 *
	 * @return the number of key-value mappings in this map.
	 */
	public int size() {
		return this.itsMap.size();
	}

</aw:method>

<aw:method name="isEmpty">
	/**
	 * Returns <tt>true</tt> if this map contains no key-value mappings
	 *
	 * @return <tt>true</tt> if this map contains no key-value mappings.
	 */
	public boolean isEmpty() {
		return this.itsMap.isEmpty();
	}

</aw:method>
<aw:method name="containsKey">
	/**
	 * Returns <tt>true</tt> if this map contains a mapping for the specified
	 * key.
	 *
	 * @param aKey key whose presence in this map is to be tested.
	 * @return <tt>true</tt> if this map contains a mapping for the specified key.
	 * 
	 * @throws ClassCastException if the key is of an inappropriate type for this map.
	 * @throws NullPointerException if the key is <tt>null</tt> and this map does not not permit <tt>null</tt> keys.
	 */
	public boolean containsKey(<aw:containedKeyEntered/> aKey) {
		return this.itsMap.containsKey(aKey);
	}

</aw:method>
<aw:method name="containsValue">
	/**
	 * Returns <tt>true</tt> if this map maps one or more keys to the
	 * specified value.  More formally, returns <tt>true</tt> if and only if
	 * this map contains at least one mapping to a value <tt>v</tt> such that
	 * <tt>(value==null ? v==null : value.equals(v))</tt>.  This operation
	 * will probably require time linear in the map size for most
	 * implementations of the <tt>Map</tt> interface.
	 *
	 * @param aValue value whose presence in this map is to be tested.
	 * @return <tt>true</tt> if this map maps one or more keys to the specified value.
	 */
	public boolean containsValue(<aw:containedTypeEntered/> aValue) {
		return this.itsMap.containsValue(aValue);
	}

</aw:method>
<aw:method name="get">
	/**
	 * Returns the value to which this map maps the specified key.  Returns
	 * <tt>null</tt> if the map contains no mapping for this key.  A return
	 * value of <tt>null</tt> does not <i>necessarily</i> indicate that the
	 * map contains no mapping for the key; it's also possible that the map
	 * explicitly maps the key to <tt>null</tt>.  The <tt>containsKey</tt>
	 * operation may be used to distinguish these two cases.
	 *
	 * @param aKey key whose associated value is to be returned.
	 * @return the value to which this map maps the specified key, or <tt>null</tt> if the map contains no mapping for this key.
	 * If there are basic types in the map, then the result will be <i>Type</i>.MAX_VALUE or <i>Type</i>.NaN or false.
	 * 
	 * @throws ClassCastException if the key is of an inappropriate type for this map.
	 * @throws NullPointerException key is <tt>null</tt> and this map does not not permit <tt>null</tt> keys.
	 */
	public <aw:containedTypeEntered/> get(<aw:containedKeyEntered/> aKey) {
		return (<aw:containedTypeEntered/>) this.itsMap.get(aKey);
	}

</aw:method>
<aw:method name="put">
	/**
	 * Associates the specified value with the specified key in this map
	 * (optional operation).  If the map previously contained a mapping for
	 * this key, the old value is replaced.
	 *
	 * @param aKey key with which the specified value is to be associated.
	 * @param aValue value to be associated with the specified key.
	 * @return previous value associated with specified key, or <tt>null</tt>
	 *	       if there was no mapping for key.  A <tt>null</tt> return can
	 *	       also indicate that the map previously associated <tt>null</tt>
	 *	       with the specified key, if the implementation supports
	 *	       <tt>null</tt> values.
	 * If there are basic types in the map, then the result will be <i>Type</i>.MAX_VALUE or <i>Type</i>.NaN or false.
	 * 
	 * @throws UnsupportedOperationException if the <tt>put</tt> operation is not supported by this map.
	 * @throws ClassCastException if the class of the specified key or value prevents it from being stored in this map.
	 * @throws IllegalArgumentException if some aspect of this key or value prevents it from being stored in this map.
	 * @throws NullPointerException this map does not permit <tt>null</tt> keys or values, and the specified key or value is <tt>null</tt>.
	 */
	public <aw:containedTypeEntered/> put(<aw:containedKeyEntered/> aKey, <aw:containedTypeEntered/> aValue) {
		return (<aw:containedTypeEntered/>) this.itsMap.put(aKey, aValue);
	}

</aw:method>
<aw:method name="remove">
	/**
	 * Removes the mapping for this key from this map if present
	 *
	 * @param aKey key whose mapping is to be removed from the map.
	 * @return previous value associated with specified key, or <tt>null</tt>
	 *	       if there was no mapping for key.  A <tt>null</tt> return can
	 *	       also indicate that the map previously associated <tt>null</tt>
	 *	       with the specified key, if the implementation supports
	 *	       <tt>null</tt> values.
	 * If there are basic types in the map, then the result will be <i>Type</i>.MAX_VALUE or <i>Type</i>.NaN or false.
	 * @throws UnsupportedOperationException if the <tt>remove</tt> method is not supported by this map.
	 */
	public <aw:containedTypeEntered/> remove(<aw:containedKeyEntered/> aKey) {
		return (<aw:containedTypeEntered/>) this.itsMap.remove(aKey);
	}

</aw:method>
<aw:method name="putAll">
	/**
	 * Copies all of the mappings from the specified map to this map
	 * (optional operation).  These mappings will replace any mappings that
	 * this map had for any of the keys currently in the specified map.
	 *
	 * @param aMap Mappings to be stored in this map.
	 * 
	 * @throws UnsupportedOperationException if the <tt>putAll</tt> method is not supported by this map.
	 * @throws ClassCastException if the class of a key or value in the specified map prevents it from being stored in this map.
	 * @throws IllegalArgumentException some aspect of a key or value in the specified map prevents it from being stored in this map.
	 * @throws NullPointerException this map does not permit <tt>null</tt> keys or values, and the specified key or value is <tt>null</tt>.
	 */
	public void putAll(Map aMap) {
		this.itsMap.putAll(aMap);
	}

</aw:method>
<aw:method name="clear">
	/**
	 * Removes all mappings from this map
	 *
	 * @throws UnsupportedOperationException clear is not supported by this map.
	 */
	public void clear() {
		this.itsMap.clear();
	}

</aw:method>
<aw:method name="delete">
	/**
	 * Deletes the object
	 *
	 * The object will become unuseable.
	 */
	public void delete() {
		this.itsMap.clear();
		this.itsMap = null;
	}

</aw:method>
<aw:method name="keySet">
	/**
	 * Returns a set view of the keys contained in this map.  The set is
	 * backed by the map, so changes to the map are reflected in the set, and
	 * vice-versa.  If the map is modified while an iteration over the set is
	 * in progress, the results of the iteration are undefined.  The set
	 * supports element removal, which removes the corresponding mapping from
	 * the map, via the <tt>Iterator.remove</tt>, <tt>Set.remove</tt>,
	 * <tt>removeAll</tt> <tt>retainAll</tt>, and <tt>clear</tt> operations.
	 * It does not support the add or <tt>addAll</tt> operations.
	 *
	 * @return a set view of the keys contained in this map. This set is not typed
	 */
	public Set keySet() {
		return this.itsMap.keySet();
	}

</aw:method>
<aw:method name="values">
	/**
	 * Returns a collection view of the values contained in this map.  The
	 * collection is backed by the map, so changes to the map are reflected in
	 * the collection, and vice-versa.  If the map is modified while an
	 * iteration over the collection is in progress, the results of the
	 * iteration are undefined.  The collection supports element removal,
	 * which removes the corresponding mapping from the map, via the
	 * <tt>Iterator.remove</tt>, <tt>Collection.remove</tt>,
	 * <tt>removeAll</tt>, <tt>retainAll</tt> and <tt>clear</tt> operations.
	 * It does not support the add or <tt>addAll</tt> operations.
	 *
	 * @return a collection view of the values contained in this map. This Collection is not typed
	 */
	public Collection values() {
		return this.itsMap.values();
	}

</aw:method>
<aw:method name="entrySet">
	/**
	 * Returns a set view of the mappings contained in this map.  Each element
	 * in the returned set is a <tt>Map.Entry</tt>.  The set is backed by the
	 * map, so changes to the map are reflected in the set, and vice-versa.
	 * If the map is modified while an iteration over the set is in progress,
	 * the results of the iteration are undefined.  The set supports element
	 * removal, which removes the corresponding mapping from the map, via the
	 * <tt>Iterator.remove</tt>, <tt>Set.remove</tt>, <tt>removeAll</tt>,
	 * <tt>retainAll</tt> and <tt>clear</tt> operations.  It does not support
	 * the <tt>add</tt> or <tt>addAll</tt> operations.
	 *
	 * @return a set view of the mappings contained in this map. This set is not typed
	 */
	public Set entrySet() {
		return this.itsMap.entrySet();
	}

</aw:method>
<aw:method name="equals">
	/**
	 * Compares the specified object with this map for equality.  Returns
	 * <tt>true</tt> if the given object is also a map and the two Maps
	 * represent the same mappings.  More formally, two maps <tt>t1</tt> and
	 * <tt>t2</tt> represent the same mappings if
	 * <tt>t1.entrySet().equals(t2.entrySet())</tt>.  This ensures that the
	 * <tt>equals</tt> method works properly across different implementations
	 * of the <tt>Map</tt> interface.
	 *
	 * @param anObject object to be compared for equality with this map.
	 * @return <tt>true</tt> if the specified object is equal to this map.
	 */
	public boolean equals(Object anObject) {
		if (anObject == null) {
			return false;
    }
		if (anObject == this) {
			return true;
    }
    // Here we can use == since class object are invariant
    // This method is better than using instanceof since it avoids 
    // inheritance effect
		if (anObject.getClass() == <aw:className/>.class) {
			return this.itsMap.equals(anObject);
		}
		return false;
	}

</aw:method>
<aw:method name="toString">
	/**
	 * Returns a string representation of the object. In general, the 
	 * <code>toString</code> method returns a string that 
	 * "textually represents" this object. 
	 * 
	 * @return  a string representation of the object.
	 */
	public String toString() {
		return this.itsMap.toString();
	}

</aw:method>
<aw:method name="main">
	/**
	 * The main method. 
	 * 
	 * @param args arguments
	 */
	public static void main(String[] args) {
		<aw:className/> tp = new <aw:className/>();
		// put elemnts in your map here
		System.out.println(tp);
	}

</aw:method>