/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.util;

import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.xml.sax.AttributeList;
import org.xml.sax.Attributes;

public class XMLAttributesImpl
implements XMLAttributes,
AttributeList,
Attributes {
    protected boolean fNamespaces = true;
    protected int fLength;
    protected Attribute[] fAttributes = new Attribute[4];

    public XMLAttributesImpl() {
        int i = 0;
        while (i < this.fAttributes.length) {
            this.fAttributes[i] = new Attribute();
            ++i;
        }
    }

    public void setNamespaces(boolean namespaces) {
        this.fNamespaces = namespaces;
    }

    public int addAttribute(QName name, String type, String value) {
        int index;
        int n = index = name.uri != null && !name.uri.equals("") ? this.getIndex(name.uri, name.localpart) : this.getIndex(name.rawname);
        if (index == -1) {
            index = this.fLength;
            if (this.fLength++ == this.fAttributes.length) {
                Attribute[] attributes = new Attribute[this.fAttributes.length + 4];
                System.arraycopy(this.fAttributes, 0, attributes, 0, this.fAttributes.length);
                int i = this.fAttributes.length;
                while (i < attributes.length) {
                    attributes[i] = new Attribute();
                    ++i;
                }
                this.fAttributes = attributes;
            }
        }
        Attribute attribute = this.fAttributes[index];
        attribute.name.setValues(name);
        attribute.type = type;
        attribute.value = value;
        attribute.nonNormalizedValue = value;
        attribute.specified = false;
        return index;
    }

    public void removeAllAttributes() {
        this.fLength = 0;
    }

    public void removeAttributeAt(int attrIndex) {
        if (attrIndex < this.fLength - 1) {
            Attribute removedAttr = this.fAttributes[attrIndex];
            System.arraycopy(this.fAttributes, attrIndex + 1, this.fAttributes, attrIndex, this.fLength - attrIndex - 1);
            this.fAttributes[this.fLength - 1] = removedAttr;
        }
        --this.fLength;
    }

    public void setName(int attrIndex, QName attrName) {
        this.fAttributes[attrIndex].name.setValues(attrName);
    }

    public void getName(int attrIndex, QName attrName) {
        attrName.setValues(this.fAttributes[attrIndex].name);
    }

    public void setType(int attrIndex, String attrType) {
        this.fAttributes[attrIndex].type = attrType;
    }

    public void setValue(int attrIndex, String attrValue) {
        Attribute attribute = this.fAttributes[attrIndex];
        attribute.value = attrValue;
        attribute.nonNormalizedValue = attrValue;
    }

    public void setNonNormalizedValue(int attrIndex, String attrValue) {
        if (attrValue == null) {
            attrValue = this.fAttributes[attrIndex].value;
        }
        this.fAttributes[attrIndex].nonNormalizedValue = attrValue;
    }

    public String getNonNormalizedValue(int attrIndex) {
        String value = this.fAttributes[attrIndex].nonNormalizedValue;
        return value;
    }

    public void setSpecified(int attrIndex, boolean specified) {
        this.fAttributes[attrIndex].specified = specified;
    }

    public boolean isSpecified(int attrIndex) {
        return this.fAttributes[attrIndex].specified;
    }

    public int getLength() {
        return this.fLength;
    }

    public String getType(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fAttributes[index].type;
    }

    public String getType(String qname) {
        int index = this.getIndex(qname);
        return index != -1 ? this.fAttributes[index].type : null;
    }

    public String getValue(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fAttributes[index].value;
    }

    public String getValue(String qname) {
        int index = this.getIndex(qname);
        return index != -1 ? this.fAttributes[index].value : null;
    }

    public String getName(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fAttributes[index].name.rawname;
    }

    public int getIndex(String qName) {
        int i = 0;
        while (i < this.fLength) {
            Attribute attribute = this.fAttributes[i];
            if (attribute.name.rawname != null && attribute.name.rawname.equals(qName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public int getIndex(String uri, String localPart) {
        int i = 0;
        while (i < this.fLength) {
            Attribute attribute = this.fAttributes[i];
            if (attribute.name.localpart != null && attribute.name.localpart.equals(localPart) && (uri == attribute.name.uri || uri != null && attribute.name.uri != null && attribute.name.uri.equals(uri))) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public String getLocalName(int index) {
        if (!this.fNamespaces) {
            return "";
        }
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        return this.fAttributes[index].name.localpart;
    }

    public String getQName(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        String rawname = this.fAttributes[index].name.rawname;
        return rawname != null ? rawname : "";
    }

    public String getType(String uri, String localName) {
        if (!this.fNamespaces) {
            return null;
        }
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.getType(index) : null;
    }

    public String getPrefix(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        String prefix = this.fAttributes[index].name.prefix;
        return prefix != null ? prefix : "";
    }

    public String getURI(int index) {
        if (index < 0 || index >= this.fLength) {
            return null;
        }
        String uri = this.fAttributes[index].name.uri;
        return uri;
    }

    public String getValue(String uri, String localName) {
        int index = this.getIndex(uri, localName);
        return index != -1 ? this.getValue(index) : null;
    }

    static class Attribute {
        public QName name = new QName();
        public String type;
        public String value;
        public String nonNormalizedValue;
        public boolean specified;

        Attribute() {
        }
    }
}

