/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.SAXParserFactory;
import org.apache.xerces.jaxp.DefaultValidationErrorHandler;
import org.apache.xerces.parsers.SAXParser;
import org.xml.sax.HandlerBase;
import org.xml.sax.Parser;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderAdapter;

public class SAXParserImpl
extends javax.xml.parsers.SAXParser {
    private XMLReader xmlReader = new SAXParser();
    private Parser parser = null;
    private boolean validating = false;
    private boolean namespaceAware = false;
    private String schemaLanguage = "DTD";

    SAXParserImpl(SAXParserFactory spf, Hashtable features) throws SAXException {
        this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", false);
        this.validating = spf.isValidating();
        if (this.validating) {
            this.xmlReader.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.xmlReader.setFeature("http://xml.org/sax/features/validation", this.validating);
        this.namespaceAware = spf.isNamespaceAware();
        String namespaces = "http://xml.org/sax/features/namespaces";
        this.xmlReader.setFeature(namespaces, this.namespaceAware);
        if (!this.namespaceAware) {
            String prefixes = "http://xml.org/sax/features/namespace-prefixes";
            this.xmlReader.setFeature(prefixes, true);
        }
        this.setFeatures(features);
    }

    private void setFeatures(Hashtable features) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (features != null) {
            Enumeration e = features.keys();
            while (e.hasMoreElements()) {
                String feature = (String)e.nextElement();
                boolean value = (Boolean)features.get(feature);
                this.xmlReader.setFeature(feature, value);
            }
        }
    }

    public Parser getParser() throws SAXException {
        if (this.parser == null) {
            this.parser = new XMLReaderAdapter(this.xmlReader);
            this.parser.setDocumentHandler(new HandlerBase());
        }
        return this.parser;
    }

    public XMLReader getXMLReader() {
        return this.xmlReader;
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setProperty(String name, Object value) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(name)) {
            if ("http://www.w3.org/2001/XMLSchema".equals(value)) {
                this.schemaLanguage = "http://www.w3.org/2001/XMLSchema";
                this.xmlReader.setFeature("http://xml.org/sax/features/validation", false);
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", this.validating);
                return;
            } else {
                if (!"DTD".equals(value)) throw new SAXNotSupportedException("Unsupported schema language");
                this.schemaLanguage = "DTD";
                this.xmlReader.setFeature("http://xml.org/sax/features/validation", this.validating);
                this.xmlReader.setFeature("http://apache.org/xml/features/validation/schema", false);
            }
            return;
        } else {
            this.xmlReader.setProperty(name, value);
        }
    }

    public Object getProperty(String name) throws SAXNotRecognizedException, SAXNotSupportedException {
        if ("http://java.sun.com/xml/jaxp/properties/schemaLanguage".equals(name)) {
            return this.schemaLanguage;
        }
        return this.xmlReader.getProperty(name);
    }
}

