/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.jaxp;

import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xerces.dom.DOMImplementationImpl;
import org.apache.xerces.dom.DocumentImpl;
import org.apache.xerces.jaxp.DefaultValidationErrorHandler;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.helpers.DefaultHandler;

public class DocumentBuilderImpl
extends DocumentBuilder {
    static final String JAXP_SCHEMA_LANGUAGE = "http://java.sun.com/xml/jaxp/properties/schemaLanguage";
    static final String W3C_XML_SCHEMA = "http://www.w3.org/2001/XMLSchema";
    private EntityResolver er = null;
    private ErrorHandler eh = null;
    private DOMParser domParser = new DOMParser();
    private boolean namespaceAware = false;
    private boolean validating = false;

    DocumentBuilderImpl(DocumentBuilderFactory dbf, Hashtable dbfAttrs) throws SAXNotRecognizedException, SAXNotSupportedException {
        this.validating = dbf.isValidating();
        if (this.validating) {
            this.setErrorHandler(new DefaultValidationErrorHandler());
        }
        this.namespaceAware = dbf.isNamespaceAware();
        this.domParser.setFeature("http://xml.org/sax/features/namespaces", this.namespaceAware);
        try {
            this.domParser.setFeature("http://apache.org/xml/features/dom/include-ignorable-whitespace", !dbf.isIgnoringElementContentWhitespace());
            this.domParser.setFeature("http://apache.org/xml/features/dom/create-entity-ref-nodes", !dbf.isExpandEntityReferences());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setDocumentBuilderFactoryAttributes(dbfAttrs);
    }

    private void setDocumentBuilderFactoryAttributes(Hashtable dbfAttrs) throws SAXNotSupportedException, SAXNotRecognizedException {
        if (dbfAttrs == null) {
            return;
        }
        Enumeration e = dbfAttrs.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            Object val = dbfAttrs.get(name);
            if (val instanceof Boolean) {
                this.domParser.setFeature(name, (Boolean)val);
                continue;
            }
            if (JAXP_SCHEMA_LANGUAGE.equals(name)) {
                if ("DTD".equals(val)) {
                    this.domParser.setFeature("http://xml.org/sax/features/validation", this.validating);
                    this.domParser.setFeature("http://apache.org/xml/features/validation/schema", false);
                    continue;
                }
                if (W3C_XML_SCHEMA.equals(val)) {
                    this.domParser.setFeature("http://xml.org/sax/features/validation", false);
                    this.domParser.setFeature("http://apache.org/xml/features/validation/schema", this.validating);
                    continue;
                }
                this.domParser.setProperty(name, val);
                continue;
            }
            this.domParser.setProperty(name, val);
        }
    }

    public Document newDocument() {
        return new DocumentImpl();
    }

    public DOMImplementation getDOMImplementation() {
        return DOMImplementationImpl.getDOMImplementation();
    }

    public Document parse(InputSource is) throws SAXException, IOException {
        if (is == null) {
            throw new IllegalArgumentException("InputSource cannot be null");
        }
        if (this.er != null) {
            this.domParser.setEntityResolver(this.er);
        }
        if (this.eh != null) {
            this.domParser.setErrorHandler(this.eh);
        }
        this.domParser.parse(is);
        return this.domParser.getDocument();
    }

    public boolean isNamespaceAware() {
        return this.namespaceAware;
    }

    public boolean isValidating() {
        return this.validating;
    }

    public void setEntityResolver(EntityResolver er) {
        this.er = er;
    }

    public void setErrorHandler(ErrorHandler eh) {
        this.eh = eh == null ? new DefaultHandler() : eh;
    }

    DOMParser getDOMParser() {
        return this.domParser;
    }
}

