/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.dv.xs.AbstractDatatypeValidator;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.ListDatatypeValidator;
import org.apache.xerces.impl.dv.xs.UnionDatatypeValidator;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDSimpleTypeTraverser
extends XSDAbstractTraverser {
    private String fListName = "";
    private int fSimpleTypeAnonCount = 0;
    private final QName fQName = new QName();

    XSDSimpleTypeTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    DatatypeValidator traverseGlobal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, true, schemaDoc);
        String nameAtt = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        DatatypeValidator type = this.traverseSimpleTypeDecl(elmNode, attrValues, schemaDoc, grammar, true);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    DatatypeValidator traverseLocal(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, false, schemaDoc);
        DatatypeValidator type = this.traverseSimpleTypeDecl(elmNode, attrValues, schemaDoc, grammar, false);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return type;
    }

    /*
     * Enabled aggressive block sorting
     */
    private DatatypeValidator traverseSimpleTypeDecl(Element simpleTypeDecl, Object[] attrValues, XSDocumentInfo schemaDoc, SchemaGrammar grammar, boolean isGlobal) {
        DatatypeValidator baseValidator;
        boolean restriction;
        boolean list;
        Vector<DatatypeValidator> dTValidators;
        int finalProperty;
        Hashtable fFacetData;
        String nameProperty;
        block47: {
            boolean union;
            Element content;
            block48: {
                QName baseTypeName;
                block46: {
                    String qualifiedName = nameProperty = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
                    fFacetData = null;
                    qualifiedName = nameProperty == null ? (schemaDoc.fTargetNamespace == null ? ",#s#" + this.fSimpleTypeAnonCount++ : schemaDoc.fTargetNamespace + ",#S#" + this.fSimpleTypeAnonCount++) : (schemaDoc.fTargetNamespace == null ? "," + nameProperty : schemaDoc.fTargetNamespace + "," + nameProperty);
                    XInt finalAttr = (XInt)attrValues[XSAttributeChecker.ATTIDX_FINAL];
                    finalProperty = finalAttr == null ? schemaDoc.fFinalDefault : finalAttr.intValue();
                    content = DOMUtil.getFirstChildElement(simpleTypeDecl);
                    if (content != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl(content, attrValues, false, schemaDoc);
                        content = DOMUtil.getNextSiblingElement(content);
                    }
                    if (content == null) {
                        this.reportSchemaError("dt-simpleType", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, nameProperty, "(annotation?, (restriction | list | union))"});
                        return null;
                    }
                    Object[] contentAttrs = this.fAttrChecker.checkAttributes(content, false, schemaDoc);
                    this.fAttrChecker.returnAttrArray(contentAttrs, schemaDoc);
                    String varietyProperty = DOMUtil.getLocalName(content);
                    baseTypeName = null;
                    Vector memberTypes = null;
                    dTValidators = null;
                    int size = 0;
                    list = false;
                    union = false;
                    restriction = false;
                    int numOfTypes = 0;
                    if (varietyProperty.equals(SchemaSymbols.ELT_LIST)) {
                        baseTypeName = (QName)contentAttrs[XSAttributeChecker.ATTIDX_ITEMTYPE];
                        list = true;
                        if (this.fListName.length() != 0) {
                            this.reportCosListOfAtomic(nameProperty);
                            return null;
                        }
                        this.fListName = qualifiedName;
                    } else if (varietyProperty.equals(SchemaSymbols.ELT_RESTRICTION)) {
                        baseTypeName = (QName)contentAttrs[XSAttributeChecker.ATTIDX_BASE];
                        restriction = true;
                    } else if (varietyProperty.equals(SchemaSymbols.ELT_UNION)) {
                        union = true;
                        memberTypes = (Vector)contentAttrs[XSAttributeChecker.ATTIDX_MEMBERTYPES];
                        size = memberTypes != null ? memberTypes.size() : 1;
                        dTValidators = new Vector<DatatypeValidator>(size, 2);
                    } else {
                        Object[] args = new Object[]{varietyProperty};
                        this.reportSchemaError("dt-unsupported-derivation", args);
                    }
                    if (DOMUtil.getNextSiblingElement(content) != null) {
                        this.reportSchemaError("dt-simpleType", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, nameProperty, "(annotation?, (restriction | list | union))"});
                    }
                    baseValidator = null;
                    if (baseTypeName == null && memberTypes == null) {
                        if ((content = DOMUtil.getFirstChildElement(content)) != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
                            this.traverseAnnotationDecl(content, attrValues, false, schemaDoc);
                            content = DOMUtil.getNextSiblingElement(content);
                        }
                        if (content == null) {
                            this.reportSchemaError("dt-simpleType", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, nameProperty, "(annotation?, (restriction | list | union))"});
                            return null;
                        }
                        if (!DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                            Object[] args = new Object[]{simpleTypeDecl.getAttribute(SchemaSymbols.ATT_NAME)};
                            this.reportSchemaError("dt-simpleType", new Object[]{SchemaSymbols.ELT_SIMPLETYPE, nameProperty, "(annotation?, (restriction | list | union))"});
                            return (DatatypeValidator)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("string");
                        }
                        baseValidator = this.traverseLocal(content, schemaDoc, grammar);
                        if (baseValidator != null && union) {
                            dTValidators.addElement(baseValidator);
                        }
                        if (baseValidator == null) {
                            Object[] args = new Object[]{content.getAttribute(SchemaSymbols.ATT_BASE)};
                            this.reportSchemaError("dt-unknown-basetype", args);
                            return (DatatypeValidator)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("string");
                        }
                    } else {
                        numOfTypes = 1;
                        if (union) {
                            numOfTypes = size;
                        }
                        int baseRefContext = restriction ? 2 : 0;
                        baseRefContext |= union ? 4 : 0;
                        baseRefContext |= list ? 8 : 0;
                        int i = 0;
                        while (i < numOfTypes) {
                            if (union) {
                                baseTypeName = (QName)memberTypes.elementAt(i);
                            }
                            if ((baseValidator = this.findDTValidator(simpleTypeDecl, baseTypeName, baseRefContext, schemaDoc)) == null) {
                                Object[] args = new Object[]{content.getAttribute(SchemaSymbols.ATT_BASE), nameProperty};
                                this.reportSchemaError("dt-unknown-basetype", args);
                                baseValidator = (DatatypeValidator)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("string");
                            }
                            if (this.fListName.length() != 0) {
                                if (baseValidator instanceof ListDatatypeValidator) {
                                    this.reportCosListOfAtomic(nameProperty);
                                    return null;
                                }
                                if (this.isListDatatype(baseValidator)) {
                                    this.reportCosListOfAtomic(nameProperty);
                                    return null;
                                }
                            }
                            if (union) {
                                dTValidators.addElement(baseValidator);
                            }
                            ++i;
                        }
                    }
                    if (baseTypeName == null) {
                        content = DOMUtil.getNextSiblingElement(content);
                    } else if ((content = DOMUtil.getFirstChildElement(content)) != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl(content, attrValues, false, schemaDoc);
                        content = DOMUtil.getNextSiblingElement(content);
                    }
                    if (union) {
                        int index = size;
                        if (memberTypes != null) {
                            if (content != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
                                this.traverseAnnotationDecl(content, attrValues, false, schemaDoc);
                                content = DOMUtil.getNextSiblingElement(content);
                            }
                            if (content != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
                                Object[] args = new Object[]{nameProperty};
                                this.reportSchemaError("dt-union-memberType", args);
                            }
                        }
                        while (content != null) {
                            baseValidator = this.traverseLocal(content, schemaDoc, grammar);
                            if (baseValidator != null) {
                                if (this.fListName.length() != 0 && baseValidator instanceof ListDatatypeValidator) {
                                    this.reportCosListOfAtomic(nameProperty);
                                    return null;
                                }
                                dTValidators.addElement(baseValidator);
                            }
                            if (baseValidator == null) {
                                Object[] args = new Object[]{content.getAttribute(SchemaSymbols.ATT_BASE), nameProperty};
                                this.reportSchemaError("dt-unknown-basetype", args);
                                baseValidator = (DatatypeValidator)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("string");
                            }
                            content = DOMUtil.getNextSiblingElement(content);
                        }
                    }
                    if (this.fListName.length() != 0 && this.fListName.equals(qualifiedName)) {
                        this.fListName = "";
                    }
                    if (!restriction || content == null) break block46;
                    XSDAbstractTraverser.fFacetInfo fi = this.traverseFacets(content, contentAttrs, nameProperty, baseValidator, schemaDoc, grammar);
                    content = fi.nodeAfterFacets;
                    if (content != null) {
                        content = null;
                        this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_RESTRICTION, "(annotation?, (simpleType?, (minExclusive | minInclusive | maxExclusive | maxInclusive | totalDigits | fractionDigits | length | minLength | maxLength | enumeration | whiteSpace | pattern)*))"});
                    }
                    fFacetData = fi.facetdata;
                    break block47;
                }
                if (!list || content == null) break block48;
                if (baseTypeName != null) {
                    if (DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl(content, attrValues, false, schemaDoc);
                        content = DOMUtil.getNextSiblingElement(content);
                    }
                    if (content != null) {
                        Object[] args = new Object[]{nameProperty};
                        this.reportSchemaError("dt-list-itemType", args);
                    }
                    break block47;
                } else {
                    this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_LIST, "(annotation?, (simpleType?))"});
                }
                break block47;
            }
            if (union && content != null) {
                this.reportSchemaError("s4s-elt-must-match", new Object[]{SchemaSymbols.ELT_UNION, "(annotation?, (simpleType?))"});
            }
        }
        if (fFacetData == null) {
            fFacetData = new Hashtable();
        }
        DatatypeValidator newDV = null;
        newDV = list ? new ListDatatypeValidator(baseValidator, fFacetData, true, this.fErrorReporter) : (restriction ? this.createRestrictedValidator(baseValidator, fFacetData, this.fErrorReporter) : new UnionDatatypeValidator(dTValidators, this.fErrorReporter));
        if (nameProperty == null && isGlobal) {
            return null;
        }
        if (newDV != null && isGlobal) {
            newDV.setFinalSet(finalProperty);
            ((AbstractDatatypeValidator)newDV).fLocalName = nameProperty;
            grammar.addGlobalTypeDecl(newDV);
        }
        return newDV;
    }

    private void reportCosListOfAtomic(String qualifiedName) {
        this.reportSchemaError("cos-list-of-atomic", new Object[]{qualifiedName});
        this.fListName = "";
    }

    private DatatypeValidator findDTValidator(Element elm, QName baseTypeStr, int baseRefContext, XSDocumentInfo schemaDoc) {
        if (baseTypeStr.uri != null && baseTypeStr.uri.equals(SchemaSymbols.URI_SCHEMAFORSCHEMA) && baseTypeStr.localpart.equals("anySimpleType") && baseRefContext == 2) {
            String base = baseTypeStr.localpart;
            this.reportSchemaError("dt-unknown-basetype", new Object[]{DOMUtil.getAttrValue(elm, SchemaSymbols.ATT_NAME), DOMUtil.getAttrValue(elm, SchemaSymbols.ATT_BASE)});
            return (DatatypeValidator)SchemaGrammar.SG_SchemaNS.getGlobalTypeDecl("string");
        }
        DatatypeValidator baseValidator = null;
        baseValidator = (DatatypeValidator)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, baseTypeStr);
        if (baseValidator != null && (baseValidator.getFinalSet() & baseRefContext) != 0) {
            this.reportSchemaError("dt-restiction-final", new Object[]{baseTypeStr.rawname});
        }
        return baseValidator;
    }

    private boolean isListDatatype(DatatypeValidator validator) {
        if (validator instanceof UnionDatatypeValidator) {
            Vector temp = ((UnionDatatypeValidator)validator).getBaseValidators();
            int i = 0;
            while (i < temp.size()) {
                if (temp.elementAt(i) instanceof ListDatatypeValidator) {
                    return true;
                }
                if (temp.elementAt(i) instanceof UnionDatatypeValidator && this.isListDatatype((DatatypeValidator)temp.elementAt(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }
}

