/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.util.DOMUtil;
import org.w3c.dom.Element;

class XSDNotationTraverser
extends XSDAbstractTraverser {
    XSDNotationTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSNotationDecl traverse(Element elmNode, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(elmNode, true, schemaDoc);
        String nameAttr = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        String publicAttr = (String)attrValues[XSAttributeChecker.ATTIDX_PUBLIC];
        String systemAttr = (String)attrValues[XSAttributeChecker.ATTIDX_SYSTEM];
        if (nameAttr == null) {
            this.reportGenericSchemaError("<notation> must have a name");
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            return null;
        }
        if (publicAttr == null) {
            this.reportGenericSchemaError("<notation> must have 'public' attribute");
        }
        XSNotationDecl notation = new XSNotationDecl();
        notation.fName = nameAttr;
        notation.fTargetNamespace = schemaDoc.fTargetNamespace;
        notation.fPublicId = publicAttr;
        notation.fSystemId = systemAttr;
        Element content = DOMUtil.getFirstChildElement(elmNode);
        if (content != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(content, attrValues, false, schemaDoc);
            content = DOMUtil.getNextSiblingElement(content);
        }
        if (content != null) {
            Object[] args = new Object[]{DOMUtil.getLocalName(content)};
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "NotationContentRestricted", args, (short)1);
        }
        grammar.addGlobalNotationDecl(notation);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return notation;
    }
}

