/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.IDDatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

class XSDAttributeTraverser
extends XSDAbstractTraverser {
    public XSDAttributeTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    protected XSAttributeUse traverseLocal(Element attrDecl, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(attrDecl, false, schemaDoc);
        String defaultAtt = (String)attrValues[XSAttributeChecker.ATTIDX_DEFAULT];
        String fixedAtt = (String)attrValues[XSAttributeChecker.ATTIDX_FIXED];
        String nameAtt = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        QName refAtt = (QName)attrValues[XSAttributeChecker.ATTIDX_REF];
        XInt useAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_USE];
        XSAttributeDecl attribute = null;
        if (refAtt != null) {
            attribute = (XSAttributeDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 1, refAtt);
            Element child = DOMUtil.getFirstChildElement(attrDecl);
            if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
                child = DOMUtil.getNextSiblingElement(child);
            }
            if (child != null) {
                this.reportSchemaError("src-attribute.3.2", new Object[]{refAtt});
            }
            nameAtt = refAtt.localpart;
        } else {
            attribute = this.traverseNamedAttr(attrDecl, attrValues, schemaDoc, grammar, false);
        }
        int consType = 0;
        if (defaultAtt != null) {
            consType = 1;
        } else if (fixedAtt != null) {
            consType = 2;
            defaultAtt = fixedAtt;
            fixedAtt = null;
        }
        XSAttributeUse attrUse = null;
        if (attribute != null) {
            attrUse = new XSAttributeUse();
            attrUse.fAttrDecl = attribute;
            attrUse.fUse = useAtt.shortValue();
            attrUse.fConstraintType = (short)consType;
            attrUse.fDefault = defaultAtt;
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        if (defaultAtt != null && fixedAtt != null) {
            this.reportSchemaError("src-attribute.1", new Object[]{nameAtt});
        }
        if (consType == 1 && useAtt != null && useAtt.intValue() != 0) {
            this.reportSchemaError("src-attribute.2", new Object[]{nameAtt});
        }
        if (defaultAtt != null && attrUse != null) {
            if (!this.checkDefaultValid(attrUse)) {
                this.reportSchemaError("a-props-correct.2", new Object[]{nameAtt, defaultAtt});
            }
            if (attribute.fType instanceof IDDatatypeValidator) {
                this.reportSchemaError("a-props-correct.3", new Object[]{nameAtt});
            }
            if (attrUse.fAttrDecl.fConstraintType == 2 && attrUse.fConstraintType != 0 && (attrUse.fConstraintType != 2 || attrUse.fAttrDecl.fType.compare((String)attrUse.fAttrDecl.fDefault, (String)attrUse.fDefault) != 0)) {
                this.reportSchemaError("au-props-correct.2", new Object[]{nameAtt});
            }
        }
        return attrUse;
    }

    protected XSAttributeDecl traverseGlobal(Element attrDecl, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(attrDecl, true, schemaDoc);
        XSAttributeDecl attribute = this.traverseNamedAttr(attrDecl, attrValues, schemaDoc, grammar, true);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return attribute;
    }

    XSAttributeDecl traverseNamedAttr(Element attrDecl, Object[] attrValues, XSDocumentInfo schemaDoc, SchemaGrammar grammar, boolean isGlobal) {
        String childName;
        Element child;
        String defaultAtt = (String)attrValues[XSAttributeChecker.ATTIDX_DEFAULT];
        String fixedAtt = (String)attrValues[XSAttributeChecker.ATTIDX_FIXED];
        XInt formAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_FORM];
        String nameAtt = (String)attrValues[XSAttributeChecker.ATTIDX_NAME];
        QName typeAtt = (QName)attrValues[XSAttributeChecker.ATTIDX_TYPE];
        XSAttributeDecl attribute = new XSAttributeDecl();
        if (nameAtt != null) {
            attribute.fName = this.fSymbolTable.addSymbol(nameAtt);
        }
        attribute.fTargetNamespace = isGlobal ? schemaDoc.fTargetNamespace : (formAtt != null ? (formAtt.intValue() == 1 ? schemaDoc.fTargetNamespace : null) : (schemaDoc.fAreLocalAttributesQualified ? schemaDoc.fTargetNamespace : null));
        if (isGlobal) {
            if (fixedAtt != null) {
                attribute.fDefault = fixedAtt;
                attribute.fConstraintType = (short)2;
            } else if (defaultAtt != null) {
                attribute.fDefault = defaultAtt;
                attribute.fConstraintType = 1;
            } else {
                attribute.fConstraintType = 0;
            }
        }
        if ((child = DOMUtil.getFirstChildElement(attrDecl)) != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
            child = DOMUtil.getNextSiblingElement(child);
        }
        DatatypeValidator attrType = null;
        boolean haveAnonType = false;
        if (child != null && (childName = DOMUtil.getLocalName(child)).equals(SchemaSymbols.ELT_SIMPLETYPE)) {
            attrType = this.fSchemaHandler.fSimpleTypeTraverser.traverseLocal(child, schemaDoc, grammar);
            haveAnonType = true;
            child = DOMUtil.getNextSiblingElement(child);
        }
        if (attrType == null && typeAtt != null) {
            XSTypeDecl type = (XSTypeDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 7, typeAtt);
            if (type instanceof DatatypeValidator) {
                attrType = (DatatypeValidator)type;
            } else {
                this.reportGenericSchemaError("the type for attribute '" + nameAtt + "' must be a simpleType");
            }
        }
        if (attrType == null) {
            attrType = SchemaGrammar.fAnySimpleType;
        }
        attribute.fType = attrType;
        if (isGlobal && nameAtt != null) {
            grammar.addGlobalAttributeDecl(attribute);
        }
        if (nameAtt == null) {
            if (isGlobal) {
                this.reportSchemaError("s4s-att-must-appear", new Object[]{"(no name)", SchemaSymbols.ATT_NAME});
            } else {
                this.reportSchemaError("src-attribute.3.1", null);
            }
            nameAtt = "(no name)";
        }
        if (child != null) {
            this.reportSchemaError("s4s-elt-must-match", new Object[]{nameAtt, "(annotation?, (simpleType?))"});
        }
        if (defaultAtt != null && fixedAtt != null) {
            this.reportSchemaError("src-attribute.1", new Object[]{nameAtt});
        }
        if (haveAnonType && typeAtt != null) {
            this.reportSchemaError("src-attribute.4", new Object[]{nameAtt});
        }
        this.checkNotationType(nameAtt, attrType);
        if (attribute.fDefault != null && !this.checkDefaultValid(attribute)) {
            this.reportSchemaError("a-props-correct.2", new Object[]{nameAtt, defaultAtt});
        }
        if (attribute.fDefault != null && attrType instanceof IDDatatypeValidator) {
            this.reportSchemaError("a-props-correct.3", new Object[]{nameAtt});
        }
        if (nameAtt != null && nameAtt.equals(SchemaSymbols.XMLNS)) {
            this.reportSchemaError("no-xmlns", null);
        }
        if (attribute.fTargetNamespace != null && attribute.fTargetNamespace.equals("http://www.w3.org/2001/XMLSchema-instance")) {
            this.reportSchemaError("no-xsi", new Object[]{"http://www.w3.org/2001/XMLSchema-instance"});
        }
        return attribute;
    }

    boolean checkDefaultValid(XSAttributeDecl attribute) {
        boolean ret = true;
        try {
            attribute.fType.validate((String)attribute.fDefault, null);
        }
        catch (InvalidDatatypeValueException ide) {
            ret = false;
        }
        return ret;
    }

    boolean checkDefaultValid(XSAttributeUse attrUse) {
        boolean ret = true;
        try {
            attrUse.fAttrDecl.fType.validate((String)attrUse.fDefault, null);
        }
        catch (InvalidDatatypeValueException ide) {
            ret = false;
        }
        return ret;
    }
}

