/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Hashtable;
import java.util.Vector;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.NOTATIONDatatypeValidator;
import org.apache.xerces.impl.dv.xs.StringDatatypeValidator;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSAttributeUse;
import org.apache.xerces.impl.xs.XSNotationDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.XSWildcardDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XIntPool;
import org.apache.xerces.util.DOMUtil;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.w3c.dom.Element;

abstract class XSDAbstractTraverser {
    protected static final String NO_NAME = "(no name)";
    protected static final int NOT_ALL_CONTEXT = 0;
    protected static final int PROCESSING_ALL_EL = 1;
    protected static final int GROUP_REF_WITH_ALL = 2;
    protected static final int CHILD_OF_GROUP = 4;
    protected static final int PROCESSING_ALL_GP = 8;
    protected XSDHandler fSchemaHandler = null;
    protected SymbolTable fSymbolTable = null;
    protected XSAttributeChecker fAttrChecker = null;
    protected XMLErrorReporter fErrorReporter = null;
    static final XIntPool fXIntPool = new XIntPool();
    private StringBuffer fPattern = null;
    private final QName fQName = new QName();
    static /* synthetic */ Class class$org$apache$xerces$impl$dv$xs$DatatypeValidator;
    static /* synthetic */ Class class$java$util$Hashtable;
    static /* synthetic */ Class class$org$apache$xerces$impl$XMLErrorReporter;

    XSDAbstractTraverser(XSDHandler handler, XSAttributeChecker attrChecker) {
        this.fSchemaHandler = handler;
        this.fAttrChecker = attrChecker;
    }

    void reset(XMLErrorReporter errorReporter, SymbolTable symbolTable) {
        this.fErrorReporter = errorReporter;
        this.fSymbolTable = symbolTable;
    }

    void traverseAnnotationDecl(Element annotationDecl, Object[] parentAttrs, boolean isGlobal, XSDocumentInfo schemaDoc) {
        Object[] attrValues = this.fAttrChecker.checkAttributes(annotationDecl, isGlobal, schemaDoc);
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        Element child = DOMUtil.getFirstChildElement(annotationDecl);
        while (child != null) {
            String name = DOMUtil.getLocalName(child);
            if (!name.equals(SchemaSymbols.ELT_APPINFO) && !name.equals(SchemaSymbols.ELT_DOCUMENTATION)) {
                this.reportGenericSchemaError("an <annotation> can only contain <appinfo> and <documentation> elements");
            }
            attrValues = this.fAttrChecker.checkAttributes(child, true, schemaDoc);
            this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
            child = DOMUtil.getNextSiblingElement(child);
        }
    }

    DatatypeValidator createRestrictedValidator(DatatypeValidator baseValidator, Hashtable facetData, XMLErrorReporter reporter) {
        String value;
        DatatypeValidator newDV = null;
        Class<?> validatorDef = baseValidator.getClass();
        Class[] validatorArgsClass = new Class[]{class$org$apache$xerces$impl$dv$xs$DatatypeValidator == null ? (class$org$apache$xerces$impl$dv$xs$DatatypeValidator = XSDAbstractTraverser.class$("org.apache.xerces.impl.dv.xs.DatatypeValidator")) : class$org$apache$xerces$impl$dv$xs$DatatypeValidator, class$java$util$Hashtable == null ? (class$java$util$Hashtable = XSDAbstractTraverser.class$("java.util.Hashtable")) : class$java$util$Hashtable, Boolean.TYPE, class$org$apache$xerces$impl$XMLErrorReporter == null ? (class$org$apache$xerces$impl$XMLErrorReporter = XSDAbstractTraverser.class$("org.apache.xerces.impl.XMLErrorReporter")) : class$org$apache$xerces$impl$XMLErrorReporter};
        if (facetData != null && (value = (String)facetData.get(SchemaSymbols.ELT_WHITESPACE)) != null && !(baseValidator instanceof StringDatatypeValidator)) {
            if (!value.equals("collapse")) {
                this.reportSchemaError("WhitespaceFacetError", new Object[]{value});
            }
            facetData.remove(SchemaSymbols.ELT_WHITESPACE);
        }
        Object[] validatorArgs = new Object[]{baseValidator, facetData, Boolean.FALSE, this.fErrorReporter};
        try {
            Constructor<?> validatorConstructor = validatorDef.getConstructor(validatorArgsClass);
            newDV = (DatatypeValidator)validatorConstructor.newInstance(validatorArgs);
        }
        catch (NoSuchMethodException e) {
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (IllegalArgumentException e) {
            this.reportGenericSchemaError(e.getMessage());
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return newDV;
    }

    fFacetInfo traverseFacets(Element content, Object[] contentAttrs, String simpleTypeName, DatatypeValidator baseValidator, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        fFacetInfo fi = new fFacetInfo();
        Hashtable<String, Object> fFacetData = new Hashtable<String, Object>(10);
        short flags = 0;
        int numEnumerationLiterals = 0;
        Vector<String> enumData = new Vector<String>();
        if (content != null) {
            if (DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.traverseAnnotationDecl(content, contentAttrs, false, schemaDoc);
                content = DOMUtil.getNextSiblingElement(content);
            }
            if (content != null && DOMUtil.getLocalName(content).equals(SchemaSymbols.ELT_ANNOTATION)) {
                this.reportGenericSchemaError("Facets have more than one annotation.");
            }
        }
        int numFacets = 0;
        while (content != null) {
            Element child;
            Object[] attrs = this.fAttrChecker.checkAttributes(content, false, schemaDoc);
            ++numFacets;
            String facet = DOMUtil.getLocalName(content);
            if (facet.equals(SchemaSymbols.ELT_ENUMERATION)) {
                ++numEnumerationLiterals;
                String enumVal = DOMUtil.getAttrValue(content, SchemaSymbols.ATT_VALUE);
                if (baseValidator instanceof NOTATIONDatatypeValidator) {
                    this.fAttrChecker.checkAttributes(content, false, schemaDoc);
                    String prefix = this.fSchemaHandler.EMPTY_STRING;
                    String localpart = enumVal;
                    int colonptr = enumVal.indexOf(":");
                    if (colonptr > 0) {
                        prefix = this.fSymbolTable.addSymbol(enumVal.substring(0, colonptr));
                        localpart = enumVal.substring(colonptr + 1);
                    }
                    String uriStr = schemaDoc.fNamespaceSupport.getURI(prefix);
                    if (prefix != this.fSchemaHandler.EMPTY_STRING && uriStr == null) {
                        this.reportGenericSchemaError("Cannot resolve the prefix of the NOTATION  value '" + enumVal + "'");
                    }
                    this.fQName.setValues(prefix, localpart, null, uriStr);
                    XSNotationDecl notation = (XSNotationDecl)this.fSchemaHandler.getGlobalDecl(schemaDoc, 6, this.fQName);
                    if (notation == null) {
                        this.reportGenericSchemaError("Notation '" + localpart + "' not found in the grammar " + uriStr);
                    }
                    enumVal = uriStr != null ? uriStr + "," + localpart : localpart;
                    this.fSymbolTable.addSymbol(enumVal);
                }
                enumData.addElement(enumVal);
                child = DOMUtil.getFirstChildElement(content);
                if (child != null) {
                    if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl(child, attrs, false, schemaDoc);
                        child = DOMUtil.getNextSiblingElement(child);
                    }
                    if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportGenericSchemaError("Enumeration facet has more than one annotation.");
                    }
                }
            } else if (facet.equals(SchemaSymbols.ELT_ANNOTATION) || facet.equals(SchemaSymbols.ELT_SIMPLETYPE)) {
                Object[] args = new Object[]{simpleTypeName};
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "ListUnionRestrictionError", args, (short)1);
            } else if (facet.equals(SchemaSymbols.ELT_PATTERN)) {
                if (this.fPattern == null) {
                    this.fPattern = new StringBuffer(DOMUtil.getAttrValue(content, SchemaSymbols.ATT_VALUE));
                } else {
                    this.fPattern.append("|");
                    this.fPattern.append(DOMUtil.getAttrValue(content, SchemaSymbols.ATT_VALUE));
                    Element child2 = DOMUtil.getFirstChildElement(content);
                    if (child2 != null) {
                        if (DOMUtil.getLocalName(child2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                            this.traverseAnnotationDecl(child2, attrs, false, schemaDoc);
                            child2 = DOMUtil.getNextSiblingElement(child2);
                        }
                        if (child2 != null && DOMUtil.getLocalName(child2).equals(SchemaSymbols.ELT_ANNOTATION)) {
                            this.reportGenericSchemaError("Pattern facet has more than one annotation.");
                        }
                    }
                }
            } else {
                if (fFacetData.containsKey(facet)) {
                    this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "DatatypeError", new Object[]{"The facet '" + facet + "' is defined more than once."}, (short)1);
                }
                int facetType = 0;
                if (facet.equals(SchemaSymbols.ELT_MINLENGTH)) {
                    facetType = 2;
                } else if (facet.equals(SchemaSymbols.ELT_MAXLENGTH)) {
                    facetType = 4;
                } else if (facet.equals(SchemaSymbols.ELT_MAXEXCLUSIVE)) {
                    facetType = 64;
                } else if (facet.equals(SchemaSymbols.ELT_MAXINCLUSIVE)) {
                    facetType = 32;
                } else if (facet.equals(SchemaSymbols.ELT_MINEXCLUSIVE)) {
                    facetType = 256;
                } else if (facet.equals(SchemaSymbols.ELT_MININCLUSIVE)) {
                    facetType = 128;
                } else if (facet.equals(SchemaSymbols.ELT_TOTALDIGITS)) {
                    facetType = 512;
                } else if (facet.equals(SchemaSymbols.ELT_FRACTIONDIGITS)) {
                    facetType = 1024;
                } else if (facet.equals(SchemaSymbols.ELT_WHITESPACE)) {
                    if (baseValidator instanceof StringDatatypeValidator) {
                        facetType = 16384;
                    }
                } else if (!facet.equals(SchemaSymbols.ELT_LENGTH)) break;
                if (content.getAttribute(SchemaSymbols.ATT_FIXED).equals("true") || content.getAttribute(SchemaSymbols.ATT_FIXED).equals("1")) {
                    flags = (short)(flags | facetType);
                }
                fFacetData.put(facet, content.getAttribute(SchemaSymbols.ATT_VALUE));
                child = DOMUtil.getFirstChildElement(content);
                if (child != null) {
                    if (DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.traverseAnnotationDecl(child, attrs, false, schemaDoc);
                        child = DOMUtil.getNextSiblingElement(child);
                    }
                    if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
                        this.reportGenericSchemaError(facet + " facet has more than one annotation.");
                    }
                }
            }
            this.fAttrChecker.returnAttrArray(attrs, schemaDoc);
            content = DOMUtil.getNextSiblingElement(content);
        }
        if (numEnumerationLiterals > 0) {
            fFacetData.put(SchemaSymbols.ELT_ENUMERATION, enumData);
        }
        if (this.fPattern != null) {
            fFacetData.put(SchemaSymbols.ELT_PATTERN, this.fPattern.toString());
        }
        if (flags != 0) {
            fFacetData.put("fixed", new Short(flags));
        }
        this.fPattern = null;
        fi.facetdata = fFacetData;
        fi.nodeAfterFacets = content;
        return fi;
    }

    Element traverseAttrsAndAttrGrps(Element firstAttr, XSAttributeGroupDecl attrGrp, XSDocumentInfo schemaDoc, SchemaGrammar grammar) {
        String childName;
        Element child = null;
        XSAttributeGroupDecl tempAttrGrp = null;
        XSAttributeUse tempAttrUse = null;
        child = firstAttr;
        while (child != null) {
            childName = DOMUtil.getLocalName(child);
            if (childName.equals(SchemaSymbols.ELT_ATTRIBUTE)) {
                tempAttrUse = this.fSchemaHandler.fAttributeTraverser.traverseLocal(child, schemaDoc, grammar);
                if (tempAttrUse == null) break;
                if (attrGrp.getAttributeUse(tempAttrUse.fAttrDecl.fTargetNamespace, tempAttrUse.fAttrDecl.fName) == null) {
                    String idName = attrGrp.addAttributeUse(tempAttrUse);
                    if (idName != null) {
                        this.reportGenericSchemaError("Two distinct members of the {attribute uses} '" + idName + "' and '" + tempAttrUse.fAttrDecl.fName + "' have {attribute declaration}s both of whose {type definition}s are or are derived from ID");
                    }
                } else {
                    this.reportGenericSchemaError("Duplicate attribute " + tempAttrUse.fAttrDecl.fName + " found ");
                }
            } else {
                if (!childName.equals(SchemaSymbols.ELT_ATTRIBUTEGROUP) || (tempAttrGrp = this.fSchemaHandler.fAttributeGroupTraverser.traverseLocal(child, schemaDoc, grammar)) == null) break;
                XSAttributeUse[] attrUseS = tempAttrGrp.getAttributeUses();
                XSAttributeUse existingAttrUse = null;
                int i = 0;
                while (i < attrUseS.length) {
                    existingAttrUse = attrGrp.getAttributeUse(attrUseS[i].fAttrDecl.fTargetNamespace, attrUseS[i].fAttrDecl.fName);
                    if (existingAttrUse == null) {
                        String idName = attrGrp.addAttributeUse(attrUseS[i]);
                        if (idName != null) {
                            this.reportGenericSchemaError("Two distinct members of the {attribute uses} '" + idName + "' and '" + attrUseS[i].fAttrDecl.fName + "' have {attribute declaration}s both of whose {type definition}s are or are derived from ID");
                        }
                    } else {
                        this.reportGenericSchemaError("Duplicate attribute " + existingAttrUse.fAttrDecl.fName + " found ");
                    }
                    ++i;
                }
                if (tempAttrGrp.fAttributeWC != null) {
                    if (attrGrp.fAttributeWC == null) {
                        attrGrp.fAttributeWC = tempAttrGrp.fAttributeWC;
                    } else {
                        attrGrp.fAttributeWC = attrGrp.fAttributeWC.performIntersectionWith(tempAttrGrp.fAttributeWC, attrGrp.fAttributeWC.fProcessContents);
                        if (attrGrp.fAttributeWC == null) {
                            this.reportGenericSchemaError("intersection of wildcards is not expressible");
                        }
                    }
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        if (child != null && (childName = DOMUtil.getLocalName(child)).equals(SchemaSymbols.ELT_ANYATTRIBUTE)) {
            XSWildcardDecl tempAttrWC = this.fSchemaHandler.fWildCardTraverser.traverseAnyAttribute(child, schemaDoc, grammar);
            if (attrGrp.fAttributeWC == null) {
                attrGrp.fAttributeWC = tempAttrWC;
            } else {
                attrGrp.fAttributeWC = tempAttrWC.performIntersectionWith(attrGrp.fAttributeWC, tempAttrWC.fProcessContents);
                if (attrGrp.fAttributeWC == null) {
                    this.reportGenericSchemaError("intersection of wildcards is not expressible");
                }
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        return child;
    }

    void reportSchemaError(String key, Object[] args) {
        this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", key, args, (short)1);
    }

    void reportGenericSchemaError(String error) {
        this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "General", new Object[]{error}, (short)1);
    }

    void checkNotationType(String refName, XSTypeDecl typeDecl) {
        if (typeDecl instanceof NOTATIONDatatypeValidator && !((DatatypeValidator)typeDecl).hasEnumeration()) {
            this.reportSchemaError("dt-enumeration-notation", new Object[]{refName});
        }
    }

    protected XSParticleDecl checkOccurrences(XSParticleDecl particle, String particleName, Element parent, int allContextFlags, long defaultVals) {
        boolean isGroupChild;
        int min = particle.fMinOccurs;
        int max = particle.fMaxOccurs;
        boolean defaultMin = (defaultVals & (long)(1 << XSAttributeChecker.ATTIDX_MINOCCURS)) != 0L;
        boolean defaultMax = (defaultVals & (long)(1 << XSAttributeChecker.ATTIDX_MAXOCCURS)) != 0L;
        boolean processingAllEl = (allContextFlags & 1) != 0;
        boolean processingAllGP = (allContextFlags & 8) != 0;
        boolean groupRefWithAll = (allContextFlags & 2) != 0;
        boolean bl = isGroupChild = (allContextFlags & 4) != 0;
        if (!(!isGroupChild || defaultMin && defaultMax)) {
            Object[] args = new Object[]{parent.getAttribute(SchemaSymbols.ATT_NAME), particleName};
            this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", "MinMaxOnGroupChild", args, (short)1);
            max = 1;
            min = 1;
        }
        if (min == 0 && max == 0) {
            particle.fType = 0;
            return null;
        }
        if (processingAllEl || groupRefWithAll || processingAllGP) {
            Object[] args;
            String errorMsg;
            if ((processingAllGP || groupRefWithAll || min != 0) && min != 1) {
                errorMsg = processingAllEl ? "BadMinMaxForAllElem" : (processingAllGP ? "BadMinMaxForAllGp" : "BadMinMaxForGroupWithAll");
                args = new Object[]{"minOccurs", fXIntPool.getXInt(min)};
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", errorMsg, args, (short)1);
                min = 1;
            }
            if (max != 1) {
                errorMsg = processingAllEl ? "BadMinMaxForAllElem" : (processingAllGP ? "BadMinMaxForAllGp" : "BadMinMaxForGroupWithAll");
                args = new Object[]{"maxOccurs", fXIntPool.getXInt(max)};
                this.fErrorReporter.reportError("http://www.w3.org/TR/xml-schema-1", errorMsg, args, (short)1);
                max = 1;
            }
        }
        particle.fMaxOccurs = min;
        particle.fMaxOccurs = max;
        return particle;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    class fFacetInfo {
        Hashtable facetdata;
        Element nodeAfterFacets;

        fFacetInfo() {
        }
    }
}

