/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.traversers;

import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.SchemaSymbols;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.traversers.XSAttributeChecker;
import org.apache.xerces.impl.xs.traversers.XSDAbstractTraverser;
import org.apache.xerces.impl.xs.traversers.XSDHandler;
import org.apache.xerces.impl.xs.traversers.XSDocumentInfo;
import org.apache.xerces.impl.xs.util.XInt;
import org.apache.xerces.util.DOMUtil;
import org.w3c.dom.Element;

abstract class XSDAbstractParticleTraverser
extends XSDAbstractTraverser {
    XSDAbstractParticleTraverser(XSDHandler handler, XSAttributeChecker gAttrCheck) {
        super(handler, gAttrCheck);
    }

    XSParticleDecl traverseAll(Element allDecl, XSDocumentInfo schemaDoc, SchemaGrammar grammar, int allContextFlags) {
        XSParticleDecl temp;
        Object[] attrValues = this.fAttrChecker.checkAttributes(allDecl, false, schemaDoc);
        Element child = DOMUtil.getFirstChildElement(allDecl);
        if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
            child = DOMUtil.getNextSiblingElement(child);
        }
        XSParticleDecl left = null;
        XSParticleDecl right = null;
        String childName = null;
        while (child != null) {
            XSParticleDecl particle = null;
            childName = DOMUtil.getLocalName(child);
            if (childName.equals(SchemaSymbols.ELT_ELEMENT)) {
                particle = this.fSchemaHandler.fElementTraverser.traverseLocal(child, schemaDoc, grammar, 1);
            } else {
                Object[] args = new Object[]{childName};
                this.reportSchemaError("AllContentRestricted", args);
            }
            if (left == null) {
                left = particle;
            } else if (right == null) {
                right = particle;
            } else {
                temp = new XSParticleDecl();
                temp.fType = (short)5;
                temp.fValue = left;
                temp.fOtherValue = right;
                left = temp;
                right = particle;
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        if (left != null) {
            temp = new XSParticleDecl();
            temp.fType = (short)5;
            temp.fValue = left;
            temp.fOtherValue = right;
            left = temp;
        }
        if (left != null) {
            XInt minAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_MINOCCURS];
            XInt maxAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_MAXOCCURS];
            Long defaultVals = (Long)attrValues[XSAttributeChecker.ATTIDX_FROMDEFAULT];
            left.fMinOccurs = minAtt.intValue();
            left.fMaxOccurs = maxAtt.intValue();
            left = this.checkOccurrences(left, SchemaSymbols.ELT_ALL, (Element)allDecl.getParentNode(), allContextFlags, defaultVals);
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return left;
    }

    XSParticleDecl traverseSequence(Element seqDecl, XSDocumentInfo schemaDoc, SchemaGrammar grammar, int allContextFlags) {
        return this.traverseSeqChoice(seqDecl, schemaDoc, grammar, allContextFlags, false);
    }

    XSParticleDecl traverseChoice(Element choiceDecl, XSDocumentInfo schemaDoc, SchemaGrammar grammar, int allContextFlags) {
        return this.traverseSeqChoice(choiceDecl, schemaDoc, grammar, allContextFlags, true);
    }

    private XSParticleDecl traverseSeqChoice(Element decl, XSDocumentInfo schemaDoc, SchemaGrammar grammar, int allContextFlags, boolean choice) {
        XSParticleDecl temp;
        Object[] attrValues = this.fAttrChecker.checkAttributes(decl, false, schemaDoc);
        Element child = DOMUtil.getFirstChildElement(decl);
        if (child != null && DOMUtil.getLocalName(child).equals(SchemaSymbols.ELT_ANNOTATION)) {
            this.traverseAnnotationDecl(child, attrValues, false, schemaDoc);
            child = DOMUtil.getNextSiblingElement(child);
        }
        XSParticleDecl left = null;
        XSParticleDecl right = null;
        boolean hadContent = false;
        String childName = null;
        while (child != null) {
            Object[] args;
            XSParticleDecl particle = null;
            childName = DOMUtil.getLocalName(child);
            if (childName.equals(SchemaSymbols.ELT_ELEMENT)) {
                particle = this.fSchemaHandler.fElementTraverser.traverseLocal(child, schemaDoc, grammar, 0);
            } else if (childName.equals(SchemaSymbols.ELT_GROUP)) {
                particle = this.fSchemaHandler.fGroupTraverser.traverseLocal(child, schemaDoc, grammar);
                if (this.hasAllContent(particle)) {
                    args = choice ? new Object[]{SchemaSymbols.ELT_CHOICE} : new Object[]{SchemaSymbols.ELT_SEQUENCE};
                    this.reportSchemaError("AllContentLimited", args);
                }
            } else if (childName.equals(SchemaSymbols.ELT_CHOICE)) {
                particle = this.traverseChoice(child, schemaDoc, grammar, 0);
            } else if (childName.equals(SchemaSymbols.ELT_SEQUENCE)) {
                particle = this.traverseSequence(child, schemaDoc, grammar, 0);
            } else if (childName.equals(SchemaSymbols.ELT_ANY)) {
                particle = this.fSchemaHandler.fWildCardTraverser.traverseAny(child, schemaDoc, grammar);
            } else {
                args = choice ? new Object[]{SchemaSymbols.ELT_CHOICE} : new Object[]{SchemaSymbols.ELT_SEQUENCE};
                this.reportSchemaError("SeqChoiceContentRestricted", args);
            }
            if (left == null) {
                left = particle;
            } else if (right == null) {
                right = particle;
            } else {
                temp = new XSParticleDecl();
                temp.fType = choice ? (short)3 : (short)4;
                temp.fValue = left;
                temp.fOtherValue = right;
                left = temp;
                right = particle;
            }
            child = DOMUtil.getNextSiblingElement(child);
        }
        if (left != null) {
            temp = new XSParticleDecl();
            temp.fType = choice ? (short)3 : (short)4;
            temp.fValue = left;
            temp.fOtherValue = right;
            left = temp;
            XInt minAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_MINOCCURS];
            XInt maxAtt = (XInt)attrValues[XSAttributeChecker.ATTIDX_MAXOCCURS];
            Long defaultVals = (Long)attrValues[XSAttributeChecker.ATTIDX_FROMDEFAULT];
            left.fMinOccurs = minAtt.intValue();
            left.fMaxOccurs = maxAtt.intValue();
            left = this.checkOccurrences(left, choice ? SchemaSymbols.ELT_CHOICE : SchemaSymbols.ELT_SEQUENCE, (Element)decl.getParentNode(), allContextFlags, defaultVals);
        }
        this.fAttrChecker.returnAttrArray(attrValues, schemaDoc);
        return left;
    }

    protected boolean hasAllContent(XSParticleDecl particle) {
        if (particle != null) {
            return particle.fType == 5;
        }
        return false;
    }
}

