/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.xs.SubstitutionGroupHandler;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.xni.QName;

public class XSSimpleCM
implements XSCMValidator {
    private static final short STATE_START = 0;
    private static final short STATE_FIRST = 1;
    private static final short STATE_VALID = 2;
    private XSElementDecl fFirstElement = null;
    private XSElementDecl fSecondElement = null;
    private short fOperator;

    public XSSimpleCM(short operator, XSElementDecl elem) {
        this.fFirstElement = elem;
        this.fOperator = operator;
    }

    public XSSimpleCM(short operator, XSElementDecl elem1, XSElementDecl elem2) {
        this.fFirstElement = elem1;
        this.fSecondElement = elem2;
        this.fOperator = operator;
    }

    public int[] startContentModel() {
        return new int[]{0};
    }

    public Object oneTransition(QName elementName, int[] currentState, SubstitutionGroupHandler subGroupHandler) {
        if (currentState[0] == -1) {
            currentState[0] = -2;
            return null;
        }
        int state = currentState[0];
        XSElementDecl matchingDecl = null;
        switch (this.fOperator) {
            case 1: 
            case 6: {
                if (state != 0 || (matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fFirstElement)) == null) break;
                currentState[0] = 2;
                return matchingDecl;
            }
            case 7: 
            case 8: {
                matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fFirstElement);
                if (matchingDecl == null) break;
                currentState[0] = 2;
                return matchingDecl;
            }
            case 3: {
                if (state != 0) break;
                matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fFirstElement);
                if (matchingDecl != null) {
                    currentState[0] = 2;
                    return matchingDecl;
                }
                matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fSecondElement);
                if (matchingDecl == null) break;
                currentState[0] = 2;
                return matchingDecl;
            }
            case 4: {
                if (state == 0) {
                    matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fFirstElement);
                    if (matchingDecl == null) break;
                    currentState[0] = 1;
                    return matchingDecl;
                }
                if (state != 1 || (matchingDecl = subGroupHandler.getMatchingElemDecl(elementName, this.fSecondElement)) == null) break;
                currentState[0] = 2;
                return matchingDecl;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        currentState[0] = -1;
        return null;
    }

    public boolean endContentModel(int[] currentState) {
        boolean isFinal = false;
        int state = currentState[0];
        if (state < 0) {
            return false;
        }
        switch (this.fOperator) {
            case 1: 
            case 3: 
            case 4: 
            case 8: {
                isFinal = state == 2;
                break;
            }
            case 6: 
            case 7: {
                isFinal = state == 2 || state == 0;
                break;
            }
            default: {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        return isFinal;
    }
}

