/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.identity.IdentityConstraint;

public class XSElementDecl {
    public static final short NO_CONSTRAINT = 0;
    public static final short DEFAULT_VALUE = 1;
    public static final short FIXED_VALUE = 2;
    public String fName = null;
    public String fTargetNamespace = null;
    public XSTypeDecl fType = null;
    short fMiscFlags = 0;
    public short fBlock = 0;
    public short fFinal = 0;
    public Object fDefault = null;
    public XSElementDecl fSubGroup = null;
    static final int INITIAL_SIZE = 2;
    int fIDCPos = 0;
    IdentityConstraint[] fIDConstraints = new IdentityConstraint[2];
    private static final short CONSTRAINT_MASK = 3;
    private static final short NILLABLE = 4;
    private static final short ABSTRACT = 8;
    private String fDescription = null;

    public short getConstraintType() {
        return (short)(this.fMiscFlags & 3);
    }

    public boolean isNillable() {
        return (this.fMiscFlags & 4) != 0;
    }

    public boolean isAbstract() {
        return (this.fMiscFlags & 8) != 0;
    }

    public void setConstraintType(short constraintType) {
        this.fMiscFlags = (short)(this.fMiscFlags | constraintType & 3);
    }

    public void setIsNillable() {
        this.fMiscFlags = (short)(this.fMiscFlags | 4);
    }

    public void setIsAbstract() {
        this.fMiscFlags = (short)(this.fMiscFlags | 8);
    }

    public void addIDConstaint(IdentityConstraint idc) {
        if (this.fIDCPos == this.fIDConstraints.length) {
            this.fIDConstraints = XSElementDecl.resize(this.fIDConstraints, this.fIDCPos * 2);
        }
        this.fIDConstraints[this.fIDCPos++] = idc;
    }

    public IdentityConstraint[] getIDConstraints() {
        if (this.fIDCPos < this.fIDConstraints.length) {
            this.fIDConstraints = XSElementDecl.resize(this.fIDConstraints, this.fIDCPos);
        }
        return this.fIDConstraints;
    }

    static final IdentityConstraint[] resize(IdentityConstraint[] oldArray, int newSize) {
        IdentityConstraint[] newArray = new IdentityConstraint[newSize];
        System.arraycopy(oldArray, 0, newArray, 0, Math.min(oldArray.length, newSize));
        return newArray;
    }

    public String toString() {
        if (this.fDescription == null) {
            StringBuffer buffer = new StringBuffer();
            buffer.append("\"");
            if (this.fTargetNamespace != null) {
                buffer.append(this.fTargetNamespace);
            }
            buffer.append("\"");
            buffer.append(":");
            buffer.append(this.fName);
            this.fDescription = buffer.toString();
        }
        return this.fDescription;
    }
}

