/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import java.util.Vector;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.ListDatatypeValidator;
import org.apache.xerces.impl.dv.xs.UnionDatatypeValidator;
import org.apache.xerces.impl.xs.SchemaGrammar;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;

public class XSConstraints {
    public static boolean checkTypeDerivationOk(XSTypeDecl derived, XSTypeDecl base, int block) {
        if (derived == SchemaGrammar.fAnyType) {
            return derived == base;
        }
        if (derived == SchemaGrammar.fAnySimpleType) {
            return base == SchemaGrammar.fAnyType || base == SchemaGrammar.fAnySimpleType;
        }
        if (derived.getXSType() == 2) {
            if (base.getXSType() == 1) {
                if (base == SchemaGrammar.fAnyType) {
                    base = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return XSConstraints.checkSimpleDerivation((DatatypeValidator)derived, (DatatypeValidator)base, block);
        }
        return XSConstraints.checkComplexDerivation((XSComplexTypeDecl)derived, base, block);
    }

    public static boolean checkSimpleDerivationOk(DatatypeValidator derived, XSTypeDecl base, int block) {
        if (derived == SchemaGrammar.fAnySimpleType) {
            return base == SchemaGrammar.fAnyType || base == SchemaGrammar.fAnySimpleType;
        }
        if (base.getXSType() == 1) {
            if (base == SchemaGrammar.fAnyType) {
                base = SchemaGrammar.fAnySimpleType;
            } else {
                return false;
            }
        }
        return XSConstraints.checkSimpleDerivation(derived, (DatatypeValidator)base, block);
    }

    public static boolean checkComplexDerivationOk(XSComplexTypeDecl derived, XSTypeDecl base, int block) {
        if (derived == SchemaGrammar.fAnyType) {
            return derived == base;
        }
        return XSConstraints.checkComplexDerivation(derived, base, block);
    }

    private static boolean checkSimpleDerivation(DatatypeValidator derived, DatatypeValidator base, int block) {
        if (derived == base) {
            return true;
        }
        if ((block & 2) != 0 || (derived.getBaseValidator().getFinalSet() & 2) != 0) {
            return false;
        }
        DatatypeValidator directBase = derived.getBaseValidator();
        if (directBase == base) {
            return true;
        }
        if (directBase != SchemaGrammar.fAnySimpleType && XSConstraints.checkSimpleDerivation(directBase, base, block)) {
            return true;
        }
        if ((derived instanceof ListDatatypeValidator || derived instanceof UnionDatatypeValidator) && base == SchemaGrammar.fAnySimpleType) {
            return true;
        }
        if (base instanceof UnionDatatypeValidator) {
            Vector subUnionMemberDV = ((UnionDatatypeValidator)base).getBaseValidators();
            int subUnionSize = subUnionMemberDV.size();
            int i = 0;
            while (i < subUnionSize) {
                base = (DatatypeValidator)subUnionMemberDV.elementAt(i);
                if (XSConstraints.checkSimpleDerivation(derived, base, block)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private static boolean checkComplexDerivation(XSComplexTypeDecl derived, XSTypeDecl base, int block) {
        if (derived == base) {
            return true;
        }
        if ((derived.fDerivedBy & block) != 0) {
            return false;
        }
        XSTypeDecl directBase = derived.fBaseType;
        if (directBase == base) {
            return true;
        }
        if (directBase == SchemaGrammar.fAnyType || directBase == SchemaGrammar.fAnySimpleType) {
            return false;
        }
        if (directBase.getXSType() == 1) {
            return XSConstraints.checkComplexDerivation((XSComplexTypeDecl)directBase, base, block);
        }
        if (directBase.getXSType() == 2) {
            if (base.getXSType() == 1) {
                if (base == SchemaGrammar.fAnyType) {
                    base = SchemaGrammar.fAnySimpleType;
                } else {
                    return false;
                }
            }
            return XSConstraints.checkSimpleDerivation((DatatypeValidator)directBase, (DatatypeValidator)base, block);
        }
        return false;
    }

    public static boolean ElementDefaultValidImmediate(XSTypeDecl type, String value) {
        return true;
    }
}

