/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs;

import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.xs.XSAttributeGroupDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.XSTypeDecl;
import org.apache.xerces.impl.xs.models.CMBuilder;
import org.apache.xerces.impl.xs.models.XSCMValidator;

public class XSComplexTypeDecl
implements XSTypeDecl {
    public static final short CONTENTTYPE_EMPTY = 0;
    public static final short CONTENTTYPE_SIMPLE = 1;
    public static final short CONTENTTYPE_MIXED = 2;
    public static final short CONTENTTYPE_ELEMENT = 3;
    public String fName = null;
    public String fTargetNamespace = null;
    public XSTypeDecl fBaseType = null;
    public short fDerivedBy = (short)2;
    public short fFinal = 0;
    public short fBlock = 0;
    public short fMiscFlags = 0;
    public XSAttributeGroupDecl fAttrGrp = new XSAttributeGroupDecl();
    public short fContentType = 0;
    public DatatypeValidator fDatatypeValidator = null;
    public XSParticleDecl fParticle = null;
    public XSCMValidator fCMValidator = null;
    private static final short CT_IS_ABSTRACT = 1;
    private static final short CT_HAS_TYPE_ID = 2;

    public short getXSType() {
        return 1;
    }

    public String getXSTypeName() {
        return this.fName;
    }

    public boolean isAbstractType() {
        return (this.fMiscFlags & 1) != 0;
    }

    public boolean containsTypeID() {
        return (this.fMiscFlags & 2) != 0;
    }

    public void setIsAbstractType() {
        this.fMiscFlags = (short)(this.fMiscFlags | 1);
    }

    public void setContainsTypeID() {
        this.fMiscFlags = (short)(this.fMiscFlags | 2);
    }

    public XSCMValidator getContentModel(CMBuilder cmBuilder) {
        if (this.fCMValidator != null) {
            return this.fCMValidator;
        }
        cmBuilder.getContentModel(this);
        return this.fCMValidator;
    }

    public String toString() {
        StringBuffer str = new StringBuffer();
        this.appendTypeInfo(str);
        return str.toString();
    }

    void appendTypeInfo(StringBuffer str) {
        String[] contentType = new String[]{"EMPTY", "SIMPLE", "MIXED", "ELEMENT"};
        String[] derivedBy = new String[]{"EMPTY", "EXTENSION", "RESTRICTION"};
        str.append("Complex type name='" + this.fTargetNamespace + "," + this.getXSTypeName() + "', ");
        if (this.fBaseType != null) {
            str.append(" base type name='" + this.fBaseType.getXSTypeName() + "', ");
        }
        str.append(" content type='" + contentType[this.fContentType] + "', ");
        str.append(" isAbstract='" + this.isAbstractType() + "', ");
        str.append(" hasTypeId='" + this.containsTypeID() + "', ");
        str.append(" final='" + this.fFinal + "', ");
        str.append(" block='" + this.fBlock + "', ");
        if (this.fParticle != null) {
            str.append(" particle='" + this.fParticle.toString() + "', ");
        }
        str.append(" derivedBy='" + derivedBy[this.fDerivedBy] + "'. ");
    }
}

