/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dv.xs;

import java.text.Collator;
import java.util.Hashtable;
import java.util.Locale;
import org.apache.xerces.impl.XMLErrorReporter;
import org.apache.xerces.impl.dv.xs.AbstractStringValidator;
import org.apache.xerces.impl.dv.xs.DatatypeMessageProvider;
import org.apache.xerces.impl.dv.xs.DatatypeValidator;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeFacetException;
import org.apache.xerces.impl.dv.xs.InvalidDatatypeValueException;

public class QNameDatatypeValidator
extends AbstractStringValidator {
    private static DatatypeValidator fgStrValidator = null;

    public QNameDatatypeValidator() {
        this(null, null, false, null);
    }

    public QNameDatatypeValidator(DatatypeValidator base, Hashtable facets, boolean derivedByList, XMLErrorReporter reporter) {
        super(base, facets, derivedByList, reporter);
    }

    protected void assignAdditionalFacets(String key, Hashtable facets) throws InvalidDatatypeFacetException {
        String msg = this.getErrorString(DatatypeMessageProvider.fgMessageKeys[DatatypeMessageProvider.ILLEGAL_STRING_FACET], new Object[]{key});
        throw new InvalidDatatypeFacetException(msg);
    }

    protected void checkValueSpace(String content) throws InvalidDatatypeValueException {
        try {
            int posColon = content.indexOf(58);
            if (posColon >= 0) {
                fgStrValidator.validate(content.substring(0, posColon), null);
            }
            fgStrValidator.validate(content.substring(posColon + 1), null);
        }
        catch (InvalidDatatypeValueException idve) {
            throw new InvalidDatatypeValueException("Value '" + content + "' is not a valid QName");
        }
    }

    public int compare(String content, String facetValue) {
        Locale loc = Locale.getDefault();
        Collator collator = Collator.getInstance(loc);
        return collator.compare(content, facetValue);
    }

    public static void setNCNameValidator(DatatypeValidator dv) {
        if (fgStrValidator == null) {
            fgStrValidator = dv;
        }
    }
}

