/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.dtd;

import java.util.Hashtable;
import org.apache.xerces.impl.dtd.Grammar;
import org.apache.xerces.impl.dtd.XMLAttributeDecl;
import org.apache.xerces.impl.dtd.XMLContentSpec;
import org.apache.xerces.impl.dtd.XMLElementDecl;
import org.apache.xerces.impl.dtd.XMLEntityDecl;
import org.apache.xerces.impl.dtd.XMLNotationDecl;
import org.apache.xerces.impl.dtd.XMLSimpleType;
import org.apache.xerces.impl.dv.dtd.DatatypeValidatorFactory;
import org.apache.xerces.util.SymbolTable;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLDTDContentModelHandler;
import org.apache.xerces.xni.XMLDTDHandler;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XMLString;
import org.apache.xerces.xni.XNIException;

public class DTDGrammar
extends Grammar
implements XMLDTDHandler,
XMLDTDContentModelHandler {
    private static final int CHUNK_SHIFT = 8;
    private static final int CHUNK_SIZE = 256;
    private static final int CHUNK_MASK = 255;
    private static final int INITIAL_CHUNK_COUNT = 4;
    private static final boolean DEBUG = false;
    protected DatatypeValidatorFactory fDatatypeValidatorFactory;
    protected int fCurrentElementIndex;
    protected int fCurrentAttributeIndex;
    protected boolean fReadingExternalDTD = false;
    private boolean fMixed;
    private XMLElementDecl fElementDecl = new XMLElementDecl();
    private XMLAttributeDecl fAttributeDecl = new XMLAttributeDecl();
    private QName fQName = new QName();
    private XMLEntityDecl fEntityDecl = new XMLEntityDecl();
    private XMLSimpleType fSimpleType = new XMLSimpleType();
    private XMLContentSpec fContentSpec = new XMLContentSpec();
    Hashtable fAttributeDeclTab = new Hashtable();
    Hashtable fElementDeclTab = new Hashtable();
    Hashtable fNotationDeclTab = new Hashtable();
    Hashtable fSimpleTypeTab = new Hashtable();
    Hashtable fEntityDeclTab = new Hashtable();
    private short[] fOpStack = null;
    private int[] fNodeIndexStack = null;
    private int[] fPrevNodeIndexStack = null;
    private int fDepth = 0;
    private boolean[] fPEntityStack = new boolean[4];
    private int fPEDepth = 0;
    private int[][] fElementDeclIsExternal = new int[4][];
    private int[][] fAttributeDeclIsExternal = new int[4][];
    int valueIndex = -1;
    int prevNodeIndex = -1;
    int nodeIndex = -1;

    public DTDGrammar(SymbolTable symbolTable) {
        super(symbolTable);
        this.setTargetNamespace("");
    }

    public void setDatatypeValidatorFactory(DatatypeValidatorFactory factory) {
        this.fDatatypeValidatorFactory = factory;
    }

    public boolean getElementDeclIsExternal(int elementDeclIndex) {
        if (elementDeclIndex < 0) {
            return false;
        }
        int chunk = elementDeclIndex >> 8;
        int index = elementDeclIndex & 0xFF;
        return this.fElementDeclIsExternal[chunk][index] != 0;
    }

    public boolean getAttributeDeclIsExternal(int attributeDeclIndex) {
        if (attributeDeclIndex < 0) {
            return false;
        }
        int chunk = attributeDeclIndex >> 8;
        int index = attributeDeclIndex & 0xFF;
        return this.fAttributeDeclIsExternal[chunk][index] != 0;
    }

    public int getAttributeDeclIndex(int elementDeclIndex, String attributeDeclName) {
        if (elementDeclIndex == -1) {
            return -1;
        }
        int attDefIndex = this.getFirstAttributeDeclIndex(elementDeclIndex);
        while (attDefIndex != -1) {
            this.getAttributeDecl(attDefIndex, this.fAttributeDecl);
            if (this.fAttributeDecl.name.rawname == attributeDeclName || attributeDeclName.equals(this.fAttributeDecl.name.rawname)) {
                return attDefIndex;
            }
            attDefIndex = this.getNextAttributeDeclIndex(attDefIndex);
        }
        return -1;
    }

    public void startDTD(XMLLocator locator) throws XNIException {
        this.fOpStack = null;
        this.fNodeIndexStack = null;
        this.fPrevNodeIndexStack = null;
    }

    public void startEntity(String name, String publicId, String systemId, String baseSystemId, String encoding) throws XNIException {
        if (name.startsWith("%")) {
            if (this.fPEDepth == this.fPEntityStack.length) {
                boolean[] entityarray = new boolean[this.fPEntityStack.length * 2];
                System.arraycopy(this.fPEntityStack, 0, entityarray, 0, this.fPEntityStack.length);
                this.fPEntityStack = entityarray;
            }
            this.fPEntityStack[this.fPEDepth] = this.fReadingExternalDTD;
            ++this.fPEDepth;
        }
        if (name.equals("[dtd]") || name.startsWith("%") && systemId != null) {
            this.fReadingExternalDTD = true;
        }
    }

    public void endEntity(String name) throws XNIException {
        if (name.equals("[dtd]")) {
            this.fReadingExternalDTD = false;
        }
        if (name.startsWith("%")) {
            --this.fPEDepth;
            this.fReadingExternalDTD = this.fPEntityStack[this.fPEDepth];
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void elementDecl(String name, String contentModel) throws XNIException {
        XMLElementDecl tmpElementDecl = (XMLElementDecl)this.fElementDeclTab.get(name);
        if (tmpElementDecl != null) {
            if (tmpElementDecl.type != -1) return;
            this.fCurrentElementIndex = this.getElementDeclIndex(name, -1);
        } else {
            this.fCurrentElementIndex = this.createElementDecl();
        }
        XMLElementDecl elementDecl = new XMLElementDecl();
        QName elementName = new QName(null, name, name, null);
        elementDecl.name.setValues(elementName);
        elementDecl.contentModelValidator = null;
        elementDecl.scope = -1;
        if (contentModel.equals("EMPTY")) {
            elementDecl.type = 1;
        } else if (contentModel.equals("ANY")) {
            elementDecl.type = 0;
        } else if (contentModel.startsWith("(")) {
            elementDecl.type = contentModel.indexOf("#PCDATA") > 0 ? (short)2 : (short)3;
        }
        this.fElementDeclTab.put(name, elementDecl);
        this.fElementDecl = elementDecl;
        if ((this.fDepth == 0 || this.fDepth == 1 && elementDecl.type == 2) && this.fNodeIndexStack != null) {
            if (elementDecl.type == 2) {
                int pcdata = this.addUniqueLeafNode(null);
                this.fNodeIndexStack[0] = this.fNodeIndexStack[0] == -1 ? pcdata : this.addContentSpecNode((short)4, pcdata, this.fNodeIndexStack[0]);
            }
            this.setContentSpecIndex(this.fCurrentElementIndex, this.fNodeIndexStack[this.fDepth]);
        }
        this.setElementDecl(this.fCurrentElementIndex, this.fElementDecl);
        int chunk = this.fCurrentElementIndex >> 8;
        int index = this.fCurrentElementIndex & 0xFF;
        this.ensureElementDeclCapacity(chunk);
        this.fElementDeclIsExternal[chunk][index] = this.fReadingExternalDTD ? 1 : 0;
    }

    public void attributeDecl(String elementName, String attributeName, String type, String[] enumeration, String defaultType, XMLString defaultValue) throws XNIException {
        if (!this.fElementDeclTab.containsKey(elementName)) {
            this.fCurrentElementIndex = this.createElementDecl();
            XMLElementDecl elementDecl = new XMLElementDecl();
            elementDecl.name.setValues(null, elementName, elementName, null);
            elementDecl.scope = -1;
            this.fElementDeclTab.put(elementName, elementDecl);
            this.setElementDecl(this.fCurrentElementIndex, elementDecl);
        }
        int elementIndex = this.getElementDeclIndex(elementName, -1);
        if (this.getAttributeDeclIndex(elementIndex, attributeName) != -1) {
            return;
        }
        this.fCurrentAttributeIndex = this.createAttributeDecl();
        this.fSimpleType.clear();
        if (defaultType != null) {
            if (defaultType.equals("#FIXED")) {
                this.fSimpleType.defaultType = 1;
            } else if (defaultType.equals("#IMPLIED")) {
                this.fSimpleType.defaultType = 0;
            } else if (defaultType.equals("#REQUIRED")) {
                this.fSimpleType.defaultType = (short)2;
            }
        }
        this.fSimpleType.defaultValue = defaultValue.length >= 0 ? defaultValue.toString() : null;
        this.fSimpleType.enumeration = enumeration;
        Hashtable<String, String[]> facets = new Hashtable<String, String[]>();
        if (type.equals("CDATA")) {
            this.fSimpleType.type = 0;
        } else if (type.equals("ID")) {
            this.fSimpleType.type = (short)3;
        } else if (type.startsWith("IDREF")) {
            this.fSimpleType.type = (short)4;
            if (type.indexOf("S") > 0) {
                this.fSimpleType.list = true;
            }
        } else if (type.equals("ENTITIES")) {
            this.fSimpleType.type = 1;
            this.fSimpleType.list = true;
        } else if (type.equals("ENTITY")) {
            this.fSimpleType.type = 1;
        } else if (type.equals("NMTOKENS")) {
            this.fSimpleType.type = (short)5;
            this.fSimpleType.list = true;
        } else if (type.equals("NMTOKEN")) {
            this.fSimpleType.type = (short)5;
        } else if (type.startsWith("NOTATION")) {
            this.fSimpleType.type = (short)6;
            facets.put("enumeration", this.fSimpleType.enumeration);
        } else if (type.startsWith("ENUMERATION")) {
            this.fSimpleType.type = (short)2;
            facets.put("enumeration", this.fSimpleType.enumeration);
        } else {
            System.err.println("!!! unknown attribute type " + type);
        }
        this.fQName.setValues(null, attributeName, attributeName, null);
        this.fAttributeDecl.setValues(this.fQName, this.fSimpleType, false);
        this.setAttributeDecl(elementIndex, this.fCurrentAttributeIndex, this.fAttributeDecl);
        int chunk = this.fCurrentAttributeIndex >> 8;
        int index = this.fCurrentAttributeIndex & 0xFF;
        this.ensureAttributeDeclCapacity(chunk);
        this.fAttributeDeclIsExternal[chunk][index] = this.fReadingExternalDTD ? 1 : 0;
    }

    public void internalEntityDecl(String name, XMLString text, XMLString nonNormalizedText) throws XNIException {
        XMLEntityDecl entityDecl = new XMLEntityDecl();
        boolean isPE = name.startsWith("%");
        boolean inExternal = this.fReadingExternalDTD;
        entityDecl.setValues(name, null, null, null, null, text.toString(), isPE, inExternal);
        int entityIndex = this.getEntityDeclIndex(name);
        if (entityIndex == -1) {
            entityIndex = this.createEntityDecl();
            this.setEntityDecl(entityIndex, entityDecl);
        }
    }

    public void externalEntityDecl(String name, String publicId, String systemId, String baseSystemId) throws XNIException {
        XMLEntityDecl entityDecl = new XMLEntityDecl();
        boolean isPE = name.startsWith("%");
        boolean inExternal = this.fReadingExternalDTD;
        entityDecl.setValues(name, publicId, systemId, baseSystemId, null, null, isPE, inExternal);
        int entityIndex = this.getEntityDeclIndex(name);
        if (entityIndex == -1) {
            entityIndex = this.createEntityDecl();
            this.setEntityDecl(entityIndex, entityDecl);
        }
    }

    public void unparsedEntityDecl(String name, String publicId, String systemId, String notation) throws XNIException {
        XMLEntityDecl entityDecl = new XMLEntityDecl();
        boolean isPE = name.startsWith("%");
        boolean inExternal = this.fReadingExternalDTD;
        entityDecl.setValues(name, publicId, systemId, null, notation, null, isPE, inExternal);
        int entityIndex = this.getEntityDeclIndex(name);
        if (entityIndex == -1) {
            entityIndex = this.createEntityDecl();
            this.setEntityDecl(entityIndex, entityDecl);
        }
    }

    public void notationDecl(String name, String publicId, String systemId) throws XNIException {
        XMLNotationDecl notationDecl = new XMLNotationDecl();
        notationDecl.setValues(name, publicId, systemId);
        int notationIndex = this.getNotationDeclIndex(name);
        if (notationIndex == -1) {
            notationIndex = this.createNotationDecl();
            this.setNotationDecl(notationIndex, notationDecl);
        }
    }

    public void endDTD() throws XNIException {
    }

    public void textDecl(String version, String encoding) throws XNIException {
    }

    public void comment(XMLString text) throws XNIException {
    }

    public void processingInstruction(String target, XMLString data) throws XNIException {
    }

    public void startAttlist(String elementName) throws XNIException {
    }

    public void endAttlist() throws XNIException {
    }

    public void startConditional(short type) throws XNIException {
    }

    public void characters(XMLString text) throws XNIException {
    }

    public void endConditional() throws XNIException {
    }

    public void startContentModel(String elementName) throws XNIException {
        XMLElementDecl elementDecl = (XMLElementDecl)this.fElementDeclTab.get(elementName);
        if (elementDecl != null) {
            this.fElementDecl = elementDecl;
        }
        this.fDepth = 0;
        this.initializeContentModelStack();
    }

    public void startGroup() throws XNIException {
        ++this.fDepth;
        this.initializeContentModelStack();
        this.fMixed = false;
    }

    public void pcdata() throws XNIException {
        this.fMixed = true;
    }

    public void element(String elementName) throws XNIException {
        this.fNodeIndexStack[this.fDepth] = this.fMixed ? (this.fNodeIndexStack[this.fDepth] == -1 ? this.addUniqueLeafNode(elementName) : this.addContentSpecNode((short)4, this.fNodeIndexStack[this.fDepth], this.addUniqueLeafNode(elementName))) : this.addContentSpecNode((short)0, elementName);
    }

    public void separator(short separator) throws XNIException {
        if (!this.fMixed) {
            if (this.fOpStack[this.fDepth] != 5 && separator == 0) {
                if (this.fPrevNodeIndexStack[this.fDepth] != -1) {
                    this.fNodeIndexStack[this.fDepth] = this.addContentSpecNode(this.fOpStack[this.fDepth], this.fPrevNodeIndexStack[this.fDepth], this.fNodeIndexStack[this.fDepth]);
                }
                this.fPrevNodeIndexStack[this.fDepth] = this.fNodeIndexStack[this.fDepth];
                this.fOpStack[this.fDepth] = 4;
            } else if (this.fOpStack[this.fDepth] != 4 && separator == 1) {
                if (this.fPrevNodeIndexStack[this.fDepth] != -1) {
                    this.fNodeIndexStack[this.fDepth] = this.addContentSpecNode(this.fOpStack[this.fDepth], this.fPrevNodeIndexStack[this.fDepth], this.fNodeIndexStack[this.fDepth]);
                }
                this.fPrevNodeIndexStack[this.fDepth] = this.fNodeIndexStack[this.fDepth];
                this.fOpStack[this.fDepth] = 5;
            }
        }
    }

    public void occurrence(short occurrence) throws XNIException {
        if (!this.fMixed) {
            if (occurrence == 2) {
                this.fNodeIndexStack[this.fDepth] = this.addContentSpecNode((short)1, this.fNodeIndexStack[this.fDepth], -1);
            } else if (occurrence == 3) {
                this.fNodeIndexStack[this.fDepth] = this.addContentSpecNode((short)2, this.fNodeIndexStack[this.fDepth], -1);
            } else if (occurrence == 4) {
                this.fNodeIndexStack[this.fDepth] = this.addContentSpecNode((short)3, this.fNodeIndexStack[this.fDepth], -1);
            }
        }
    }

    public void endGroup() throws XNIException {
        if (!this.fMixed) {
            int nodeIndex;
            if (this.fPrevNodeIndexStack[this.fDepth] != -1) {
                this.fNodeIndexStack[this.fDepth] = this.addContentSpecNode(this.fOpStack[this.fDepth], this.fPrevNodeIndexStack[this.fDepth], this.fNodeIndexStack[this.fDepth]);
            }
            this.fNodeIndexStack[this.fDepth] = nodeIndex = this.fNodeIndexStack[this.fDepth--];
        }
    }

    public void any() throws XNIException {
    }

    public void empty() throws XNIException {
    }

    public void endContentModel() throws XNIException {
    }

    public boolean isNamespaceAware() {
        return false;
    }

    public int getElementDeclIndex(QName elementDeclQName, int scope) {
        return this.getElementDeclIndex(elementDeclQName.rawname, scope);
    }

    protected int addContentSpecNode(short nodeType, String nodeValue) {
        int contentSpecIndex = this.createContentSpec();
        this.fContentSpec.setValues(nodeType, nodeValue, null);
        this.setContentSpec(contentSpecIndex, this.fContentSpec);
        return contentSpecIndex;
    }

    protected int addUniqueLeafNode(String elementName) {
        int contentSpecIndex = this.createContentSpec();
        this.fContentSpec.setValues((short)0, elementName, null);
        this.setContentSpec(contentSpecIndex, this.fContentSpec);
        return contentSpecIndex;
    }

    protected int addContentSpecNode(short nodeType, int leftNodeIndex, int rightNodeIndex) {
        int contentSpecIndex = this.createContentSpec();
        int[] leftIntArray = new int[1];
        int[] rightIntArray = new int[1];
        leftIntArray[0] = leftNodeIndex;
        rightIntArray[0] = rightNodeIndex;
        this.fContentSpec.setValues(nodeType, leftIntArray, rightIntArray);
        this.setContentSpec(contentSpecIndex, this.fContentSpec);
        return contentSpecIndex;
    }

    protected void initializeContentModelStack() {
        if (this.fOpStack == null) {
            this.fOpStack = new short[8];
            this.fNodeIndexStack = new int[8];
            this.fPrevNodeIndexStack = new int[8];
        } else if (this.fDepth == this.fOpStack.length) {
            short[] newStack = new short[this.fDepth * 2];
            System.arraycopy(this.fOpStack, 0, newStack, 0, this.fDepth);
            this.fOpStack = newStack;
            int[] newIntStack = new int[this.fDepth * 2];
            System.arraycopy(this.fNodeIndexStack, 0, newIntStack, 0, this.fDepth);
            this.fNodeIndexStack = newIntStack;
            newIntStack = new int[this.fDepth * 2];
            System.arraycopy(this.fPrevNodeIndexStack, 0, newIntStack, 0, this.fDepth);
            this.fPrevNodeIndexStack = newIntStack;
        }
        this.fOpStack[this.fDepth] = -1;
        this.fNodeIndexStack[this.fDepth] = -1;
        this.fPrevNodeIndexStack[this.fDepth] = -1;
    }

    protected boolean ensureElementDeclCapacity(int chunk) {
        try {
            return this.fElementDeclIsExternal[chunk][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fElementDeclIsExternal = this.resize(this.fElementDeclIsExternal, this.fElementDeclIsExternal.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fElementDeclIsExternal[chunk] = new int[256];
        return true;
    }

    protected boolean ensureAttributeDeclCapacity(int chunk) {
        try {
            return this.fAttributeDeclIsExternal[chunk][0] == 0;
        }
        catch (ArrayIndexOutOfBoundsException ex) {
            this.fAttributeDeclIsExternal = this.resize(this.fAttributeDeclIsExternal, this.fAttributeDeclIsExternal.length * 2);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        this.fAttributeDeclIsExternal[chunk] = new int[256];
        return true;
    }

    protected int[][] resize(int[][] array, int newsize) {
        int[][] newarray = new int[newsize][];
        System.arraycopy(array, 0, newarray, 0, array.length);
        return newarray;
    }
}

